<?php
  use Illuminate\Support\Facades\Route;
?>

<ul class="menu-sub">
  <?php if(isset($menu)): ?>
    <?php $__currentLoopData = $menu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      
      <?php
        $activeClass = null;
        $active = $configData['layout'] === 'vertical' ? 'active open' : 'active';
        $currentRouteName = Route::currentRouteName();
        $currentUrl = request()->path();

        // Check by route name (exact match)
        if (isset($submenu->slug) && $currentRouteName === $submenu->slug) {
            $activeClass = 'active';
        }
        // Also check by URL path
        elseif (isset($submenu->url)) {
            $submenuUrl = ltrim(parse_url($submenu->url, PHP_URL_PATH), '/');
            // Remove leading slash from current URL for comparison
            $cleanCurrentUrl = ltrim($currentUrl, '/');
            $cleanSubmenuUrl = ltrim($submenuUrl, '/');
            
            // Only match if exact or if current URL starts with submenu URL followed by a slash
            if ($cleanCurrentUrl === $cleanSubmenuUrl || 
                ($cleanSubmenuUrl !== '' && str_starts_with($cleanCurrentUrl, $cleanSubmenuUrl) && 
                 (strlen($cleanCurrentUrl) === strlen($cleanSubmenuUrl) || $cleanCurrentUrl[strlen($cleanSubmenuUrl)] === '/'))) {
                $activeClass = 'active';
            }
        }
        // Check nested submenu
        elseif (isset($submenu->submenu)) {
            if (gettype($submenu->slug) === 'array') {
                foreach ($submenu->slug as $slug) {
                    if ($currentRouteName === $slug || (str_starts_with($currentRouteName, $slug) && strlen($currentRouteName) > strlen($slug) && $currentRouteName[strlen($slug)] === '-')) {
                        $activeClass = $active;
                    }
                }
            } else {
                if (
                    isset($submenu->slug) &&
                    ($currentRouteName === $submenu->slug || (str_starts_with($currentRouteName, $submenu->slug) && strlen($currentRouteName) > strlen($submenu->slug) && $currentRouteName[strlen($submenu->slug)] === '-'))
                ) {
                    $activeClass = $active;
                }
            }
        }
      ?>

      <li class="menu-item <?php echo e($activeClass); ?>">
        <a href="<?php echo e(isset($submenu->url) ? url($submenu->url) : 'javascript:void(0)'); ?>"
          class="<?php echo e(isset($submenu->submenu) ? 'menu-link menu-toggle' : 'menu-link'); ?>"
          <?php if(isset($submenu->target) and !empty($submenu->target)): ?> target="_blank" <?php endif; ?>>
          <?php if(isset($submenu->icon)): ?>
            <i class="<?php echo e($submenu->icon); ?>"></i>
          <?php endif; ?>
          <div><?php echo e(isset($submenu->name) ? __($submenu->name) : ''); ?></div>
          <?php if(isset($submenu->badge)): ?>
            <div class="badge bg-<?php echo e($submenu->badge[0]); ?> rounded-pill ms-auto"><?php echo e($submenu->badge[1]); ?></div>
          <?php endif; ?>
        </a>

        
        <?php if(isset($submenu->submenu)): ?>
          <?php echo $__env->make('layouts.sections.menu.submenu', ['menu' => $submenu->submenu], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endif; ?>
      </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php endif; ?>
</ul>
<?php /**PATH /Users/niranjan/mydevelopments/chalana-tool-station/resources/views/layouts/sections/menu/submenu.blade.php ENDPATH**/ ?>