<?php $__env->startSection('title', 'Users - Equipment Renting System'); ?>

<!-- Vendor Styles -->
<?php $__env->startSection('vendor-style'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/datatables-rowgroup-bs5/rowgroup.bootstrap5.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss', 'resources/assets/vendor/libs/select2/select2.scss']); ?>
<?php $__env->stopSection(); ?>

<!-- Vendor Scripts -->
<?php $__env->startSection('vendor-script'); ?>
  <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js', 'resources/assets/vendor/libs/select2/select2.js']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-style'); ?>
  <style>
    .select2-container {
      z-index: 9999 !important;
    }

    .select2-dropdown {
      z-index: 9999 !important;
    }
  </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <!-- DataTable with Buttons -->
  <div class="card">
    <div class="card-datatable text-nowrap">
      <table class="datatables-basic table table-bordered table-responsive">
        <thead>
          <tr>
            <th></th>
            <th></th>
            <th>ID</th>
            <th>Name</th>
            <th>Email</th>
            <th>Role</th>
            <th>Shop</th>
            <th>Phone</th>
            <th>Status</th>
            <th class="d-flex align-items-center">Action</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr data-user-id="<?php echo e($user->id); ?>">
              <td></td>
              <td><input type="checkbox" class="dt-checkboxes form-check-input"></td>
              <td><?php echo e($loop->iteration + ($users->currentPage() - 1) * $users->perPage()); ?></td>
              <td>
                <div class="d-flex justify-content-start align-items-center user-name">
                  <div class="avatar-wrapper">
                    <div class="avatar me-2">
                      <span class="avatar-initial rounded-circle bg-label-primary">
                        <?php echo e(strtoupper(substr($user->name, 0, 2))); ?>

                      </span>
                    </div>
                  </div>
                  <div class="d-flex flex-column">
                    <span class="user_name text-truncate h6 mb-0"><?php echo e($user->name); ?></span>
                    <small class="user_email text-truncate"><?php echo e($user->email); ?></small>
                  </div>
                </div>
              </td>
              <td><?php echo e($user->email); ?></td>
              <td data-id="<?php echo e($user->role_id); ?>">
                <?php echo e($user->role?->display_name ?? $user->role?->name ?? 'N/A'); ?>

              </td>
              <td data-id="<?php echo e($user->shop_id ?? ''); ?>">
                <?php echo e($user->shop?->name ?? 'N/A'); ?>

              </td>
              <td><?php echo e($user->phone ?? 'N/A'); ?></td>
              <td>
                <?php if($user->locked): ?>
                  <span class="badge bg-label-danger">Locked</span>
                <?php elseif($user->approved): ?>
                  <span class="badge bg-label-success">Active</span>
                <?php else: ?>
                  <span class="badge bg-label-warning">Pending</span>
                <?php endif; ?>
              </td>
              <td>
                <div class="d-inline-block">
                  <a href="javascript:;"
                    class="btn btn-sm btn-text-secondary rounded-pill btn-icon dropdown-toggle hide-arrow"
                    data-bs-toggle="dropdown">
                    <i class="icon-base ri ri-more-2-line icon-20px"></i>
                  </a>
                  <ul class="dropdown-menu dropdown-menu-end m-0">
                    <li><a href="javascript:;" class="dropdown-item item-details">Details</a></li>
                    <div class="dropdown-divider"></div>
                    <li><a href="javascript:;" class="dropdown-item text-danger delete-record"
                        data-id="<?php echo e($user->id); ?>">Delete</a></li>
                  </ul>
                </div>
                <a href="javascript:;" class="btn btn-sm btn-text-secondary rounded-pill btn-icon item-edit">
                  <i class="icon-base ri ri-edit-box-line icon-20px"></i>
                </a>
              </td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>
  </div>
  <!-- Modal to add/edit user record -->
  <div class="offcanvas offcanvas-end" id="add-new-record">
    <div class="offcanvas-header border-bottom">
      <h5 class="offcanvas-title" id="formTitle">New User</h5>
      <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body flex-grow-1">
      <form method="POST" class="add-new-record pt-0 row g-3" id="userForm">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="_method" id="methodField" value="POST">
        <input type="hidden" id="userId" name="userId" />

        <div class="col-sm-12 form-control-validation">
          <div class="input-group input-group-merge">
            <span id="basicName2" class="input-group-text">
              <i class="icon-base ri ri-user-line icon-18px"></i>
            </span>
            <div class="form-floating form-floating-outline">
              <input type="text" id="basicName" class="form-control dt-name" name="basicName"
                placeholder="Full Name" aria-label="Full Name" aria-describedby="basicName2" />
              <label for="basicName">Full Name</label>
            </div>
          </div>
        </div>

        <div class="col-sm-12 form-control-validation">
          <div class="input-group input-group-merge">
            <span id="basicEmail2" class="input-group-text">
              <i class="icon-base ri ri-mail-line icon-18px"></i>
            </span>
            <div class="form-floating form-floating-outline">
              <input type="email" id="basicEmail" name="basicEmail" class="form-control dt-email" placeholder="Email"
                aria-label="Email" aria-describedby="basicEmail2" />
              <label for="basicEmail">Email</label>
            </div>
          </div>
        </div>

        <div class="col-sm-12 form-control-validation">
          <div class="input-group input-group-merge">
            <span id="basicPassword2" class="input-group-text">
              <i class="icon-base ri ri-lock-line icon-18px"></i>
            </span>
            <div class="form-floating form-floating-outline">
              <input type="password" id="basicPassword" name="basicPassword" class="form-control dt-password"
                placeholder="Password" aria-label="Password" aria-describedby="basicPassword2" />
              <label for="basicPassword">Password <span id="passwordRequired" class="text-danger">*</span></label>
            </div>
          </div>
        </div>

        <div class="col-sm-12 form-control-validation">
          <div class="input-group input-group-merge">
            <span id="basicRole2" class="input-group-text">
              <i class="icon-base ri ri-shield-user-line icon-18px"></i>
            </span>
            <div class="form-floating form-floating-outline">
              <select id="basicRole" name="basicRole" class="select2 form-select dt-role"
                placeholder="Role" aria-label="Role" aria-describedby="basicRole2" data-allow-clear="false">
                <option value=""></option>
                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($role->id); ?>"><?php echo e($role->display_name ?? $role->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
              <label for="basicRole" class="form-label">Role</label>
            </div>
          </div>
        </div>

        <div class="col-sm-12 form-control-validation">
          <div class="input-group input-group-merge">
            <span id="basicShop2" class="input-group-text">
              <i class="icon-base ri ri-store-2-line icon-18px"></i>
            </span>
            <div class="form-floating form-floating-outline">
              <select id="basicShop" name="basicShop" class="select2 form-select dt-shop"
                placeholder="Shop (Optional)" aria-label="Shop" aria-describedby="basicShop2" data-allow-clear="true">
                <option value=""></option>
                <?php $__currentLoopData = $shops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($shop->id); ?>"><?php echo e($shop->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
              <label for="basicShop" class="form-label">Shop (Optional)</label>
            </div>
          </div>
        </div>

        <div class="col-sm-12 form-control-validation">
          <div class="input-group input-group-merge">
            <span id="basicPhone2" class="input-group-text">
              <i class="icon-base ri ri-phone-line icon-18px"></i>
            </span>
            <div class="form-floating form-floating-outline">
              <input type="tel" id="basicPhone" name="basicPhone" class="form-control dt-phone"
                placeholder="Phone" aria-label="Phone" aria-describedby="basicPhone2" />
              <label for="basicPhone">Phone</label>
            </div>
          </div>
        </div>

        <div class="col-sm-12 form-control-validation">
          <div class="form-check form-switch">
            <input class="form-check-input dt-approved" type="checkbox" id="basicApproved" name="basicApproved" />
            <label class="form-check-label" for="basicApproved">Approved</label>
          </div>
        </div>

        <div class="col-sm-12 form-control-validation">
          <div class="form-check form-switch">
            <input class="form-check-input dt-locked" type="checkbox" id="basicLocked" name="basicLocked" />
            <label class="form-check-label" for="basicLocked">Locked</label>
          </div>
        </div>

        <div class="col-sm-12">
          <label class="form-label">Profile Image</label>
          <input type="file" id="profileImage" name="profile_image" class="form-control" accept="image/jpeg,image/jpg,image/png" />
          <small class="text-muted">Max size: 1MB (JPG, PNG only)</small>
          <div id="profileImagePreview" class="mt-2"></div>
        </div>

        <div class="col-sm-12 mt-4">
          <label class="form-label">Documents</label>
          <div class="mb-3">
            <select id="documentType" class="form-select form-select-sm mb-2">
              <option value="">Select Document Type</option>
              <option value="character_certificate">Character Certificate</option>
              <option value="birth_certificate">Birth Certificate</option>
              <option value="nic">NIC</option>
              <option value="passport">Passport</option>
              <option value="driving_license">Driving License</option>
              <option value="other">Other</option>
            </select>
            <input type="file" id="documentFiles" class="form-control" accept=".jpg,.jpeg,.png,.pdf" multiple />
            <small class="text-muted">Max size: 1MB per file (JPG, PNG, PDF only)</small>
          </div>
          <div id="uploadedDocuments" class="mt-3"></div>
        </div>

        <div class="col-sm-12">
          <button type="submit" id="submitBtn" class="btn btn-primary data-submit me-sm-4 me-1">Submit</button>
          <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="offcanvas">Cancel</button>
        </div>
      </form>
    </div>
  </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
  <script>
    'use strict';

    let fv, offCanvasEl, formAddNewRecord;
    // File upload handling - declare in global scope
    let uploadedDocuments = [];
    let currentUserId = null;

    document.addEventListener('DOMContentLoaded', function(e) {
      (function() {
        formAddNewRecord = document.getElementById('userForm');

        var form = document.getElementById('userForm');

        form.addEventListener('submit', function(e) {
          e.preventDefault();
        });

        setTimeout(() => {
          const newRecord = document.querySelector('.create-new-form-btn'),
            offCanvasElement = document.querySelector('#add-new-record');

          if (newRecord) {
            newRecord.addEventListener('click', function() {
              offCanvasEl = new bootstrap.Offcanvas(offCanvasElement);
              document.getElementById('formTitle').textContent = 'New User';
              document.getElementById('userId').value = '';
              formAddNewRecord.reset();
              document.getElementById('passwordRequired').style.display = 'inline';
              document.getElementById('basicPassword').required = true;
              uploadedDocuments = [];
              window.displayUploadedDocuments();
              const profilePreview = document.getElementById('profileImagePreview');
              if (profilePreview) profilePreview.innerHTML = '';
              offCanvasEl.show();
            });
          }
        }, 200);

        fv = FormValidation.formValidation(formAddNewRecord, {
          fields: {
            basicName: {
              validators: {
                notEmpty: {
                  message: 'Name is required'
                }
              }
            },
            basicEmail: {
              validators: {
                notEmpty: {
                  message: 'Email is required'
                },
                emailAddress: {
                  message: 'Please enter a valid email address'
                }
              }
            },
            basicPassword: {
              validators: {
                callback: {
                  message: 'Password is required',
                  callback: function(value, validator, $field) {
                    const userId = document.getElementById('userId').value;
                    if (!userId && !value) {
                      return false;
                    }
                    return true;
                  }
                },
                stringLength: {
                  min: 8,
                  message: 'Password must be at least 8 characters'
                }
              }
            },
            basicRole: {
              validators: {
                notEmpty: {
                  message: 'Role is required'
                }
              }
            }
          },
          plugins: {
            trigger: new FormValidation.plugins.Trigger(),
            bootstrap5: new FormValidation.plugins.Bootstrap5({
              eleValidClass: '',
              rowSelector: '.form-control-validation'
            }),
            submitButton: new FormValidation.plugins.SubmitButton(),
            autoFocus: new FormValidation.plugins.AutoFocus()
          },
          init: instance => {
            instance.on('plugins.message.placed', function(e) {
              if (e.element.parentElement.classList.contains('input-group')) {
                e.element.parentElement.insertAdjacentElement('afterend', e.messageElement);
              }
            });
          }
        });
      })();

      const dt_basic_table = document.querySelector('.datatables-basic');
      let dt_basic;

      if (dt_basic_table) {
        let tableTitle = document.createElement('h5');
        tableTitle.classList.add('card-title', 'mb-0', 'text-md-start', 'text-center');
        tableTitle.innerHTML = 'Users';

        dt_basic = new DataTable(dt_basic_table, {
          columns: [{
              data: 'id'
            },
            {
              data: 'id',
              orderable: false,
              render: DataTable.render.select()
            },
            {
              data: 'id'
            },
            {
              data: 'name'
            },
            {
              data: 'email'
            },
            {
              data: 'role'
            },
            {
              data: 'shop'
            },
            {
              data: 'phone'
            },
            {
              data: 'status'
            },
            {
              data: 'id'
            }
          ],
          columnDefs: [{
              className: 'control',
              orderable: false,
              searchable: false,
              responsivePriority: 2,
              targets: 0,
              render: function(data, type, full, meta) {
                return '';
              }
            },
            {
              targets: 1,
              orderable: false,
              searchable: false,
              responsivePriority: 3,
              checkboxes: true,
              render: function() {
                return '<input type="checkbox" class="dt-checkboxes form-check-input">';
              },
              checkboxes: {
                selectAllRender: '<input type="checkbox" class="form-check-input">'
              }
            },
            {
              targets: 2,
              searchable: false,
              visible: false
            },
            {
              responsivePriority: 1,
              targets: 3
            },
            {
              targets: -1,
              title: 'Actions',
              orderable: false,
              searchable: false,
              className: 'd-flex align-items-center',
              render: function(data, type, full, meta) {
                return data;
              }
            }
          ],
          select: {
            style: 'multi',
            selector: 'td:nth-child(2)'
          },
          order: [
            [2, 'desc']
          ],
          layout: {
            top2Start: {
              rowClass: 'row card-header mx-0 px-2',
              features: [tableTitle]
            },
            top2End: {
              features: [{
                buttons: [{
                    extend: 'collection',
                    className: 'btn btn-label-primary dropdown-toggle me-4 waves-effect border-none',
                    text: '<span class="d-flex align-items-center gap-2"><i class="icon-base ri ri-external-link-line icon-18px"></i> <span class="d-none d-sm-inline-block">Export</span></span>',
                    buttons: [{
                        extend: 'print',
                        text: `<span class="d-flex align-items-center"><i class="icon-base ri ri-printer-line me-1"></i>Print</span>`,
                        className: 'dropdown-item',
                        exportOptions: {
                          columns: [3, 4, 5, 6, 7, 8]
                        }
                      },
                      {
                        extend: 'csv',
                        text: `<span class="d-flex align-items-center"><i class="icon-base ri ri-file-text-line me-1"></i>Csv</span>`,
                        className: 'dropdown-item',
                        exportOptions: {
                          columns: [3, 4, 5, 6, 7, 8]
                        }
                      },
                      {
                        extend: 'excel',
                        text: `<span class="d-flex align-items-center"><i class="icon-base ri ri-file-excel-line me-1"></i>Excel</span>`,
                        className: 'dropdown-item',
                        exportOptions: {
                          columns: [3, 4, 5, 6, 7, 8]
                        }
                      },
                      {
                        extend: 'pdf',
                        text: `<span class="d-flex align-items-center"><i class="icon-base ri ri-file-pdf-line me-1"></i>Pdf</span>`,
                        className: 'dropdown-item',
                        exportOptions: {
                          columns: [3, 4, 5, 6, 7, 8]
                        }
                      },
                      {
                        extend: 'copy',
                        text: `<i class="icon-base ri ri-file-copy-line me-1"></i>Copy`,
                        className: 'dropdown-item',
                        exportOptions: {
                          columns: [3, 4, 5, 6, 7, 8]
                        }
                      }
                    ]
                  },
                  {
                    text: '<span class="d-flex align-items-center"><i class="icon-base ri ri-add-line icon-18px me-sm-1"></i><span class="d-none d-sm-inline-block">Add New Record</span></span>',
                    className: 'create-new-form-btn btn btn-primary'
                  }
                ]
              }]
            },
            topStart: {
              rowClass: 'row m-3 mx-2 my-0 justify-content-between',
              features: [{
                pageLength: {
                  menu: [7, 10, 25, 50, 100],
                  text: 'Show_MENU_entries'
                }
              }]
            },
            topEnd: {
              search: {
                placeholder: 'Type search here'
              }
            },
            bottomStart: {
              rowClass: 'row mx-3 justify-content-between',
              features: ['info']
            },
            bottomEnd: 'paging'
          },
          displayLength: 7,
          language: {
            paginate: {
              next: '<i class="icon-base ri ri-arrow-right-s-line scaleX-n1-rtl icon-22px"></i>',
              previous: '<i class="icon-base ri ri-arrow-left-s-line scaleX-n1-rtl icon-22px"></i>',
              first: '<i class="icon-base ri ri-skip-back-mini-line scaleX-n1-rtl icon-22px"></i>',
              last: '<i class="icon-base ri ri-skip-forward-mini-line scaleX-n1-rtl icon-22px"></i>'
            }
          },
          responsive: {
            details: {
              display: DataTable.Responsive.display.modal({
                header: function(row) {
                  const data = row.data();
                  return 'Details of ' + data['name'];
                }
              }),
              type: 'column',
              renderer: function(api, rowIdx, columns) {
                const data = columns
                  .map(function(col) {
                    return col.title !== '' ?
                      `<tr data-dt-row="${col.rowIndex}" data-dt-column="${col.columnIndex}">
                      <td>${col.title}:</td>
                      <td>${col.data}</td>
                    </tr>` :
                      '';
                  })
                  .join('');

                if (data) {
                  const div = document.createElement('div');
                  div.classList.add('table-responsive');
                  const table = document.createElement('table');
                  div.appendChild(table);
                  table.classList.add('table');
                  table.classList.add('datatables-basic');
                  const tbody = document.createElement('tbody');
                  tbody.innerHTML = data;
                  table.appendChild(tbody);
                  return div;
                }
                return false;
              }
            }
          },
          initComplete: function(settings, json) {
            $('.card-header').after('<hr class="my-0">');
          }
        });

        // File upload handling - variables already declared in global scope above

        // Profile image preview
        document.getElementById('profileImage')?.addEventListener('change', function(e) {
          const file = e.target.files[0];
          const preview = document.getElementById('profileImagePreview');
          if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
              preview.innerHTML = `<img src="${e.target.result}" class="img-thumbnail" style="max-width: 150px; max-height: 150px;" />`;
            };
            reader.readAsDataURL(file);
          } else {
            preview.innerHTML = '';
          }
        });

        // Document upload handling
        document.getElementById('documentFiles')?.addEventListener('change', function(e) {
          const files = Array.from(e.target.files);
          const documentType = document.getElementById('documentType').value;

          if (!documentType) {
            alert('Please select a document type first');
            e.target.value = '';
            return;
          }

          files.forEach(file => {
            if (file.size > 1024 * 1024) {
              alert(`File ${file.name} exceeds 1MB limit`);
              return;
            }

            const reader = new FileReader();
            reader.onload = function(e) {
              uploadedDocuments.push({
                file: file,
                type: documentType,
                preview: e.target.result,
                name: file.name
              });
              window.displayUploadedDocuments();
            };
            reader.readAsDataURL(file);
          });

          e.target.value = '';
        });

        window.displayUploadedDocuments = function() {
          const container = document.getElementById('uploadedDocuments');
          if (!container) return;
          if (uploadedDocuments.length === 0) {
            container.innerHTML = '';
            return;
          }

          let html = '<div class="list-group">';
          uploadedDocuments.forEach((doc, index) => {
            const isImage = doc.file ? doc.file.type.startsWith('image/') : (doc.file_type === 'image' || doc.preview);
            const previewUrl = doc.preview || (doc.existing ? `/storage/${doc.file_path}` : null);
            const fileUrl = doc.existing ? `/api/documents/${doc.id}` : '#';

            html += `
              <div class="list-group-item d-flex justify-content-between align-items-center">
                <a href="${fileUrl}" target="_blank" class="d-flex align-items-center text-decoration-none flex-grow-1" style="color: inherit;">
                  ${isImage && previewUrl ? `<img src="${previewUrl}" style="width: 40px; height: 40px; object-fit: cover; margin-right: 10px;" class="rounded" />` : '<i class="icon-base ri ri-file-pdf-line icon-20px me-2"></i>'}
                  <div>
                    <div class="fw-medium">${doc.name}</div>
                    <small class="text-muted">${doc.type.replace('_', ' ').replace(/\b\w/g, l => l.toUpperCase())}</small>
                  </div>
                </a>
                <button type="button" class="btn btn-sm btn-outline-danger ms-2" onclick="removeDocument(${index}, ${doc.existing ? doc.id : 'null'})">
                  <i class="icon-base ri ri-delete-bin-line"></i>
                </button>
              </div>
            `;
          });
          html += '</div>';
          container.innerHTML = html;
        };

        window.removeDocument = function(index, documentId) {
          if (documentId) {
            // Delete existing document from server
            if (confirm('Are you sure you want to delete this document?')) {
              fetch(`/api/documents/${documentId}`, {
                method: 'DELETE',
                headers: {
                  'Accept': 'application/json',
                  'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                credentials: 'include'
              }).then(() => {
                uploadedDocuments.splice(index, 1);
                window.displayUploadedDocuments();
              }).catch(error => {
                console.error('Error deleting document:', error);
                alert('Error deleting document');
              });
            }
          } else {
            uploadedDocuments.splice(index, 1);
            window.displayUploadedDocuments();
          }
        };

        fv.on('core.form.valid', function() {
          let userId = document.querySelector('#userId').value;
          let new_name = document.querySelector('.add-new-record .dt-name')?.value || '';
          let new_email = document.querySelector('.add-new-record .dt-email')?.value || '';
          let new_password = document.querySelector('.add-new-record .dt-password')?.value || '';
          let new_role = document.querySelector('.add-new-record .dt-role')?.value || '';
          let new_shop = document.querySelector('.add-new-record .dt-shop')?.value || '';
          let new_phone = document.querySelector('.add-new-record .dt-phone')?.value || '';
          let new_approved = document.querySelector('.add-new-record .dt-approved')?.checked || false;
          let new_locked = document.querySelector('.add-new-record .dt-locked')?.checked || false;

          // Validate required fields
          if (!new_name || !new_email || !new_role) {
            alert('Name, Email, and Role are required fields');
            return false;
          }

          const isEditing = userId && userId.trim() !== '';
          const url = isEditing ? `/api/users/${userId}` : '/api/users';
          // Use POST for FormData and add _method for PUT requests (Laravel method spoofing)
          const method = 'POST';

          // Use FormData for file uploads
          const formData = new FormData();
          if (isEditing) {
            formData.append('_method', 'PUT');
          }
          formData.append('name', new_name);
          formData.append('email', new_email);
          formData.append('role_id', new_role);
          if (new_shop) formData.append('shop_id', new_shop);
          if (new_phone) formData.append('phone', new_phone);
          formData.append('approved', new_approved ? '1' : '0');
          formData.append('locked', new_locked ? '1' : '0');

          // Only include password if provided (for edit) or required (for create)
          if (!isEditing || new_password) {
            formData.append('password', new_password);
          }

          // Add profile image if selected
          const profileImage = document.getElementById('profileImage').files[0];
          if (profileImage) {
            formData.append('profile_image', profileImage);
          }

          fetch(url, {
              method: method,
              headers: {
                'Accept': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
              },
              credentials: 'include',
              body: formData
            })
            .then(response => {
              if (!response.ok) {
                return response.json().then(err => {
                  const errorMsg = err.message || (err.errors ? JSON.stringify(err.errors) : 'Request failed');
                  throw new Error(errorMsg);
                });
              }
              return response.json();
            })
            .then(data => {
              if (data.success) {
                const savedUserId = data.data?.id || userId;

                // Upload documents if any
                if (uploadedDocuments.length > 0) {
                  const uploadPromises = uploadedDocuments.map(doc => {
                    const docFormData = new FormData();
                    docFormData.append('model_type', 'App\\Models\\User');
                    docFormData.append('model_id', savedUserId);
                    docFormData.append('document_type', doc.type);
                    docFormData.append('document_name', doc.name);
                    docFormData.append('file', doc.file);

                    return fetch('/api/documents', {
                      method: 'POST',
                      headers: {
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                      },
                      credentials: 'include',
                      body: docFormData
                    });
                  });

                  Promise.all(uploadPromises).then(() => {
                    if (offCanvasEl) {
                      offCanvasEl.hide();
                    }
                    formAddNewRecord.reset();
                    uploadedDocuments = [];
                    window.displayUploadedDocuments();
                    window.location.reload();
                  }).catch(error => {
                    console.error('Error uploading documents:', error);
                    alert('User saved but some documents failed to upload');
                    window.location.reload();
                  });
                } else {
                  if (offCanvasEl) {
                    offCanvasEl.hide();
                  }
                  formAddNewRecord.reset();
                  window.location.reload();
                }
              } else {
                alert(data.message || 'An error occurred');
              }
            })
            .catch(error => {
              console.error('Error:', error);
              const errorMessage = error.message || 'An error occurred while saving the user';
              alert(errorMessage);
            });
          return false;
        });

        document.addEventListener('click', function(e) {
          if (e.target.closest('.item-edit')) {
            e.preventDefault();
            const row = e.target.closest('tr');
            const userId = row.getAttribute('data-user-id');

            // Fetch user data from API
            fetch(`/api/users/${userId}`, {
                method: 'GET',
                headers: {
                  'Accept': 'application/json',
                  'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                credentials: 'include'
              })
              .then(response => response.json())
              .then(data => {
                if (data.success && data.user) {
                  const user = data.user;

                  // Fetch user documents
                  return fetch(`/api/users/${userId}?with=documents`, {
                    method: 'GET',
                    headers: {
                      'Accept': 'application/json',
                      'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    credentials: 'include'
                  }).then(res => res.json()).then(docData => {
                    if (docData.success && docData.user) {
                      user.documents = docData.user.documents || [];
                    }
                    return user;
                  }).catch(() => user);
                }
                return null;
              })
              .then(user => {
                if (user) {

                  document.getElementById('formTitle').textContent = 'Edit User';
                  document.getElementById('userId').value = user.id;
                  document.querySelector('.dt-name').value = user.name || '';
                  document.querySelector('.dt-email').value = user.email || '';
                  document.querySelector('.dt-password').value = '';
                  document.getElementById('passwordRequired').style.display = 'none';
                  document.getElementById('basicPassword').required = false;

                  const roleSelect = document.querySelector('.dt-role');
                  if (roleSelect && user.role_id) {
                    roleSelect.value = user.role_id;
                    $(roleSelect).trigger('change');
                  }

                  const shopSelect = document.querySelector('.dt-shop');
                  if (shopSelect && user.shop_id) {
                    shopSelect.value = user.shop_id;
                    $(shopSelect).trigger('change');
                  } else if (shopSelect) {
                    shopSelect.value = '';
                    $(shopSelect).trigger('change');
                  }

                  document.querySelector('.dt-phone').value = user.phone || '';
                  document.querySelector('.dt-approved').checked = user.approved || false;
                  document.querySelector('.dt-locked').checked = user.locked || false;

                  // Load profile image if exists
                  const profileImagePreview = document.getElementById('profileImagePreview');
                  if (user.profile_image) {
                    profileImagePreview.innerHTML = `<img src="/storage/${user.profile_image}" class="img-thumbnail" style="max-width: 150px; max-height: 150px;" />`;
                  } else {
                    profileImagePreview.innerHTML = '';
                  }

                  // Load existing documents
                  currentUserId = user.id;
                  uploadedDocuments = [];
                  if (user.documents && user.documents.length > 0) {
                    user.documents.forEach(doc => {
                      uploadedDocuments.push({
                        id: doc.id,
                        type: doc.document_type || 'other',
                        name: doc.document_name || 'Document',
                        preview: doc.file_type === 'image' ? `/storage/${doc.file_path}` : null,
                        file: null,
                        existing: true
                      });
                    });
                    window.displayUploadedDocuments();
                  }

                  offCanvasEl = new bootstrap.Offcanvas(document.querySelector('#add-new-record'));
                  offCanvasEl.show();
                } else {
                  alert('Error loading user data');
                }
              })
              .catch(error => {
                console.error('Error:', error);
                alert('Error loading user data');
              });
          }
        });

        // Delete record handler
        $(document).on('click', '.delete-record', function(e) {
          e.preventDefault();
          const row = $(this).closest('tr');
          const userId = row.attr('data-user-id');

          if (confirm('Are you sure you want to delete this user?')) {
            fetch(`/api/users/${userId}`, {
                method: 'DELETE',
                headers: {
                  'Content-Type': 'application/json',
                  'Accept': 'application/json',
                  'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                credentials: 'include'
              })
              .then(response => response.json())
              .then(data => {
                if (data.success) {
                  const modalEl = document.querySelector('.dtr-bs-modal');
                  if (modalEl && modalEl.classList.contains('show')) {
                    const modal = bootstrap.Modal.getInstance(modalEl);
                    modal?.hide();
                  }
                  window.location.reload();
                } else {
                  alert(data.message || 'An error occurred');
                }
              })
              .catch(error => {
                console.error('Error:', error);
                alert('An error occurred while deleting the user');
              });
          }
        });
      }

      setTimeout(() => {
        const elementsToModify = [{
            selector: '.dt-buttons .btn',
            classToRemove: 'btn-secondary'
          },
          {
            selector: '.dt-layout-table',
            classToRemove: 'row mt-2'
          },
          {
            selector: '.dt-layout-end',
            classToAdd: 'mt-0',
            classToRemove: 'ms-auto'
          },
          {
            selector: '.dt-layout-end .dt-search',
            classToAdd: 'mt-md-5 mt-0',
            classToRemove: 'ms-auto'
          },
          {
            selector: '.dt-layout-full',
            classToRemove: 'col-md col-12',
            classToAdd: 'table-responsive'
          }
        ];

        elementsToModify.forEach(({
          selector,
          classToRemove,
          classToAdd
        }) => {
          document.querySelectorAll(selector).forEach(element => {
            if (classToRemove) {
              classToRemove.split(' ').forEach(className => element.classList.remove(className));
            }
            if (classToAdd) {
              classToAdd.split(' ').forEach(className => element.classList.add(className));
            }
          });
        });
      }, 100);

      $('#basicRole, #basicShop').select2({
        placeholder: 'Select...',
        allowClear: true,
        dropdownParent: $('.offcanvas')
      });

    });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/niranjan/mydevelopments/chalana-tool-station/resources/views/module/user/index.blade.php ENDPATH**/ ?>