<?php

use App\Http\Controllers\Api\ShopController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');


Route::get('/hello', function () {
  return response()->json(['message' => 'Hello']);
});

Route::post('/login', [AuthController::class, 'login']);

// Protected routes
Route::middleware('auth:sanctum')->group(function () {
  Route::get('/me', [AuthController::class, 'me']);
  Route::post('/logout', [AuthController::class, 'logout']);
});

Route::middleware('auth:sanctum')->apiResource('shops', ShopController::class);
Route::middleware('auth:sanctum')->apiResource('users', \App\Http\Controllers\Api\UserController::class);
// Add POST route for user updates with FormData (method spoofing support)
Route::middleware('auth:sanctum')->post('users/{user}', [\App\Http\Controllers\Api\UserController::class, 'update'])->where('user', '[0-9]+');
Route::middleware('auth:sanctum')->apiResource('categories', \App\Http\Controllers\Api\CategoryController::class);
Route::middleware('auth:sanctum')->apiResource('equipments', \App\Http\Controllers\Api\EquipmentController::class);
Route::middleware('auth:sanctum')->apiResource('stocks', \App\Http\Controllers\Api\StockController::class);
Route::middleware('auth:sanctum')->apiResource('customers', \App\Http\Controllers\Api\CustomerController::class);
// Add POST route for customer updates with FormData (method spoofing support)
Route::middleware('auth:sanctum')->post('customers/{customer}', [\App\Http\Controllers\Api\CustomerController::class, 'update'])->where('customer', '[0-9]+');
Route::middleware('auth:sanctum')->apiResource('rentals', \App\Http\Controllers\Api\RentalController::class);
Route::middleware('auth:sanctum')->group(function () {
    Route::get('rentals/{rental}/items', [\App\Http\Controllers\Api\RentalItemController::class, 'index']);
    Route::post('rentals/{rental}/items', [\App\Http\Controllers\Api\RentalItemController::class, 'store']);
    Route::put('rentals/{rental}/items/{rentalItem}', [\App\Http\Controllers\Api\RentalItemController::class, 'update']);
    Route::delete('rentals/{rental}/items/{rentalItem}', [\App\Http\Controllers\Api\RentalItemController::class, 'destroy']);

    // Rental Agreements
    Route::get('agreements/{agreement}', [\App\Http\Controllers\Api\RentalAgreementController::class, 'show']);
    Route::post('agreements/{agreement}/mark-signed', [\App\Http\Controllers\Api\RentalAgreementController::class, 'markSigned']);
    Route::post('agreements/{agreement}/mark-handed-over', [\App\Http\Controllers\Api\RentalAgreementController::class, 'markEquipmentHandedOver']);

    // Invoices
    Route::apiResource('invoices', \App\Http\Controllers\Api\InvoiceController::class);
    Route::get('invoices/{invoice}/pdf', [\App\Http\Controllers\Api\InvoiceController::class, 'generatePdf']);

    // Payments
    Route::apiResource('payments', \App\Http\Controllers\Api\PaymentController::class)->only(['index', 'store']);

    // Documents
    Route::post('documents', [\App\Http\Controllers\Api\DocumentController::class, 'store']);
    Route::get('documents/{document}', [\App\Http\Controllers\Api\DocumentController::class, 'show']);
    Route::delete('documents/{document}', [\App\Http\Controllers\Api\DocumentController::class, 'destroy']);
});
