@extends('layouts/layoutMaster')

@section('title', 'Stocks - Equipment Renting System')

<!-- Vendor Styles -->
@section('vendor-style')
  @vite(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss', 'resources/assets/vendor/libs/select2/select2.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
  @vite(['resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js', 'resources/assets/vendor/libs/select2/select2.js'])
@endsection

@section('page-style')
  <style>
    .select2-container {
      z-index: 9999 !important;
    }
    .select2-dropdown {
      z-index: 9999 !important;
    }
  </style>
@endsection

@section('content')
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <!-- DataTable with Buttons -->
  <div class="card">
    <div class="card-datatable text-nowrap">
      <table class="datatables-basic table table-bordered table-responsive">
        <thead>
        <tr>
          <th></th>
          <th></th>
          <th>ID</th>
          <th>Shop</th>
          <th>Equipment</th>
          <th>Quantity</th>
          <th>Reserved</th>
          <th>Available</th>
          <th>Min Threshold</th>
          <th class="d-flex align-items-center">Action</th>
        </tr>
        </thead>
        <tbody>
        @foreach ($stocks as $stock)
          <tr data-stock-id="{{ $stock->id }}">
            <td></td>
            <td><input type="checkbox" class="dt-checkboxes form-check-input"></td>
            <td>{{ $loop->iteration + ($stocks->currentPage() - 1) * $stocks->perPage() }}</td>
            <td>{{ $stock->shop->name }}</td>
            <td>{{ $stock->equipment->name }}</td>
            <td>{{ $stock->quantity }}</td>
            <td>{{ $stock->reserved }}</td>
            <td>
              <span class="badge {{ ($stock->quantity - $stock->reserved) > 0 ? 'bg-label-success' : 'bg-label-danger' }}">
                {{ $stock->quantity - $stock->reserved }}
              </span>
            </td>
            <td>{{ $stock->minimum_threshold ?? 'N/A' }}</td>
            <td>
              <div class="d-inline-block">
                <a href="javascript:;" class="btn btn-sm btn-text-secondary rounded-pill btn-icon dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                  <i class="icon-base ri ri-more-2-line icon-20px"></i>
                </a>
                <ul class="dropdown-menu dropdown-menu-end m-0">
                  <li><a href="javascript:;" class="dropdown-item item-details">Details</a></li>
                  <div class="dropdown-divider"></div>
                  <li><a href="javascript:;" class="dropdown-item text-danger delete-record" data-id="{{ $stock->id }}">Delete</a></li>
                </ul>
              </div>
              <a href="javascript:;" class="btn btn-sm btn-text-secondary rounded-pill btn-icon item-edit">
                <i class="icon-base ri ri-edit-box-line icon-20px"></i>
              </a>
            </td>
          </tr>
        @endforeach
        </tbody>
      </table>
    </div>
  </div>

  <!-- Modal to add/edit stock record -->
  <div class="offcanvas offcanvas-end" id="add-new-record">
    <div class="offcanvas-header border-bottom">
      <h5 class="offcanvas-title" id="formTitle">New Stock</h5>
      <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body flex-grow-1">
      <form method="POST" class="add-new-record pt-0 row g-3" id="stockForm">
        @csrf
        <input type="hidden" name="_method" id="methodField" value="POST">
        <input type="hidden" id="stockId" name="stockId" />

        <div class="col-sm-12 form-control-validation">
          <div class="input-group input-group-merge">
            <span id="basicShop2" class="input-group-text">
              <i class="icon-base ri ri-store-2-line icon-18px"></i>
            </span>
            <div class="form-floating form-floating-outline">
              <select id="basicShop" name="basicShop" class="select2 form-select shop dt-shop" placeholder="Shop" aria-label="Shop" aria-describedby="basicShop2" data-allow-clear="true">
                <option value=""></option>
                @foreach($shops as $shop)
                  <option value="{{ $shop->id }}">{{ $shop->name }}</option>
                @endforeach
              </select>
              <label for="basicShop" class="form-label">Shop</label>
            </div>
          </div>
        </div>

        <div class="col-sm-12 form-control-validation">
          <div class="input-group input-group-merge">
            <span id="basicEquipment2" class="input-group-text">
              <i class="icon-base ri ri-tools-line icon-18px"></i>
            </span>
            <div class="form-floating form-floating-outline">
              <select id="basicEquipment" name="basicEquipment" class="select2 form-select equipment dt-equipment" placeholder="Equipment" aria-label="Equipment" aria-describedby="basicEquipment2" data-allow-clear="true">
                <option value=""></option>
                @foreach($equipments as $equipment)
                  <option value="{{ $equipment->id }}">{{ $equipment->name }}</option>
                @endforeach
              </select>
              <label for="basicEquipment" class="form-label">Equipment</label>
            </div>
          </div>
        </div>

        <div class="col-sm-12 form-control-validation">
          <div class="input-group input-group-merge">
            <span id="basicQuantity2" class="input-group-text">
              <i class="icon-base ri ri-stack-line icon-18px"></i>
            </span>
            <div class="form-floating form-floating-outline">
              <input type="number" id="basicQuantity" name="basicQuantity" class="form-control dt-quantity"
                     placeholder="0" aria-label="Quantity" aria-describedby="basicQuantity2" min="0" />
              <label for="basicQuantity">Quantity</label>
            </div>
          </div>
        </div>

        <div class="col-sm-12 form-control-validation">
          <div class="input-group input-group-merge">
            <span id="basicReserved2" class="input-group-text">
              <i class="icon-base ri ri-lock-line icon-18px"></i>
            </span>
            <div class="form-floating form-floating-outline">
              <input type="number" id="basicReserved" name="basicReserved" class="form-control dt-reserved"
                     placeholder="0" aria-label="Reserved" aria-describedby="basicReserved2" min="0" />
              <label for="basicReserved">Reserved</label>
            </div>
          </div>
        </div>

        <div class="col-sm-12 form-control-validation">
          <div class="input-group input-group-merge">
            <span id="basicThreshold2" class="input-group-text">
              <i class="icon-base ri ri-alert-line icon-18px"></i>
            </span>
            <div class="form-floating form-floating-outline">
              <input type="number" id="basicThreshold" name="basicThreshold" class="form-control dt-threshold"
                     placeholder="0" aria-label="Minimum Threshold" aria-describedby="basicThreshold2" min="0" />
              <label for="basicThreshold">Minimum Threshold (Optional)</label>
            </div>
          </div>
        </div>

        <div class="col-sm-12">
          <button type="submit" id="submitBtn" class="btn btn-primary data-submit me-sm-4 me-1">Submit</button>
          <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="offcanvas">Cancel</button>
        </div>
      </form>
    </div>
  </div>

@endsection

@section('page-script')
  <script>
    'use strict';

    let fv, offCanvasEl;
    document.addEventListener('DOMContentLoaded', function (e) {
      (function () {
        const formAddNewRecord = document.getElementById('stockForm');
        var form = document.getElementById('stockForm');

        form.addEventListener('submit', function(e) {
          e.preventDefault();
        });

        setTimeout(() => {
          const newRecord = document.querySelector('.create-new-form-btn'),
            offCanvasElement = document.querySelector('#add-new-record');

          if (newRecord) {
            newRecord.addEventListener('click', function () {
              offCanvasEl = new bootstrap.Offcanvas(offCanvasElement);
              document.getElementById('formTitle').textContent = 'New Stock';
              document.getElementById('stockId').value = '';
              formAddNewRecord.reset();
              offCanvasEl.show();
            });
          }
        }, 200);

        fv = FormValidation.formValidation(formAddNewRecord, {
          fields: {
            basicShop: {
              validators: {
                notEmpty: {
                  message: 'Shop is required'
                }
              }
            },
            basicEquipment: {
              validators: {
                notEmpty: {
                  message: 'Equipment is required'
                }
              }
            },
            basicQuantity: {
              validators: {
                notEmpty: {
                  message: 'Quantity is required'
                },
                integer: {
                  message: 'Quantity must be a number'
                }
              }
            }
          },
          plugins: {
            trigger: new FormValidation.plugins.Trigger(),
            bootstrap5: new FormValidation.plugins.Bootstrap5({
              eleValidClass: '',
              rowSelector: '.form-control-validation'
            }),
            submitButton: new FormValidation.plugins.SubmitButton(),
            autoFocus: new FormValidation.plugins.AutoFocus()
          },
          init: instance => {
            instance.on('plugins.message.placed', function (e) {
              if (e.element.parentElement.classList.contains('input-group')) {
                e.element.parentElement.insertAdjacentElement('afterend', e.messageElement);
              }
            });
          }
        });
      })();

      const dt_basic_table = document.querySelector('.datatables-basic');
      let dt_basic;

      if (dt_basic_table) {
        let tableTitle = document.createElement('h5');
        tableTitle.classList.add('card-title', 'mb-0', 'text-md-start', 'text-center');
        tableTitle.innerHTML = 'Stocks';

        dt_basic = new DataTable(dt_basic_table, {
          columns: [
            { data: 'id' },
            { data: 'id', orderable: false, render: DataTable.render.select() },
            { data: 'id' },
            { data: 'shop' },
            { data: 'equipment' },
            { data: 'quantity' },
            { data: 'reserved' },
            { data: 'available' },
            { data: 'threshold' },
            { data: 'id' }
          ],
          columnDefs: [
            {
              className: 'control',
              orderable: false,
              searchable: false,
              responsivePriority: 2,
              targets: 0,
              render: function (data, type, full, meta) {
                return '';
              }
            },
            {
              targets: 1,
              orderable: false,
              searchable: false,
              responsivePriority: 3,
              checkboxes: true,
              render: function () {
                return '<input type="checkbox" class="dt-checkboxes form-check-input">';
              }
            },
            {
              targets: 2,
              searchable: false,
              visible: false
            },
            {
              responsivePriority: 1,
              targets: 3
            },
            {
              targets: -1,
              title: 'Actions',
              orderable: false,
              searchable: false,
              className: 'd-flex align-items-center',
              render: function (data, type, full, meta) {
                return data;
              }
            }
          ],
          select: {
            style: 'multi',
            selector: 'td:nth-child(2)'
          },
          order: [[2, 'desc']],
          layout: {
            top2Start: {
              rowClass: 'row card-header mx-0 px-2',
              features: [tableTitle]
            },
            top2End: {
              features: [
                {
                  buttons: [
                    {
                      extend: 'collection',
                      className: 'btn btn-label-primary dropdown-toggle me-4 waves-effect border-none',
                      text: '<span class="d-flex align-items-center gap-2"><i class="icon-base ri ri-external-link-line icon-18px"></i> <span class="d-none d-sm-inline-block">Export</span></span>',
                      buttons: [
                        {
                          extend: 'print',
                          text: `<span class="d-flex align-items-center"><i class="icon-base ri ri-printer-line me-1"></i>Print</span>`,
                          className: 'dropdown-item',
                          exportOptions: {
                            columns: [3, 4, 5, 6, 7, 8]
                          }
                        },
                        {
                          extend: 'csv',
                          text: `<span class="d-flex align-items-center"><i class="icon-base ri ri-file-text-line me-1"></i>Csv</span>`,
                          className: 'dropdown-item',
                          exportOptions: {
                            columns: [3, 4, 5, 6, 7, 8]
                          }
                        },
                        {
                          extend: 'excel',
                          text: `<span class="d-flex align-items-center"><i class="icon-base ri ri-file-excel-line me-1"></i>Excel</span>`,
                          className: 'dropdown-item',
                          exportOptions: {
                            columns: [3, 4, 5, 6, 7, 8]
                          }
                        },
                        {
                          extend: 'pdf',
                          text: `<span class="d-flex align-items-center"><i class="icon-base ri ri-file-pdf-line me-1"></i>Pdf</span>`,
                          className: 'dropdown-item',
                          exportOptions: {
                            columns: [3, 4, 5, 6, 7, 8]
                          }
                        },
                        {
                          extend: 'copy',
                          text: `<i class="icon-base ri ri-file-copy-line me-1"></i>Copy`,
                          className: 'dropdown-item',
                          exportOptions: {
                            columns: [3, 4, 5, 6, 7, 8]
                          }
                        }
                      ]
                    },
                    {
                      text: '<span class="d-flex align-items-center"><i class="icon-base ri ri-add-line icon-18px me-sm-1"></i><span class="d-none d-sm-inline-block">Add New Record</span></span>',
                      className: 'create-new-form-btn btn btn-primary'
                    }
                  ]
                }
              ]
            },
            topStart: {
              rowClass: 'row m-3 mx-2 my-0 justify-content-between',
              features: [
                {
                  pageLength: {
                    menu: [7, 10, 25, 50, 100],
                    text: 'Show_MENU_entries'
                  }
                }
              ]
            },
            topEnd: {
              search: {
                placeholder: 'Type search here'
              }
            },
            bottomStart: {
              rowClass: 'row mx-3 justify-content-between',
              features: ['info']
            },
            bottomEnd: 'paging'
          },
          displayLength: 7,
          language: {
            paginate: {
              next: '<i class="icon-base ri ri-arrow-right-s-line scaleX-n1-rtl icon-22px"></i>',
              previous: '<i class="icon-base ri ri-arrow-left-s-line scaleX-n1-rtl icon-22px"></i>',
              first: '<i class="icon-base ri ri-skip-back-mini-line scaleX-n1-rtl icon-22px"></i>',
              last: '<i class="icon-base ri ri-skip-forward-mini-line scaleX-n1-rtl icon-22px"></i>'
            }
          },
          responsive: {
            details: {
              display: DataTable.Responsive.display.modal({
                header: function (row) {
                  const data = row.data();
                  return 'Details of Stock';
                }
              }),
              type: 'column',
              renderer: function (api, rowIdx, columns) {
                const data = columns
                  .map(function (col) {
                    return col.title !== ''
                      ? `<tr data-dt-row="${col.rowIndex}" data-dt-column="${col.columnIndex}">
                      <td>${col.title}:</td>
                      <td>${col.data}</td>
                    </tr>`
                      : '';
                  })
                  .join('');

                if (data) {
                  const div = document.createElement('div');
                  div.classList.add('table-responsive');
                  const table = document.createElement('table');
                  div.appendChild(table);
                  table.classList.add('table');
                  table.classList.add('datatables-basic');
                  const tbody = document.createElement('tbody');
                  tbody.innerHTML = data;
                  table.appendChild(tbody);
                  return div;
                }
                return false;
              }
            }
          },
          initComplete: function (settings, json) {
            $('.card-header').after('<hr class="my-0">');
          }
        });

        fv.on('core.form.valid', function () {
          let stockId = document.querySelector('#stockId').value;
          let new_shop = document.querySelector('.add-new-record .dt-shop').value;
          let new_equipment = document.querySelector('.add-new-record .dt-equipment').value;
          let new_quantity = document.querySelector('.add-new-record .dt-quantity').value;
          let new_reserved = document.querySelector('.add-new-record .dt-reserved').value || 0;
          let new_threshold = document.querySelector('.add-new-record .dt-threshold').value || null;

          const isEditing = stockId && stockId.trim() !== '';
          const url = isEditing ? `/api/stocks/${stockId}` : '/api/stocks';
          const method = isEditing ? 'PUT' : 'POST';

          fetch(url, {
            method: method,
            headers: {
              'Content-Type': 'application/json',
              'Accept': 'application/json',
              'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            credentials: 'include',
            body: JSON.stringify({
              shop_id: parseInt(new_shop),
              equipment_id: parseInt(new_equipment),
              quantity: parseInt(new_quantity),
              reserved: parseInt(new_reserved),
              minimum_threshold: new_threshold ? parseInt(new_threshold) : null
            })
          })
            .then(response => response.json())
            .then(data => {
              if (data.success) {
                location.reload();
              }
            })
            .catch(error => console.error('Error:', error));
          return false;
        });

        document.addEventListener('click', function (e) {
          if (e.target.closest('.item-edit')) {
            e.preventDefault();

            const row = e.target.closest('tr');
            const stockId = row.getAttribute('data-stock-id');

            // Fetch stock data from API
            fetch(`/api/stocks/${stockId}`, {
              method: 'GET',
              headers: {
                'Accept': 'application/json',
                'X-CSRF-TOKEN': document
                  .querySelector('meta[name="csrf-token"]')
                  .getAttribute('content')
              },
              credentials: 'include'
            })
              .then(response => response.json())
              .then(res => {
                if (!res.success || !res.data) {
                  throw new Error('Invalid stock data');
                }

                const stock = res.data;

                // ===== Populate Form =====
                document.getElementById('formTitle').textContent = 'Edit Stock';
                document.getElementById('stockId').value = stock.id;

                document.querySelector('.dt-shop').value = stock.shop_id || '';
                document.querySelector('.dt-equipment').value = stock.equipment_id || '';
                document.querySelector('.dt-quantity').value = stock.quantity ?? '';
                document.querySelector('.dt-reserved').value = stock.reserved ?? '';
                document.querySelector('.dt-threshold').value =
                  stock.minimum_threshold ?? '';

                // Trigger Select2 / dropdown updates
                const shopSelect = document.querySelector('.dt-shop');
                const equipmentSelect = document.querySelector('.dt-equipment');

                if (shopSelect) {
                  shopSelect.value = stock.shop_id;
                  $(shopSelect).trigger('change');
                }

                if (equipmentSelect) {
                  equipmentSelect.value = stock.equipment_id;
                  $(equipmentSelect).trigger('change');
                }

                // Show Offcanvas
                offCanvasEl = new bootstrap.Offcanvas(
                  document.querySelector('#add-new-record')
                );
                offCanvasEl.show();
              })
              .catch(error => {
                console.error('Error loading stock data:', error);
                alert('Error loading stock data');
              });
          }
        });


        document.addEventListener('click', function (e) {
          if (e.target.classList.contains('delete-record')) {
            e.preventDefault();
            const row = e.target.closest('tr');
            const stockId = row.getAttribute('data-stock-id');

            if (confirm('Are you sure you want to delete this stock?')) {
              fetch(`/api/stocks/${stockId}`, {
                method: 'DELETE',
                headers: {
                  'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
              })
                .then(response => response.json())
                .then(data => {
                  if (data.success) {
                    row.remove();
                  }
                })
                .catch(error => console.error('Error:', error));
            }
          }
        });
      }

      setTimeout(() => {
        const elementsToModify = [
          { selector: '.dt-buttons .btn', classToRemove: 'btn-secondary' },
          { selector: '.dt-layout-table', classToRemove: 'row mt-2' },
          { selector: '.dt-layout-end', classToAdd: 'mt-0', classToRemove: 'ms-auto' },
          { selector: '.dt-layout-end .dt-search', classToAdd: 'mt-md-5 mt-0', classToRemove: 'ms-auto' },
          { selector: '.dt-layout-full', classToRemove: 'col-md col-12', classToAdd: 'table-responsive' }
        ];

        elementsToModify.forEach(({ selector, classToRemove, classToAdd }) => {
          document.querySelectorAll(selector).forEach(element => {
            if (classToRemove) {
              classToRemove.split(' ').forEach(className => element.classList.remove(className));
            }
            if (classToAdd) {
              classToAdd.split(' ').forEach(className => element.classList.add(className));
            }
          });
        });
      }, 100);

      $('#basicShop, #basicEquipment').select2({
        placeholder: 'Select...',
        allowClear: true,
        dropdownParent: $('#add-new-record')
      });
    });
  </script>
@endsection
