@extends('layouts/layoutMaster')

@section('title', 'DataTables - Tables')

<!-- Vendor Styles -->
@section('vendor-style')
  @vite(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/datatables-rowgroup-bs5/rowgroup.bootstrap5.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss', 'resources/assets/vendor/libs/select2/select2.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
  @vite(['resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js', 'resources/assets/vendor/libs/select2/select2.js'])
@endsection

@section('page-style')
  <style>
    .select2-container {
      z-index: 9999 !important;
    }

    .select2-dropdown {
      z-index: 9999 !important;
    }
  </style>
@endsection


@section('content')
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <!-- DataTable with Buttons -->
  <div class="card">
    <div class="card-datatable text-nowrap">
      <table class="datatables-basic table table-bordered table-responsive">
        <thead>
          <tr>
            <th></th>
            <th></th>
            <th>ID</th>
            <th>Shop Name</th>
            <th>Code</th>
            <th>Address</th>
            <th>Phone</th>
            <th>Manager</th>
            <th class="d-flex align-items-center">Action</th>
          </tr>
        </thead>
        <!-- Hardcoded shop data instead of employee data -->
        <tbody>
          @foreach ($shops as $shop)
            <tr data-shop-id="{{ $shop->id }}">
              <td></td>
              <td><input type="checkbox" class="dt-checkboxes form-check-input"></td>
              <td>{{ $loop->iteration + ($shops->currentPage() - 1) * $shops->perPage() }}</td>
              <td>
                <div class="d-flex justify-content-start align-items-center user-name">
                  <div class="avatar-wrapper">
                    <div class="avatar me-2">
                      <span class="avatar-initial rounded-circle bg-label-primary">
                        {{ strtoupper(substr($shop->name, 0, 2)) }}
                      </span>
                    </div>
                  </div>
                  <div class="d-flex flex-column">
                    <span class="shop_name text-truncate h6 mb-0">{{ $shop->name }}</span>
                    <small class="shop_code text-truncate">{{ $shop->code }}</small>
                  </div>
                </div>
              </td>
              <td>{{ $shop->code }}</td>
              <td>{{ $shop->address }}</td>
              <td>{{ $shop->phone }}</td>
              <td data-id="{{ $shop->manager?->id ?? '' }}">
                {{ $shop->manager?->name ?? 'N/A' }}
              </td>
              <td>
                <div class="d-inline-block">
                  <a href="javascript:;"
                    class="btn btn-sm btn-text-secondary rounded-pill btn-icon dropdown-toggle hide-arrow"
                    data-bs-toggle="dropdown">
                    <i class="icon-base ri ri-more-2-line icon-20px"></i>
                  </a>
                  <ul class="dropdown-menu dropdown-menu-end m-0">
                    <li><a href="javascript:;" class="dropdown-item item-details">Details</a></li>
                    <li><a href="javascript:;" class="dropdown-item item-archive">Archive</a></li>
                    <div class="dropdown-divider"></div>
                    <li><a href="javascript:;" class="dropdown-item text-danger delete-record"
                        data-id="{{ $shop->id }}">Delete</a></li>
                  </ul>
                </div>
                <a href="javascript:;" class="btn btn-sm btn-text-secondary rounded-pill btn-icon item-edit">
                  <i class="icon-base ri ri-edit-box-line icon-20px"></i>
                </a>
              </td>
            </tr>
          @endforeach
        </tbody>


      </table>
    </div>
  </div>
  <!-- Modal to add/edit shop record -->
  <div class="offcanvas offcanvas-end" id="add-new-record">
    <div class="offcanvas-header border-bottom">
      <h5 class="offcanvas-title" id="formTitle">New Shop</h5>
      <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body flex-grow-1">
      <form method="POST" class="add-new-record pt-0 row g-3" id="shopForm">
        @csrf
        <input type="hidden" name="_method" id="methodField" value="POST">
        <input type="hidden" id="shopId" name="shopId" />

        <div class="col-sm-12 form-control-validation">
          <div class="input-group input-group-merge">
            <span id="basicShopName2" class="input-group-text">
              <i class="icon-base ri ri-store-2-line icon-18px"></i>
            </span>
            <div class="form-floating form-floating-outline">
              <input type="text" id="basicShopName" class="form-control dt-shop-name" name="basicShopName"
                placeholder="Shop Name" aria-label="Shop Name" aria-describedby="basicShopName2" />
              <label for="basicShopName">Shop Name</label>
            </div>
          </div>
        </div>

        <div class="col-sm-12 form-control-validation">
          <div class="input-group input-group-merge">
            <span id="basicCode2" class="input-group-text">
              <i class="icon-base ri ri-barcode-line icon-18px"></i>
            </span>
            <div class="form-floating form-floating-outline">
              <input type="text" id="basicCode" name="basicCode" class="form-control dt-code" placeholder="Shop Code"
                aria-label="Shop Code" aria-describedby="basicCode2" />
              <label for="basicCode">Shop Code (Unique)</label>
            </div>
          </div>
        </div>

        <div class="col-sm-12 form-control-validation">
          <div class="input-group input-group-merge">
            <span id="basicAddress2" class="input-group-text">
              <i class="icon-base ri ri-map-pin-line icon-18px"></i>
            </span>
            <div class="form-floating form-floating-outline">
              <textarea class="form-control dt-address" id="basicAddress" name="basicAddress" placeholder="Shop Address"
                aria-label="Shop Address" aria-describedby="basicAddress2" rows="3"></textarea>
              <label for="basicAddress">Address</label>
            </div>
          </div>
        </div>

        <div class="col-sm-12 form-control-validation">
          <div class="input-group input-group-merge">
            <span id="basicPhone2" class="input-group-text">
              <i class="icon-base ri ri-phone-line icon-18px"></i>
            </span>
            <div class="form-floating form-floating-outline">
              <input type="tel" id="basicPhone" name="basicPhone" class="form-control dt-phone"
                placeholder="+1-234-567-8901" aria-label="+1-234-567-8901" aria-describedby="basicPhone2" />
              <label for="basicPhone">Phone</label>
            </div>
          </div>
        </div>

        <div class="col-sm-12 form-control-validation">
          <div class="input-group input-group-merge">
            <span id="basicManager2" class="input-group-text">
              <i class="icon-base ri ri-user-line icon-18px"></i>
            </span>
            <div class="form-floating form-floating-outline">
              <select id="basicManager" name="basicManager" class="select2 form-select manager dt-manager"
                placeholder="Manager Name" aria-label="Manager Name" aria-describedby="basicManager2"
                data-allow-clear="true">
                <option value=""></option>
                @foreach ($managers as $manager)
                  <option value="{{ $manager->id }}">{{ $manager->name }}</option>
                @endforeach
              </select>
              <label for="basicManager" class="form-label">Manager</label>
            </div>
          </div>
        </div>

        <div class="col-sm-12">
          <button type="submit" id="submitBtn" class="btn btn-primary data-submit me-sm-4 me-1">Submit</button>
          <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="offcanvas">Cancel</button>
        </div>
      </form>
    </div>
  </div>

@endsection

@section('page-script')
  <script>
    'use strict';



    let fv, offCanvasEl, formAddNewRecord;
    document.addEventListener('DOMContentLoaded', function(e) {
      (function() {
        formAddNewRecord = document.getElementById('shopForm');

        var form = document.getElementById('shopForm');

        // <CHANGE> Add submit event listener to prevent default form submission
        form.addEventListener('submit', function(e) {
          e.preventDefault();
          console.log('[v0] Form submit prevented');
        });

        setTimeout(() => {
          const newRecord = document.querySelector('.create-new-form-btn'),
            offCanvasElement = document.querySelector('#add-new-record');

          // To open offCanvas, to add new record
          if (newRecord) {
            newRecord.addEventListener('click', function() {
              offCanvasEl = new bootstrap.Offcanvas(offCanvasElement);
              document.getElementById('formTitle').textContent = 'New Shop';
              document.getElementById('shopId').value = '';
              formAddNewRecord.reset();
              offCanvasEl.show();
            });
          }
        }, 200);

        fv = FormValidation.formValidation(formAddNewRecord, {
          fields: {
            basicShopName: {
              validators: {
                notEmpty: {
                  message: 'Shop name is required'
                }
              }
            },
            basicCode: {
              validators: {
                notEmpty: {
                  message: 'Shop code is required'
                }
              }
            },
            basicAddress: {
              validators: {
                notEmpty: {
                  message: 'Address is required'
                }
              }
            },
            basicPhone: {
              validators: {
                notEmpty: {
                  message: 'Phone number is required'
                }
              }
            },
            basicManager: {
              validators: {
                notEmpty: {
                  message: 'Manager name is required'
                }
              }
            }
          },
          plugins: {
            trigger: new FormValidation.plugins.Trigger(),
            bootstrap5: new FormValidation.plugins.Bootstrap5({
              eleValidClass: '',
              rowSelector: '.form-control-validation'
            }),
            submitButton: new FormValidation.plugins.SubmitButton(),
            autoFocus: new FormValidation.plugins.AutoFocus()
          },
          init: instance => {
            instance.on('plugins.message.placed', function(e) {
              if (e.element.parentElement.classList.contains('input-group')) {
                e.element.parentElement.insertAdjacentElement('afterend', e.messageElement);
              }
            });
          }
        });
      })();

      const dt_basic_table = document.querySelector('.datatables-basic');
      let dt_basic;

      if (dt_basic_table) {
        let tableTitle = document.createElement('h5');
        tableTitle.classList.add('card-title', 'mb-0', 'text-md-start', 'text-center');
        tableTitle.innerHTML = 'Shops';

        dt_basic = new DataTable(dt_basic_table, {
          columns: [{
              data: 'id'
            },
            {
              data: 'id',
              orderable: false,
              render: DataTable.render.select()
            },
            {
              data: 'id'
            },
            {
              data: 'name'
            },
            {
              data: 'code'
            },
            {
              data: 'address'
            },
            {
              data: 'phone'
            },
            {
              data: 'manager'
            },
            {
              data: 'id'
            }
          ],
          columnDefs: [{
              className: 'control',
              orderable: false,
              searchable: false,
              responsivePriority: 2,
              targets: 0,
              render: function(data, type, full, meta) {
                return '';
              }
            },
            {
              targets: 1,
              orderable: false,
              searchable: false,
              responsivePriority: 3,
              checkboxes: true,
              render: function() {
                return '<input type="checkbox" class="dt-checkboxes form-check-input">';
              },
              checkboxes: {
                selectAllRender: '<input type="checkbox" class="form-check-input">'
              }
            },
            {
              targets: 2,
              searchable: false,
              visible: false
            },
            {
              responsivePriority: 1,
              targets: 4
            },
            {
              targets: -1,
              title: 'Actions',
              orderable: false,
              searchable: false,
              className: 'd-flex align-items-center',
              render: function(data, type, full, meta) {
                return data;
              }
            }
          ],
          select: {
            style: 'multi',
            selector: 'td:nth-child(2)'
          },
          order: [
            [2, 'desc']
          ],
          layout: {
            top2Start: {
              rowClass: 'row card-header mx-0 px-2',
              features: [tableTitle]
            },
            top2End: {
              features: [{
                buttons: [{
                    extend: 'collection',
                    className: 'btn btn-label-primary dropdown-toggle me-4 waves-effect border-none',
                    text: '<span class="d-flex align-items-center gap-2"><i class="icon-base ri ri-external-link-line icon-18px"></i> <span class="d-none d-sm-inline-block">Export</span></span>',
                    buttons: [{
                        extend: 'print',
                        text: `<span class="d-flex align-items-center"><i class="icon-base ri ri-printer-line me-1"></i>Print</span>`,
                        className: 'dropdown-item',
                        exportOptions: {
                          columns: [3, 4, 5, 6, 7],
                          format: {
                            body: function(inner, coldex, rowdex) {
                              if (inner.length <= 0) return inner;
                              const parser = new DOMParser();
                              const doc = parser.parseFromString(inner, 'text/html');
                              let text = '';
                              const userNameElements = doc.querySelectorAll('.user-name');
                              if (userNameElements.length > 0) {
                                userNameElements.forEach(el => {
                                  const nameText = el.querySelector('.fw-medium')?.textContent || el
                                    .querySelector('.d-block')?.textContent || el.textContent;
                                  text += nameText.trim() + ' ';
                                });
                              } else {
                                text = doc.body.textContent || doc.body.innerText;
                              }
                              return text.trim();
                            }
                          }
                        },
                        customize: function(win) {
                          win.document.body.style.color = config.colors.headingColor;
                          win.document.body.style.borderColor = config.colors.borderColor;
                          win.document.body.style.backgroundColor = config.colors.bodyBg;
                          const table = win.document.body.querySelector('table');
                          table.classList.add('compact');
                          table.style.color = 'inherit';
                          table.style.borderColor = 'inherit';
                          table.style.backgroundColor = 'inherit';
                        }
                      },
                      {
                        extend: 'csv',
                        text: `<span class="d-flex align-items-center"><i class="icon-base ri ri-file-text-line me-1"></i>Csv</span>`,
                        className: 'dropdown-item',
                        exportOptions: {
                          columns: [3, 4, 5, 6, 7],
                          format: {
                            body: function(inner, coldex, rowdex) {
                              if (inner.length <= 0) return inner;
                              const parser = new DOMParser();
                              const doc = parser.parseFromString(inner, 'text/html');
                              let text = '';
                              const userNameElements = doc.querySelectorAll('.user-name');
                              if (userNameElements.length > 0) {
                                userNameElements.forEach(el => {
                                  const nameText = el.querySelector('.fw-medium')?.textContent || el
                                    .querySelector('.d-block')?.textContent || el.textContent;
                                  text += nameText.trim() + ' ';
                                });
                              } else {
                                text = doc.body.textContent || doc.body.innerText;
                              }
                              return text.trim();
                            }
                          }
                        }
                      },
                      {
                        extend: 'excel',
                        text: `<span class="d-flex align-items-center"><i class="icon-base ri ri-file-excel-line me-1"></i>Excel</span>`,
                        className: 'dropdown-item',
                        exportOptions: {
                          columns: [3, 4, 5, 6, 7],
                          format: {
                            body: function(inner, coldex, rowdex) {
                              if (inner.length <= 0) return inner;
                              const parser = new DOMParser();
                              const doc = parser.parseFromString(inner, 'text/html');
                              let text = '';
                              const userNameElements = doc.querySelectorAll('.user-name');
                              if (userNameElements.length > 0) {
                                userNameElements.forEach(el => {
                                  const nameText = el.querySelector('.fw-medium')?.textContent || el
                                    .querySelector('.d-block')?.textContent || el.textContent;
                                  text += nameText.trim() + ' ';
                                });
                              } else {
                                text = doc.body.textContent || doc.body.innerText;
                              }
                              return text.trim();
                            }
                          }
                        }
                      },
                      {
                        extend: 'pdf',
                        text: `<span class="d-flex align-items-center"><i class="icon-base ri ri-file-pdf-line me-1"></i>Pdf</span>`,
                        className: 'dropdown-item',
                        exportOptions: {
                          columns: [3, 4, 5, 6, 7],
                          format: {
                            body: function(inner, coldex, rowdex) {
                              if (inner.length <= 0) return inner;
                              const parser = new DOMParser();
                              const doc = parser.parseFromString(inner, 'text/html');
                              let text = '';
                              const userNameElements = doc.querySelectorAll('.user-name');
                              if (userNameElements.length > 0) {
                                userNameElements.forEach(el => {
                                  const nameText = el.querySelector('.fw-medium')?.textContent || el
                                    .querySelector('.d-block')?.textContent || el.textContent;
                                  text += nameText.trim() + ' ';
                                });
                              } else {
                                text = doc.body.textContent || doc.body.innerText;
                              }
                              return text.trim();
                            }
                          }
                        }
                      },
                      {
                        extend: 'copy',
                        text: `<i class="icon-base ri ri-file-copy-line me-1"></i>Copy`,
                        className: 'dropdown-item',
                        exportOptions: {
                          columns: [3, 4, 5, 6, 7],
                          format: {
                            body: function(inner, coldex, rowdex) {
                              if (inner.length <= 0) return inner;
                              const parser = new DOMParser();
                              const doc = parser.parseFromString(inner, 'text/html');
                              let text = '';
                              const userNameElements = doc.querySelectorAll('.user-name');
                              if (userNameElements.length > 0) {
                                userNameElements.forEach(el => {
                                  const nameText = el.querySelector('.fw-medium')?.textContent || el
                                    .querySelector('.d-block')?.textContent || el.textContent;
                                  text += nameText.trim() + ' ';
                                });
                              } else {
                                text = doc.body.textContent || doc.body.innerText;
                              }
                              return text.trim();
                            }
                          }
                        }
                      }
                    ]
                  },
                  {
                    text: '<span class="d-flex align-items-center"><i class="icon-base ri ri-add-line icon-18px me-sm-1"></i><span class="d-none d-sm-inline-block">Add New Record</span></span>',
                    className: 'create-new-form-btn btn btn-primary'
                  }
                ]
              }]
            },
            topStart: {
              rowClass: 'row m-3 mx-2 my-0 justify-content-between',
              features: [{
                pageLength: {
                  menu: [7, 10, 25, 50, 100],
                  text: 'Show_MENU_entries'
                }
              }]
            },
            topEnd: {
              search: {
                placeholder: 'Type search here'
              }
            },
            bottomStart: {
              rowClass: 'row mx-3 justify-content-between',
              features: ['info']
            },
            bottomEnd: 'paging'
          },
          displayLength: 7,
          language: {
            paginate: {
              next: '<i class="icon-base ri ri-arrow-right-s-line scaleX-n1-rtl icon-22px"></i>',
              previous: '<i class="icon-base ri ri-arrow-left-s-line scaleX-n1-rtl icon-22px"></i>',
              first: '<i class="icon-base ri ri-skip-back-mini-line scaleX-n1-rtl icon-22px"></i>',
              last: '<i class="icon-base ri ri-skip-forward-mini-line scaleX-n1-rtl icon-22px"></i>'
            }
          },
          responsive: {
            details: {
              display: DataTable.Responsive.display.modal({
                header: function(row) {
                  const data = row.data();
                  return 'Details of ' + data['name'];
                }
              }),
              type: 'column',
              renderer: function(api, rowIdx, columns) {
                const data = columns
                  .map(function(col) {
                    return col.title !== '' ?
                      `<tr data-dt-row="${col.rowIndex}" data-dt-column="${col.columnIndex}">
                      <td>${col.title}:</td>
                      <td>${col.data}</td>
                    </tr>` :
                      '';
                  })
                  .join('');

                if (data) {
                  const div = document.createElement('div');
                  div.classList.add('table-responsive');
                  const table = document.createElement('table');
                  div.appendChild(table);
                  table.classList.add('table');
                  table.classList.add('datatables-basic');
                  const tbody = document.createElement('tbody');
                  tbody.innerHTML = data;
                  table.appendChild(tbody);
                  return div;
                }
                return false;
              }
            }
          },
          initComplete: function(settings, json) {
            $('.card-header').after('<hr class="my-0">');
          }
        });

        fv.on('core.form.valid', function() {
          let shopId = document.querySelector('#shopId').value;
          let new_name = document.querySelector('.add-new-record .dt-shop-name').value;
          let new_code = document.querySelector('.add-new-record .dt-code').value;
          let new_address = document.querySelector('.add-new-record .dt-address').value;
          let new_phone = document.querySelector('.add-new-record .dt-phone').value;
          let new_manager = document.querySelector('.add-new-record .dt-manager').value;

          const isEditing = shopId && shopId.trim() !== '';
          const url = isEditing ? `/api/shops/${shopId}` : '/api/shops';
          const method = isEditing ? 'PUT' : 'POST';

          fetch(url, {
              method: method,
              headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
              },
              credentials: 'include',
              body: JSON.stringify({
                name: new_name,
                code: new_code,
                address: new_address,
                phone: new_phone,
                manager_user_id: new_manager || null
              })
            })
            .then(response => {
              if (!response.ok) {
                return response.json().then(err => {
                  throw new Error(err.message || 'Request failed');
                });
              }
              return response.json();
            })
            .then(data => {
              if (data.success) {
                // Close the offcanvas
                if (offCanvasEl) {
                  offCanvasEl.hide();
                }
                // Reset form
                formAddNewRecord.reset();
                // Reload the page to refresh the table
                window.location.reload();
              } else {
                alert(data.message || 'An error occurred');
              }
            })
            .catch(error => {
              console.error('Error:', error);
              alert('An error occurred while saving the shop');
            });
          return false;
        });

        document.addEventListener('click', function(e) {
          if (e.target.closest('.item-edit')) {
            const row = e.target.closest('tr');
            const shopId = row.getAttribute('data-shop-id');

            const shopName = row.querySelector('.shop_name')?.textContent.trim() || '';
            const shopCode = row.querySelector('.shop_code')?.textContent.trim() || '';
            const address = row.querySelectorAll('td')[4]?.innerText.trim() || '';
            const phone = row.querySelectorAll('td')[5]?.innerText.trim() || '';
            const manager = row.querySelectorAll('td')[6]?.getAttribute('data-id') || '';
            const select = document.querySelector('.dt-manager');

            console.log('[v0] Edit data extracted:', {
              shopId,
              shopName,
              shopCode,
              address,
              phone,
              manager
            });

            document.getElementById('formTitle').textContent = 'Edit Shop';
            document.getElementById('shopId').value = shopId;
            console.log(shopId)
            document.querySelector('.dt-shop-name').value = shopName;
            document.querySelector('.dt-code').value = shopCode;
            document.querySelector('.dt-address').value = address;
            document.querySelector('.dt-phone').value = phone;
            document.querySelector('.dt-manager').value = manager;
            select.value = manager; // Set the value
            $(select).trigger('change');
            offCanvasEl = new bootstrap.Offcanvas(document.querySelector('#add-new-record'));
            offCanvasEl.show();
          }
        });

        // Delete record handler
        $(document).on('click', '.delete-record', function(e) {
          e.preventDefault();
          const row = $(this).closest('tr');
          const shopId = row.attr('data-shop-id');

          if (confirm('Are you sure you want to delete this shop?')) {
            fetch(`/api/shops/${shopId}`, {
                method: 'DELETE',
                headers: {
                  'Content-Type': 'application/json',
                  'Accept': 'application/json',
                  'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                credentials: 'include'
              })
              .then(response => response.json())
              .then(data => {
                if (data.success) {
                  // Close modal if open
                  const modalEl = document.querySelector('.dtr-bs-modal');
                  if (modalEl && modalEl.classList.contains('show')) {
                    const modal = bootstrap.Modal.getInstance(modalEl);
                    modal?.hide();
                  }
                  // Reload the page to refresh the table
                  window.location.reload();
                } else {
                  alert(data.message || 'An error occurred');
                }
              })
              .catch(error => {
                console.error('Error:', error);
                alert('An error occurred while deleting the shop');
              });
          }
        });
      }

      setTimeout(() => {
        const elementsToModify = [{
            selector: '.dt-buttons .btn',
            classToRemove: 'btn-secondary'
          },
          {
            selector: '.dt-layout-table',
            classToRemove: 'row mt-2'
          },
          {
            selector: '.dt-layout-end',
            classToAdd: 'mt-0',
            classToRemove: 'ms-auto'
          },
          {
            selector: '.dt-layout-end .dt-search',
            classToAdd: 'mt-md-5 mt-0',
            classToRemove: 'ms-auto'
          },
          {
            selector: '.dt-layout-full',
            classToRemove: 'col-md col-12',
            classToAdd: 'table-responsive'
          }
        ];

        elementsToModify.forEach(({
          selector,
          classToRemove,
          classToAdd
        }) => {
          document.querySelectorAll(selector).forEach(element => {
            if (classToRemove) {
              classToRemove.split(' ').forEach(className => element.classList.remove(className));
            }
            if (classToAdd) {
              classToAdd.split(' ').forEach(className => element.classList.add(className));
            }
          });
        });
      }, 100);
      $('#basicManager').select2({
        placeholder: 'Manager Name',
        allowClear: true,
        dropdownParent: $('#basicManager').closest('.form-floating')
      });

      document.querySelector('.create-new-form-btn').addEventListener('click', function() {

        document.getElementById('shopForm').reset();

        document.getElementById('shopForm').action = '/shops';
        document.getElementById('methodField').value = 'POST';
        document.getElementById('shopId').value = '';

        document.getElementById('submitBtn').textContent = 'Create Shop';
      });

      document.querySelectorAll('.item-edit').forEach(btn => {
        btn.addEventListener('click', function() {

          const row = this.closest('tr');
          const id = row.getAttribute('data-shop-id');

          // Fill the form
          // document.getElementById('shopName').value = row.querySelector('.shop_name').innerText;
          // document.getElementById('shopCode').value = row.querySelector('.shop_code').innerText;
          // document.getElementById('shopAddress').value = row.children[5].innerText.trim();
          // document.getElementById('shopPhone').value = row.children[6].innerText.trim();


          // Set action to PUT /shops/{id}
          document.getElementById('shopForm').action = '/shops/' + id;
          document.getElementById('methodField').value = 'PUT';
          document.getElementById('shopId').value = id;

          document.getElementById('submitBtn').textContent = 'Update Shop';
        });
      });


    });
  </script>
@endsection
