@extends('layouts/layoutMaster')

@section('title', 'Account Settings - Equipment Renting System')

<!-- Vendor Styles -->
@section('vendor-style')
  @vite(['resources/assets/vendor/libs/select2/select2.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss', 'resources/assets/vendor/libs/animate-css/animate.scss', 'resources/assets/vendor/libs/tagify/tagify.scss', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
  @vite(['resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/tagify/tagify.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js', 'resources/assets/vendor/libs/cleave-zen/cleave-zen.js', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.js'])
@endsection

@section('content')
  <div class="row">
    <div class="col-md-12">
      <div class="nav-align-top">
        <ul class="nav nav-pills flex-column flex-md-row mb-6 gap-2 gap-lg-0">
          <li class="nav-item">
            <a class="nav-link active" href="javascript:void(0);"><i
                class="icon-base ri ri-group-line icon-sm me-2"></i>Account</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="javascript:void(0);"><i
                class="icon-base ri ri-lock-line icon-sm me-2"></i>Security</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="javascript:void(0);"><i
                class="icon-base ri ri-bookmark-line icon-sm me-2"></i>Billing & Plans</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="javascript:void(0);"><i
                class="icon-base ri ri-notification-4-line icon-sm me-2"></i>Notifications</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="javascript:void(0);"><i
                class="icon-base ri ri-link-m icon-sm me-2"></i>Connections</a>
          </li>
        </ul>
      </div>
      <div class="card mb-6">
        <!-- Account -->
        <div class="card-body">
          <div class="d-flex align-items-start align-items-sm-center gap-6">
            <img src="{{ $user->profile_image ? asset('storage/' . $user->profile_image) : asset('assets/img/avatars/1.png') }}" alt="user-avatar"
              class="d-block w-px-100 h-px-100 rounded-4" id="uploadedAvatar" />
            <div class="button-wrapper">
              <label for="upload" class="btn btn-primary me-3 mb-4" tabindex="0">
                <span class="d-none d-sm-block">Upload new photo</span>
                <i class="icon-base ri ri-upload-2-line d-block d-sm-none"></i>
                <input type="file" id="upload" class="account-file-input" name="upload" hidden accept="image/png, image/jpeg" />
              </label>
              <button type="button" class="btn btn-outline-danger account-image-reset mb-4">
                <i class="icon-base ri ri-refresh-line d-block d-sm-none"></i>
                <span class="d-none d-sm-block">Reset</span>
              </button>

              <div>Allowed JPG, GIF or PNG. Max size of 800K</div>
            </div>
          </div>
        </div>
        <div class="card-body pt-0">
          <form id="formAccountSettings" method="POST" action="{{ route('settings.account.update') }}" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="row mt-1 g-5">
              @php
                $nameParts = explode(' ', $user->name ?? '', 2);
                $firstName = $nameParts[0] ?? '';
                $lastName = $nameParts[1] ?? '';
              @endphp
              <div class="col-md-6 form-control-validation">
                <div class="form-floating form-floating-outline">
                  <input class="form-control" type="text" id="firstName" name="firstName" value="{{ $firstName }}" autofocus />
                  <label for="firstName">First Name</label>
                </div>
              </div>
              <div class="col-md-6 form-control-validation">
                <div class="form-floating form-floating-outline">
                  <input class="form-control" type="text" name="lastName" id="lastName" value="{{ $lastName }}" />
                  <label for="lastName">Last Name</label>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-floating form-floating-outline">
                  <input class="form-control" type="text" id="email" name="email" value="{{ $user->email }}"
                    placeholder="john.doe@example.com" />
                  <label for="email">E-mail</label>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-floating form-floating-outline">
                  <input type="text" class="form-control" id="organization" name="organization"
                    value="{{ config('variables.creatorName') }}" />
                  <label for="organization">Organization</label>
                </div>
              </div>
              <div class="col-md-6">
                <div class="input-group input-group-merge">
                  <div class="form-floating form-floating-outline">
                    <input type="text" id="phoneNumber" name="phoneNumber" class="form-control"
                      value="{{ $user->phone ?? '' }}" />
                    <label for="phoneNumber">Phone Number</label>
                  </div>
                  <span class="input-group-text">US (+1)</span>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-floating form-floating-outline">
                  <input type="text" class="form-control" id="address" name="address"
                    value="" />
                  <label for="address">Address</label>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-floating form-floating-outline">
                  <input class="form-control" type="text" id="state" name="state" value="" />
                  <label for="state">State</label>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-floating form-floating-outline">
                  <input type="text" class="form-control" id="zipCode" name="zipCode" value=""
                    maxlength="6" />
                  <label for="zipCode">Zip Code</label>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-floating form-floating-outline">
                  <select id="country" name="country" class="select2 form-select">
                    <option value="Australia">Australia</option>
                    <option value="Bangladesh">Bangladesh</option>
                    <option value="Belarus">Belarus</option>
                    <option value="Brazil">Brazil</option>
                    <option value="Canada">Canada</option>
                    <option value="China">China</option>
                    <option value="France">France</option>
                    <option value="Germany">Germany</option>
                    <option value="India" selected>India</option>
                    <option value="Indonesia">Indonesia</option>
                    <option value="Israel">Israel</option>
                    <option value="Italy">Italy</option>
                    <option value="Japan">Japan</option>
                    <option value="Korea">Korea, Republic of</option>
                    <option value="Mexico">Mexico</option>
                    <option value="Philippines">Philippines</option>
                    <option value="Russia">Russian Federation</option>
                    <option value="South Africa">South Africa</option>
                    <option value="Thailand">Thailand</option>
                    <option value="Turkey">Turkey</option>
                    <option value="Ukraine">Ukraine</option>
                    <option value="United Arab Emirates">United Arab Emirates</option>
                    <option value="United Kingdom">United Kingdom</option>
                    <option value="United States">United States</option>
                  </select>
                  <label for="country">Country</label>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-floating form-floating-outline">
                  <input id="TagifyLanguageSuggestion" name="language" class="form-control h-auto"
                    placeholder="select language" value="English" />
                  <label for="TagifyLanguageSuggestion">Language</label>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-floating form-floating-outline">
                  <select id="timeZones" name="timezone" class="select2 form-select">
                    <option value="-12" selected>(GMT-12:00) International Date Line West</option>
                    <option value="-11">(GMT-11:00) Midway Island, Samoa</option>
                    <option value="-10">(GMT-10:00) Hawaii</option>
                    <option value="-9">(GMT-09:00) Alaska</option>
                    <option value="-8">(GMT-08:00) Pacific Time (US & Canada)</option>
                    <option value="-8">(GMT-08:00) Tijuana, Baja California</option>
                    <option value="-7">(GMT-07:00) Arizona</option>
                    <option value="-7">(GMT-07:00) Chihuahua, La Paz, Mazatlan</option>
                    <option value="-7">(GMT-07:00) Mountain Time (US & Canada)</option>
                    <option value="-6">(GMT-06:00) Central America</option>
                    <option value="-6">(GMT-06:00) Central Time (US & Canada)</option>
                    <option value="-6">(GMT-06:00) Guadalajara, Mexico City, Monterrey</option>
                    <option value="-6">(GMT-06:00) Saskatchewan</option>
                    <option value="-5">(GMT-05:00) Bogota, Lima, Quito, Rio Branco</option>
                    <option value="-5">(GMT-05:00) Eastern Time (US & Canada)</option>
                    <option value="-5">(GMT-05:00) Indiana (East)</option>
                    <option value="-4">(GMT-04:00) Atlantic Time (Canada)</option>
                    <option value="-4">(GMT-04:00) Caracas, La Paz</option>
                  </select>
                  <label for="timeZones">Timezone</label>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-floating form-floating-outline">
                  <select id="currency" name="currency" class="select2 form-select">
                    <option value="usd" selected>USD</option>
                    <option value="euro">Euro</option>
                    <option value="pound">Pound</option>
                    <option value="bitcoin">Bitcoin</option>
                  </select>
                  <label for="currency">Currency</label>
                </div>
              </div>
            </div>
            <div class="mt-6">
              <button type="submit" class="btn btn-primary me-3">Save changes</button>
              <button type="reset" class="btn btn-outline-secondary">Reset</button>
            </div>
          </form>
        </div>
        <!-- /Account -->
      </div>
      <div class="card">
        <h5 class="card-header mb-1">Delete Account</h5>
        <div class="card-body">
          <div class="mb-6 col-12 mb-0">
            <div class="alert alert-warning">
              <h6 class="alert-heading mb-1">Are you sure you want to delete your account?</h6>
              <p class="mb-0">Once you delete your account, there is no going back. Please be certain.</p>
            </div>
          </div>
          <form id="formAccountDeactivation" onsubmit="return false">
            <div class="form-check mb-6">
              <input class="form-check-input" type="checkbox" name="accountActivation" id="accountActivation" />
              <label class="form-check-label" for="accountActivation">I confirm my account deactivation</label>
            </div>
            <button type="submit" class="btn btn-danger deactivate-account" disabled="disabled">Deactivate
              Account</button>
          </form>
        </div>
      </div>
    </div>
  </div>
@endsection

@section('page-script')
  <script>
    'use strict';
    
    // Account file upload preview
    document.addEventListener('DOMContentLoaded', function() {
      const accountUserImage = document.getElementById('uploadedAvatar');
      const fileInput = document.querySelector('.account-file-input');
      const resetBtn = document.querySelector('.account-image-reset');

      if (fileInput) {
        fileInput.addEventListener('change', function(e) {
          const file = e.target.files[0];
          if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
              accountUserImage.src = e.target.result;
            };
            reader.readAsDataURL(file);
          }
        });
      }

      if (resetBtn) {
        resetBtn.addEventListener('click', function() {
          fileInput.value = '';
          accountUserImage.src = '{{ $user->profile_image ? asset("storage/" . $user->profile_image) : asset("assets/img/avatars/1.png") }}';
        });
      }

      // Initialize Select2
      if (typeof $ !== 'undefined' && $.fn.select2) {
        $('#country, #timeZones, #currency').select2();
      }

      // Initialize Tagify for language
      if (typeof Tagify !== 'undefined') {
        const languageInput = document.getElementById('TagifyLanguageSuggestion');
        if (languageInput) {
          new Tagify(languageInput, {
            whitelist: ['English', 'Spanish', 'French', 'German', 'Italian', 'Portuguese', 'Chinese', 'Japanese', 'Korean', 'Arabic', 'Hindi'],
            maxTags: 1,
            dropdown: {
              maxItems: 20,
              classname: 'tags-look',
              enabled: 0,
              closeOnSelect: false
            }
          });
        }
      }

      // Account deactivation checkbox
      const accountActivation = document.getElementById('accountActivation');
      const deactivateBtn = document.querySelector('.deactivate-account');
      
      if (accountActivation && deactivateBtn) {
        accountActivation.addEventListener('change', function() {
          deactivateBtn.disabled = !this.checked;
        });
      }
    });
  </script>
@endsection
