@extends('layouts/layoutMaster')

@section('title', 'Invoice Preview - Equipment Renting System')

@section('vendor-style')
  @vite('resources/assets/vendor/libs/flatpickr/flatpickr.scss')
@endsection

@section('page-style')
  @vite('resources/assets/vendor/scss/pages/app-invoice.scss')
  <style>
    @media print {
      @page {
        margin: 0.5cm;
      }

      * {
        -webkit-print-color-adjust: exact !important;
        print-color-adjust: exact !important;
      }

      body {
        background: white !important;
      }

      /* Hide layout elements and action buttons */
      .no-print,
      .invoice-actions,
      .layout-navbar,
      .layout-menu,
      .layout-footer,
      .layout-overlay,
      .navbar,
      .footer,
      .content-footer,
      aside,
      .layout-menu-toggle,
      .btn,
      .dropdown,
      .offcanvas {
        display: none !important;
      }

      /* Show invoice content */
      .invoice-preview {
        margin: 0 !important;
        padding: 0 !important;
      }

      .invoice-preview-card {
        border: none !important;
        box-shadow: none !important;
        margin: 0 !important;
        padding: 1rem !important;
        background: white !important;
      }
    }
  </style>
@endsection

@section('vendor-script')
  @vite(['resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/js/offcanvas-add-payment.js'])
@endsection

@section('page-script')
  <script>
    'use strict';
    document.addEventListener('DOMContentLoaded', function() {
      // Print function
      $('#printBtn').on('click', function() {
        window.print();
      });

      // Download PDF
      $('#downloadBtn').on('click', function() {
        window.location.href = '{{ route('invoices.download', $invoice) }}';
      });

      // Payment form submission
      $('#paymentForm').on('submit', function(e) {
        e.preventDefault();
        
        const formData = {
          invoice_id: $('#invoice-id').val(),
          amount: parseFloat($('#invoiceAmount').val()),
          method: $('#payment-method').val(),
          paid_at: $('#payment-date').val(),
          notes: $('#payment-note').val() || null,
        };

        fetch('/api/payments', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json',
            'Accept': 'application/json',
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          body: JSON.stringify(formData)
        })
        .then(response => response.json())
        .then(data => {
          if (data.success) {
            // Close offcanvas
            const offcanvasElement = document.getElementById('addPaymentOffcanvas');
            const offcanvas = bootstrap.Offcanvas.getInstance(offcanvasElement);
            if (offcanvas) {
              offcanvas.hide();
            }
            
            // Reload page to show updated payment status
            window.location.reload();
          } else {
            alert('Error: ' + (data.message || 'Failed to add payment'));
          }
        })
        .catch(error => {
          console.error('Error:', error);
          alert('An error occurred while adding payment');
        });
      });
    });
  </script>
@endsection

@section('content')
  <div class="row invoice-preview">
    <!-- Invoice -->
    <div class="col-xl-9 col-md-8 col-12 mb-md-0 mb-6">
      <div class="card invoice-preview-card p-sm-12 p-6">
        <div class="card-body invoice-preview-header rounded-4 p-6">
          <div
            class="d-flex justify-content-between flex-xl-row flex-md-column flex-sm-row flex-column text-heading align-items-xl-center align-items-md-start align-items-sm-center flex-wrap gap-6">
            <div>
              <div class="d-flex svg-illustration align-items-center gap-2 mb-3">
                <a href="{{url('/')}}" class="app-brand-link gap-2">
                  <img src="{{ asset('assets/img/branding/logo.png') }}" alt="brand-logo"
                       width="200" class="rounded-4" />
                </a>

              </div>
              <p class="mb-1">{{ $invoice->rental->shop->name ?? 'Equipment Renting System' }}</p>
              <p class="mb-1">{{ $invoice->rental->shop->address ?? 'N/A' }}</p>
              <p class="mb-0">{{ $invoice->rental->shop->phone ?? 'N/A' }}</p>
            </div>
            <div>
              <h5 class="mb-6 text-nowrap">Invoice #{{ $invoice->invoice_number }}</h5>
              @if($invoice->isOverdue())
              <div class="alert alert-danger mb-3 p-2">
                <strong>⚠ OVERDUE INVOICE</strong>
              </div>
              @endif
              <div class="mb-1">
                <span>Job Number:</span>
                <span>#{{ $invoice->rental->id }}</span>
              </div>
              <div class="mb-1">
                <span>Date Issued:</span>
                <span>{{ $invoice->issued_at->format('F d, Y') }}</span>
              </div>
              @if ($invoice->due_date)
                <div>
                  <span>Due Date:</span>
                  <span class="{{ $invoice->isOverdue() ? 'text-danger fw-bold' : '' }}">
                    {{ $invoice->due_date->format('F d, Y') }}
                    @if($invoice->isOverdue())
                      (OVERDUE)
                    @endif
                  </span>
                </div>
              @elseif ($invoice->rental->expected_return_date)
                <div>
                  <span>Expected Return:</span>
                  <span>{{ $invoice->rental->expected_return_date->format('F d, Y') }}</span>
                </div>
              @endif
            </div>
          </div>
        </div>
        <div class="card-body py-6 px-0">
          <div class="d-flex justify-content-between flex-wrap gap-6">
            <div>
              <h6>Invoice To:</h6>
              <p class="mb-1"><strong>{{ $invoice->rental->customer?->name ?? 'Walk-in Customer' }}</strong></p>
              @if ($invoice->rental->customer?->address)
                <p class="mb-1">{{ $invoice->rental->customer->address }}</p>
              @endif
              @if ($invoice->rental->customer?->phone)
                <p class="mb-1">{{ $invoice->rental->customer->phone }}</p>
              @endif
              @if ($invoice->rental->customer?->nic_number)
                <p class="mb-0">NIC: {{ $invoice->rental->customer->nic_number }}</p>
              @endif
            </div>
            <div>
              <h6>Bill To:</h6>
              <table>
                <tbody>
                  <tr>
                    <td class="pe-4">Total Due:</td>
                    <td>Rs. {{ number_format($invoice->amount, 2) }}</td>
                  </tr>
                  <tr>
                    <td class="pe-4">Status:</td>
                    <td>
                      <span
                        class="badge bg-{{ $invoice->status === 'paid' ? 'success' : ($invoice->status === 'partially_paid' ? 'warning' : 'danger') }}">
                        {{ ucfirst(str_replace('_', ' ', $invoice->status)) }}
                      </span>
                    </td>
                  </tr>
                  <tr>
                    <td class="pe-4">Rental Date:</td>
                    <td>{{ $invoice->rental->rental_date->format('M d, Y H:i') }}</td>
                  </tr>
                  @if ($invoice->rental->actual_return_date)
                    <tr>
                      <td class="pe-4">Returned:</td>
                      <td>{{ $invoice->rental->actual_return_date->format('M d, Y H:i') }}</td>
                    </tr>
                  @endif
                </tbody>
              </table>
            </div>
          </div>
        </div>
        <div class="table-responsive border rounded-4 border-bottom-0">
          <table class="table m-0">
            <thead>
              <tr>
                <th>Item</th>
                <th>Rate/Day</th>
                <th>Qty</th>
                <th>Days</th>
                <th>Price</th>
              </tr>
            </thead>
            <tbody>
              @foreach ($invoice->rental->rentalItems as $item)
                <tr>
                  <td class="text-nowrap text-heading">{{ $item->equipment->name }}</td>
                  <td>Rs. {{ number_format($item->daily_rate, 2) }}</td>
                  <td>{{ $item->quantity }}</td>
                  <td>{{ number_format($item->days, 2) }}</td>
                  <td>Rs. {{ number_format($item->subtotal, 2) }}</td>
                </tr>
              @endforeach
            </tbody>
          </table>
        </div>
        <div class="table-responsive">
          <table class="table m-0 table-borderless">
            <tbody>
              <tr>
                <td class="align-top px-0 py-6">
                  @if ($invoice->rental->remarks)
                    <p class="mb-1">
                      <span class="me-2 fw-medium text-heading">Remarks:</span>
                      <span>{{ $invoice->rental->remarks }}</span>
                    </p>
                  @endif
                  <span>Thanks for your business</span>
                </td>
                <td class="pe-0 py-6 w-px-100">
                  <p class="mb-1">Subtotal:</p>
                  @if ($invoice->rental->discount > 0)
                    <p class="mb-1">Discount:</p>
                  @endif
                  <p class="mb-1 border-bottom pb-2">Total:</p>
                </td>
                <td class="text-end px-0 py-6 w-px-100">
                  <p class="fw-medium mb-1">Rs. {{ number_format($invoice->rental->total_amount, 2) }}</p>
                  @if ($invoice->rental->discount > 0)
                    <p class="fw-medium mb-1">Rs. {{ number_format($invoice->rental->discount, 2) }}</p>
                  @endif
                  <p class="fw-medium mb-0 pt-2 border-top">Rs. {{ number_format($invoice->rental->grand_total, 2) }}</p>
                </td>
              </tr>
            </tbody>
          </table>
        </div>

        @if ($invoice->rental->remarks)
          <hr class="mt-0 mb-6" />
          <div class="card-body p-0">
            <div class="row">
              <div class="col-12">
                <span class="fw-medium text-heading">Note:</span>
                <span>{{ $invoice->rental->remarks }}</span>
              </div>
            </div>
          </div>
        @endif
      </div>
    </div>
    <!-- /Invoice -->

    <!-- Invoice Actions -->
    <div class="col-xl-3 col-md-4 col-12 invoice-actions no-print">
      <div class="card">
        <div class="card-body">
          <button type="button" id="printBtn" class="btn btn-primary d-grid w-100 mb-4">
            <span class="d-flex align-items-center justify-content-center text-nowrap">
              <i class="icon-base ri ri-printer-line icon-16px scaleX-n1-rtl me-2"></i>Print A4 Invoice</span>
          </button>
          <a href="{{ route('invoices.thermal', $invoice) }}" target="_blank" class="btn btn-outline-primary d-grid w-100 mb-4">
            <span class="d-flex align-items-center justify-content-center text-nowrap">
              <i class="icon-base ri ri-printer-line icon-16px scaleX-n1-rtl me-2"></i>Print Thermal Receipt</span>
          </a>
          <button type="button" id="downloadBtn" class="btn btn-outline-secondary d-grid w-100 mb-4">
            <span class="d-flex align-items-center justify-content-center text-nowrap">
              <i class="icon-base ri ri-download-line icon-16px scaleX-n1-rtl me-2"></i>Download PDF</span>
          </button>
          <div class="d-flex mb-4">
            <a href="{{ route('rentals') }}" class="btn btn-outline-secondary d-grid w-100 me-4">
              <span class="d-flex align-items-center justify-content-center text-nowrap">
                <i class="icon-base ri ri-arrow-left-line icon-16px scaleX-n1-rtl me-2"></i>Back to Rentals</span>
            </a>
          </div>
          @php
            $agreement = $invoice->rental->agreement;
          @endphp
          @if($agreement)
            <a href="{{ route('agreements.preview', $agreement->id) }}" class="btn btn-info d-grid w-100 mb-4">
              <span class="d-flex align-items-center justify-content-center text-nowrap">
                <i class="icon-base ri ri-file-text-line icon-16px scaleX-n1-rtl me-2"></i>View Agreement (Job #{{ $invoice->rental->id }})</span>
            </a>
          @endif
          @if($invoice->canBeEdited())
            <a href="{{ route('invoices.edit', $invoice) }}" class="btn btn-warning d-grid w-100 mb-4">
              <span class="d-flex align-items-center justify-content-center text-nowrap">
                <i class="icon-base ri ri-edit-line icon-16px scaleX-n1-rtl me-2"></i>Edit Invoice</span>
            </a>
          @else
            <button type="button" class="btn btn-outline-secondary d-grid w-100 mb-4" disabled>
              <span class="d-flex align-items-center justify-content-center text-nowrap">
                <i class="icon-base ri ri-edit-line icon-16px scaleX-n1-rtl me-2"></i>Edit Invoice (Payment Processed)</span>
            </button>
          @endif
          @if ($invoice->status !== 'paid')
            <button type="button" class="btn btn-success d-grid w-100" data-bs-toggle="offcanvas"
              data-bs-target="#addPaymentOffcanvas">
              <span class="d-flex align-items-center justify-content-center text-nowrap">
                <i class="icon-base ri ri-money-dollar-circle-line icon-16px scaleX-n1-rtl me-2"></i>Add Payment</span>
            </button>
          @endif
        </div>
      </div>
    </div>
    <!-- /Invoice Actions -->
  </div>

  <!-- Offcanvas -->
  @include('_partials/_offcanvas/offcanvas-add-payment')
  <!-- /Offcanvas -->
@endsection
