@extends('layouts/layoutMaster')

@section('title', 'Edit Invoice - Equipment Renting System')

@section('vendor-style')
@vite('resources/assets/vendor/libs/flatpickr/flatpickr.scss')
@endsection

@section('page-style')
@vite('resources/assets/vendor/scss/pages/app-invoice.scss')
<style>
  @media print {
    .no-print {
      display: none !important;
    }
    .card {
      border: none !important;
      box-shadow: none !important;
    }
  }
  .overdue-badge {
    font-size: 1.2em;
    font-weight: bold;
    color: #dc3545;
  }
</style>
@endsection

@section('vendor-script')
@vite([
'resources/assets/vendor/libs/flatpickr/flatpickr.js',
'resources/assets/vendor/libs/cleave-zen/cleave-zen.js',
])
@endsection

@section('page-script')
<script>
  'use strict';
  document.addEventListener('DOMContentLoaded', function() {
    // Initialize flatpickr for due date
    const dueDateInput = document.getElementById('due_date');
    if (dueDateInput) {
      flatpickr(dueDateInput, {
        dateFormat: 'Y-m-d',
        enableTime: false,
      });
    }
  });
</script>
@endsection

@section('content')
<div class="row invoice-edit">
  <!-- Invoice Edit-->
  <div class="col-lg-9 col-12 mb-lg-0 mb-6">
    <div class="card invoice-preview-card p-sm-12 p-6">
      @if($invoice->isOverdue())
      <div class="alert alert-danger mb-4">
        <strong class="overdue-badge">⚠ OVERDUE INVOICE</strong>
        <p class="mb-0">This invoice is past its due date. Please update the due date if equipment handover was delayed.</p>
      </div>
      @endif

      @if(session('error'))
      <div class="alert alert-danger">
        {{ session('error') }}
      </div>
      @endif

      @if(session('success'))
      <div class="alert alert-success">
        {{ session('success') }}
      </div>
      @endif

      <form action="{{ route('invoices.update', $invoice) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="card-body invoice-preview-header rounded p-6 px-3 text-heading">
          <div class="row mx-0 px-3">
            <div class="col-md-7 mb-md-0 mb-6 ps-0">
              <div class="d-flex svg-illustration align-items-center gap-3 mb-6">
                <div>
                  <div class="d-flex svg-illustration align-items-center gap-2 mb-3">
                    <a href="{{url('/')}}" class="app-brand-link gap-2">
                      <img src="{{ asset('assets/img/branding/logo.png') }}" alt="brand-logo"
                           width="200" class="rounded-4" />
                    </a>
                  </div>
                </div>
              </div>
              <p class="mb-1">{{ $invoice->rental->shop->name ?? 'Equipment Renting System' }}</p>
              <p class="mb-1">{{ $invoice->rental->shop->address ?? 'Equipment Renting System' }}</p>
              <p class="mb-1">Phone: {{ $invoice->rental->shop->phone ?? 'N/A' }}</p>
            </div>
            <div class="col-md-5 col-8 pe-0 ps-0 ps-md-2">
              <dl class="row mb-0 gx-4">
                <dt class="col-sm-5 mb-2 d-md-flex align-items-center justify-content-start">
                  <span class="h5 text-capitalize mb-0 text-nowrap">Invoice</span>
                </dt>
                <dd class="col-sm-7">
                  <div class="input-group input-group-sm input-group-merge disabled">
                    <span class="input-group-text">#</span>
                    <input type="text" class="form-control" disabled value="{{ $invoice->invoice_number }}" />
                  </div>
                </dd>
                <dt class="col-sm-5 mb-2 d-md-flex align-items-center justify-content-start">
                  <span class="fw-normal text-nowrap">Date Issued:</span>
                </dt>
                <dd class="col-sm-7">
                  <input type="text" class="form-control form-control-sm" disabled value="{{ $invoice->issued_at->format('Y-m-d') }}" />
                </dd>
                <dt class="col-sm-5 d-md-flex align-items-center justify-content-start">
                  <span class="fw-normal">Due Date:</span>
                </dt>
                <dd class="col-sm-7 mb-0">
                  <input type="text" id="due_date" name="due_date" class="form-control form-control-sm @error('due_date') is-invalid @enderror" value="{{ old('due_date', $invoice->due_date?->format('Y-m-d') ?? $invoice->rental->expected_return_date?->format('Y-m-d')) }}" />
                  @error('due_date')
                    <div class="invalid-feedback">{{ $message }}</div>
                  @enderror
                  @if($invoice->isOverdue())
                    <span class="badge bg-danger mt-1">OVERDUE</span>
                  @endif
                </dd>
              </dl>
            </div>
          </div>
        </div>

        <div class="card-body px-0">
          <div class="row my-1">
            <div class="col-md-6 col-sm-5 col-12 mb-sm-0 mb-6">
              <h6>Invoice To:</h6>
              <p class="mb-1"><strong>{{ $invoice->rental->customer?->name ?? 'Walk-in Customer' }}</strong></p>
              <p class="mb-1">{{ $invoice->rental->customer?->address ?? 'N/A' }}</p>
              <p class="mb-1">{{ $invoice->rental->customer?->phone ?? 'N/A' }}</p>
              @if($invoice->rental->customer?->nic_number)
                <p class="mb-0">NIC: {{ $invoice->rental->customer->nic_number }}</p>
              @endif
            </div>
            <div class="col-md-6 col-sm-7">
              <h6>Bill To:</h6>
              <table>
                <tbody>
                  <tr>
                    <td class="pe-4">Total Due:</td>
                    <td>
                      <input type="number" step="0.01" name="amount" class="form-control form-control-sm @error('amount') is-invalid @enderror" value="{{ old('amount', $invoice->amount) }}" />
                      @error('amount')
                        <div class="invalid-feedback">{{ $message }}</div>
                      @enderror
                    </td>
                  </tr>
                  <tr>
                    <td class="pe-4">Status:</td>
                    <td>
                      <span class="badge bg-{{ $invoice->status === 'paid' ? 'success' : ($invoice->status === 'partially_paid' ? 'warning' : 'danger') }}">
                        {{ ucfirst(str_replace('_', ' ', $invoice->status)) }}
                      </span>
                    </td>
                  </tr>
                  <tr>
                    <td class="pe-4">Rental Date:</td>
                    <td>{{ $invoice->rental->rental_date->format('Y-m-d H:i') }}</td>
                  </tr>
                  @if($invoice->rental->actual_return_date)
                  <tr>
                    <td class="pe-4">Returned:</td>
                    <td>{{ $invoice->rental->actual_return_date->format('Y-m-d H:i') }}</td>
                  </tr>
                  @endif
                </tbody>
              </table>
            </div>
          </div>
        </div>
        <hr class="mb-6 mt-1" />
        <div class="card-body pt-0 px-0">
          <div class="mb-4">
            @foreach($invoice->rental->rentalItems as $index => $item)
            <div class="repeater-wrapper pt-0 pt-md-9">
              <div class="d-flex border rounded position-relative pe-0">
                <div class="row w-100 p-5 gx-5">
                  <div class="col-md-7 col-12 mb-md-0 mb-3">
                    <h6 class="mb-2 repeater-title fw-medium">Item</h6>
                    <input type="text" class="form-control item-details mb-4" value="{{ $item->equipment->name }}" readonly />
                    <textarea class="form-control" rows="2" readonly>{{ $item->equipment->description ?? 'N/A' }}</textarea>
                  </div>
                  <div class="col-md-2 col-12 mb-md-0 mb-5">
                    <h6 class="h6 repeater-title">Rate/Day</h6>
                    <input type="text" class="form-control invoice-item-price mb-5" value="{{ number_format($item->daily_rate, 2) }}" readonly />
                  </div>
                  <div class="col-md-2 col-12 mb-md-0 mb-4">
                    <h6 class="h6 repeater-title">Qty</h6>
                    <input type="text" class="form-control invoice-item-qty" value="{{ $item->quantity }}" readonly />
                  </div>
                  <div class="col-md-2 col-12 mb-md-0 mb-4">
                    <h6 class="h6 repeater-title">Days</h6>
                    <input type="text" class="form-control invoice-item-days" value="{{ number_format($item->days, 2) }}" readonly />
                  </div>
                  <div class="col-md-1 col-12 pe-0">
                    <h6 class="h6 repeater-title">Price</h6>
                    <p class="mb-0 mt-2 text-heading item-subtotal">{{ number_format($item->subtotal, 2) }} LKR</p>
                  </div>
                </div>
              </div>
            </div>
            @endforeach
          </div>
        </div>
        <hr class="my-1" />
        <div class="card-body px-0">
          <div class="row">
            <div class="col-md-6 mb-md-0 mb-3">
              @if($invoice->rental->remarks)
              <div class="d-flex align-items-center mb-4">
                <label class="me-2 h6 mb-2">Remarks:</label>
              </div>
              <p>{{ $invoice->rental->remarks }}</p>
              @endif
            </div>
            <div class="col-md-6 d-flex justify-content-md-end mt-2">
              <div class="invoice-calculations">
                <div class="d-flex justify-content-between mb-1">
                  <span class="w-px-100">Subtotal:</span>
                  <h6 class="mb-0 subtotal-amount">{{ number_format($invoice->rental->total_amount, 2) }} LKR</h6>
                </div>
                @if($invoice->rental->discount > 0)
                <div class="d-flex justify-content-between mb-1">
                  <span class="w-px-100">Discount:</span>
                  <h6 class="mb-0 discount-amount">{{ number_format($invoice->rental->discount, 2) }} LKR</h6>
                </div>
                @endif
                <hr class="my-2" />
                <div class="d-flex justify-content-between">
                  <span class="w-px-100">Total:</span>
                  <h6 class="mb-0 total-amount">{{ number_format($invoice->rental->grand_total, 2) }} LKR</h6>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="card-body px-0 mt-4">
          <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">Save Changes</button>
            <a href="{{ route('invoices.show', $invoice) }}" class="btn btn-outline-secondary">Cancel</a>
          </div>
        </div>
      </form>
    </div>
  </div>
  <!-- /Invoice Edit-->

  <!-- Invoice Actions -->
  <div class="col-lg-3 col-12 invoice-actions no-print">
    <div class="card mb-6">
      <div class="card-body">
        <a href="{{ route('invoices.show', $invoice) }}" class="btn btn-outline-secondary d-grid w-100 mb-4">Back to Invoice</a>
        <a href="{{ route('rentals') }}" class="btn btn-outline-secondary d-grid w-100 mb-4">Back to Rentals</a>
      </div>
    </div>
  </div>
  <!-- /Invoice Actions -->
</div>
@endsection
