@extends('layouts/layoutMaster')

@section('title', 'Categories - Equipment Renting System')

<!-- Vendor Styles -->
@section('vendor-style')
  @vite(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
  @vite(['resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js'])
@endsection

@section('content')
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <!-- DataTable with Buttons -->
  <div class="card">
    <div class="card-datatable text-nowrap">
      <table class="datatables-basic table table-bordered table-responsive">
        <thead>
        <tr>
          <th></th>
          <th></th>
          <th>ID</th>
          <th>Name</th>
          <th>Description</th>
          <th class="d-flex align-items-center">Action</th>
        </tr>
        </thead>
        <tbody>
        @foreach ($categories as $category)
          <tr data-category-id="{{ $category->id }}">
            <td></td>
            <td><input type="checkbox" class="dt-checkboxes form-check-input"></td>
            <td>{{ $loop->iteration + ($categories->currentPage() - 1) * $categories->perPage() }}</td>
            <td>
              <div class="d-flex justify-content-start align-items-center user-name">
                <div class="avatar-wrapper">
                  <div class="avatar me-2">
                    <span class="avatar-initial rounded-circle bg-label-primary">
                      {{ strtoupper(substr($category->name, 0, 2)) }}
                    </span>
                  </div>
                </div>
                <div class="d-flex flex-column">
                  <span class="category_name text-truncate h6 mb-0">{{ $category->name }}</span>
                </div>
              </div>
            </td>
            <td><span class="category_description text-truncate h6 mb-0">{{ $category->description ?? 'N/A' }}</span></td>
            <td>
              <div class="d-inline-block">
                <a href="javascript:;" class="btn btn-sm btn-text-secondary rounded-pill btn-icon dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                  <i class="icon-base ri ri-more-2-line icon-20px"></i>
                </a>
                <ul class="dropdown-menu dropdown-menu-end m-0">
                  <li><a href="javascript:;" class="dropdown-item item-details">Details</a></li>
                  <div class="dropdown-divider"></div>
                  <li><a href="javascript:;" class="dropdown-item text-danger delete-record" data-id="{{ $category->id }}">Delete</a></li>
                </ul>
              </div>
              <a href="javascript:;" class="btn btn-sm btn-text-secondary rounded-pill btn-icon item-edit">
                <i class="icon-base ri ri-edit-box-line icon-20px"></i>
              </a>
            </td>
          </tr>
        @endforeach
        </tbody>
      </table>
    </div>
  </div>

  <!-- Modal to add/edit category record -->
  <div class="offcanvas offcanvas-end" id="add-new-record">
    <div class="offcanvas-header border-bottom">
      <h5 class="offcanvas-title" id="formTitle">New Category</h5>
      <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body flex-grow-1">
      <form method="POST" class="add-new-record pt-0 row g-3" id="categoryForm">
        @csrf
        <input type="hidden" name="_method" id="methodField" value="POST">
        <input type="hidden" id="categoryId" name="categoryId" />

        <div class="col-sm-12 form-control-validation">
          <div class="input-group input-group-merge">
            <span id="basicCategoryName2" class="input-group-text">
              <i class="icon-base ri ri-folder-line icon-18px"></i>
            </span>
            <div class="form-floating form-floating-outline">
              <input type="text" id="basicCategoryName" class="form-control dt-category-name" name="basicCategoryName"
                     placeholder="Category Name" aria-label="Category Name" aria-describedby="basicCategoryName2" />
              <label for="basicCategoryName">Category Name</label>
            </div>
          </div>
        </div>

        <div class="col-sm-12 form-control-validation">
          <div class="input-group input-group-merge">
            <span id="basicDescription2" class="input-group-text">
              <i class="icon-base ri ri-file-text-line icon-18px"></i>
            </span>
            <div class="form-floating form-floating-outline">
              <textarea class="form-control dt-description" id="basicDescription" name="basicDescription"
                        placeholder="Description" aria-label="Description" aria-describedby="basicDescription2" rows="3"></textarea>
              <label for="basicDescription">Description</label>
            </div>
          </div>
        </div>

        <div class="col-sm-12">
          <button type="submit" id="submitBtn" class="btn btn-primary data-submit me-sm-4 me-1">Submit</button>
          <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="offcanvas">Cancel</button>
        </div>
      </form>
    </div>
  </div>

@endsection

@section('page-script')
  <script>
    'use strict';

    let fv, offCanvasEl;
    document.addEventListener('DOMContentLoaded', function (e) {
      (function () {
        const formAddNewRecord = document.getElementById('categoryForm');
        var form = document.getElementById('categoryForm');

        form.addEventListener('submit', function(e) {
          e.preventDefault();
        });

        setTimeout(() => {
          const newRecord = document.querySelector('.create-new-form-btn'),
            offCanvasElement = document.querySelector('#add-new-record');

          if (newRecord) {
            newRecord.addEventListener('click', function () {
              offCanvasEl = new bootstrap.Offcanvas(offCanvasElement);
              document.getElementById('formTitle').textContent = 'New Category';
              document.getElementById('categoryId').value = '';
              formAddNewRecord.reset();
              offCanvasEl.show();
            });
          }
        }, 200);

        fv = FormValidation.formValidation(formAddNewRecord, {
          fields: {
            basicCategoryName: {
              validators: {
                notEmpty: {
                  message: 'Category name is required'
                }
              }
            }
          },
          plugins: {
            trigger: new FormValidation.plugins.Trigger(),
            bootstrap5: new FormValidation.plugins.Bootstrap5({
              eleValidClass: '',
              rowSelector: '.form-control-validation'
            }),
            submitButton: new FormValidation.plugins.SubmitButton(),
            autoFocus: new FormValidation.plugins.AutoFocus()
          },
          init: instance => {
            instance.on('plugins.message.placed', function (e) {
              if (e.element.parentElement.classList.contains('input-group')) {
                e.element.parentElement.insertAdjacentElement('afterend', e.messageElement);
              }
            });
          }
        });
      })();

      const dt_basic_table = document.querySelector('.datatables-basic');
      let dt_basic;

      if (dt_basic_table) {
        let tableTitle = document.createElement('h5');
        tableTitle.classList.add('card-title', 'mb-0', 'text-md-start', 'text-center');
        tableTitle.innerHTML = 'Categories';

        dt_basic = new DataTable(dt_basic_table, {
          columns: [
            { data: 'id' },
            { data: 'id', orderable: false, render: DataTable.render.select() },
            { data: 'id' },
            { data: 'name' },
            { data: 'description' },
            { data: 'id' }
          ],
          columnDefs: [
            {
              className: 'control',
              orderable: false,
              searchable: false,
              responsivePriority: 2,
              targets: 0,
              render: function (data, type, full, meta) {
                return '';
              }
            },
            {
              targets: 1,
              orderable: false,
              searchable: false,
              responsivePriority: 3,
              checkboxes: true,
              render: function () {
                return '<input type="checkbox" class="dt-checkboxes form-check-input">';
              }
            },
            {
              targets: 2,
              searchable: false,
              visible: false
            },
            {
              responsivePriority: 1,
              targets: 3
            },
            {
              targets: -1,
              title: 'Actions',
              orderable: false,
              searchable: false,
              className: 'd-flex align-items-center',
              render: function (data, type, full, meta) {
                return data;
              }
            }
          ],
          select: {
            style: 'multi',
            selector: 'td:nth-child(2)'
          },
          order: [[2, 'desc']],
          layout: {
            top2Start: {
              rowClass: 'row card-header mx-0 px-2',
              features: [tableTitle]
            },
            top2End: {
              features: [
                {
                  buttons: [
                    {
                      extend: 'collection',
                      className: 'btn btn-label-primary dropdown-toggle me-4 waves-effect border-none',
                      text: '<span class="d-flex align-items-center gap-2"><i class="icon-base ri ri-external-link-line icon-18px"></i> <span class="d-none d-sm-inline-block">Export</span></span>',
                      buttons: [
                        {
                          extend: 'print',
                          text: `<span class="d-flex align-items-center"><i class="icon-base ri ri-printer-line me-1"></i>Print</span>`,
                          className: 'dropdown-item',
                          exportOptions: {
                            columns: [3, 4]
                          }
                        },
                        {
                          extend: 'csv',
                          text: `<span class="d-flex align-items-center"><i class="icon-base ri ri-file-text-line me-1"></i>Csv</span>`,
                          className: 'dropdown-item',
                          exportOptions: {
                            columns: [3, 4]
                          }
                        },
                        {
                          extend: 'excel',
                          text: `<span class="d-flex align-items-center"><i class="icon-base ri ri-file-excel-line me-1"></i>Excel</span>`,
                          className: 'dropdown-item',
                          exportOptions: {
                            columns: [3, 4]
                          }
                        },
                        {
                          extend: 'pdf',
                          text: `<span class="d-flex align-items-center"><i class="icon-base ri ri-file-pdf-line me-1"></i>Pdf</span>`,
                          className: 'dropdown-item',
                          exportOptions: {
                            columns: [3, 4]
                          }
                        },
                        {
                          extend: 'copy',
                          text: `<i class="icon-base ri ri-file-copy-line me-1"></i>Copy`,
                          className: 'dropdown-item',
                          exportOptions: {
                            columns: [3, 4]
                          }
                        }
                      ]
                    },
                    {
                      text: '<span class="d-flex align-items-center"><i class="icon-base ri ri-add-line icon-18px me-sm-1"></i><span class="d-none d-sm-inline-block">Add New Record</span></span>',
                      className: 'create-new-form-btn btn btn-primary'
                    }
                  ]
                }
              ]
            },
            topStart: {
              rowClass: 'row m-3 mx-2 my-0 justify-content-between',
              features: [
                {
                  pageLength: {
                    menu: [7, 10, 25, 50, 100],
                    text: 'Show_MENU_entries'
                  }
                }
              ]
            },
            topEnd: {
              search: {
                placeholder: 'Type search here'
              }
            },
            bottomStart: {
              rowClass: 'row mx-3 justify-content-between',
              features: ['info']
            },
            bottomEnd: 'paging'
          },
          displayLength: 7,
          language: {
            paginate: {
              next: '<i class="icon-base ri ri-arrow-right-s-line scaleX-n1-rtl icon-22px"></i>',
              previous: '<i class="icon-base ri ri-arrow-left-s-line scaleX-n1-rtl icon-22px"></i>',
              first: '<i class="icon-base ri ri-skip-back-mini-line scaleX-n1-rtl icon-22px"></i>',
              last: '<i class="icon-base ri ri-skip-forward-mini-line scaleX-n1-rtl icon-22px"></i>'
            }
          },
          responsive: {
            details: {
              display: DataTable.Responsive.display.modal({
                header: function (row) {
                  const data = row.data();
                  return 'Details of ' + data['name'];
                }
              }),
              type: 'column',
              renderer: function (api, rowIdx, columns) {
                const data = columns
                  .map(function (col) {
                    return col.title !== ''
                      ? `<tr data-dt-row="${col.rowIndex}" data-dt-column="${col.columnIndex}">
                      <td>${col.title}:</td>
                      <td>${col.data}</td>
                    </tr>`
                      : '';
                  })
                  .join('');

                if (data) {
                  const div = document.createElement('div');
                  div.classList.add('table-responsive');
                  const table = document.createElement('table');
                  div.appendChild(table);
                  table.classList.add('table');
                  table.classList.add('datatables-basic');
                  const tbody = document.createElement('tbody');
                  tbody.innerHTML = data;
                  table.appendChild(tbody);
                  return div;
                }
                return false;
              }
            }
          },
          initComplete: function (settings, json) {
            $('.card-header').after('<hr class="my-0">');
          }
        });

        fv.on('core.form.valid', function () {
          let categoryId = document.querySelector('#categoryId').value;
          let new_name = document.querySelector('.add-new-record .dt-category-name').value;
          let new_description = document.querySelector('.add-new-record .dt-description').value;

          const isEditing = categoryId && categoryId.trim() !== '';
          const url = isEditing ? `/api/categories/${categoryId}` : '/api/categories';
          const method = isEditing ? 'PUT' : 'POST';

          fetch(url, {
            method: method,
            headers: {
              'Content-Type': 'application/json',
              'Accept': 'application/json',
              'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            credentials: 'include',
            body: JSON.stringify({
              name: new_name,
              description: new_description
            })
          })
            .then(response => response.json())
            .then(data => {
              if (data.success) {
                location.reload();
              }
            })
            .catch(error => console.error('Error:', error));
          return false;
        });

        document.addEventListener('click', function (e) {
          if (e.target.closest('.item-edit')) {
            const row = e.target.closest('tr');
            const categoryId = row.getAttribute('data-category-id');
            const categoryName = row.querySelector('.category_name')?.textContent.trim() || '';
            const description = row.querySelector('.category_description')?.textContent.trim() || '';

            document.getElementById('formTitle').textContent = 'Edit Category';
            document.getElementById('categoryId').value = categoryId;
            document.querySelector('.dt-category-name').value = categoryName;
            document.querySelector('.dt-description').value = description;
            offCanvasEl = new bootstrap.Offcanvas(document.querySelector('#add-new-record'));
            offCanvasEl.show();
          }
        });

        document.addEventListener('click', function (e) {
          if (e.target.classList.contains('delete-record')) {
            e.preventDefault();
            const row = e.target.closest('tr');
            const categoryId = row.getAttribute('data-category-id');

            if (confirm('Are you sure you want to delete this category?')) {
              fetch(`/api/categories/${categoryId}`, {
                method: 'DELETE',
                headers: {
                  'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
              })
                .then(response => response.json())
                .then(data => {
                  if (data.success) {
                    row.remove();
                  }
                })
                .catch(error => console.error('Error:', error));
            }
          }
        });
      }

      setTimeout(() => {
        const elementsToModify = [
          { selector: '.dt-buttons .btn', classToRemove: 'btn-secondary' },
          { selector: '.dt-layout-table', classToRemove: 'row mt-2' },
          { selector: '.dt-layout-end', classToAdd: 'mt-0', classToRemove: 'ms-auto' },
          { selector: '.dt-layout-end .dt-search', classToAdd: 'mt-md-5 mt-0', classToRemove: 'ms-auto' },
          { selector: '.dt-layout-full', classToRemove: 'col-md col-12', classToAdd: 'table-responsive' }
        ];

        elementsToModify.forEach(({ selector, classToRemove, classToAdd }) => {
          document.querySelectorAll(selector).forEach(element => {
            if (classToRemove) {
              classToRemove.split(' ').forEach(className => element.classList.remove(className));
            }
            if (classToAdd) {
              classToAdd.split(' ').forEach(className => element.classList.add(className));
            }
          });
        });
      }, 100);
    });
  </script>
@endsection
