@extends('layouts/layoutMaster')

@section('title', 'Rental Agreement - Equipment Renting System')

@section('content')
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h5>Rental Agreement #{{ $agreement->agreement_number }}</h5>
        </div>
        <div class="card-body">
          <div class="d-flex justify-content-between mb-4">
            <div>
              <a href="{{ route('agreements.preview', $agreement) }}" class="btn btn-primary">
                <i class="icon-base ri ri-eye-line me-2"></i>Preview Agreement
              </a>
              <a href="{{ route('agreements.download', $agreement) }}" class="btn btn-outline-secondary">
                <i class="icon-base ri ri-download-line me-2"></i>Download PDF
              </a>
            </div>
            <div>
              @php
                $statusColors = [
                    'pending' => 'warning',
                    'signed' => 'info',
                    'equipment_handed_over' => 'success',
                ];
                $color = $statusColors[$agreement->status] ?? 'secondary';
              @endphp
              <span class="badge bg-{{ $color }}">
                {{ ucfirst(str_replace('_', ' ', $agreement->status)) }}
              </span>
            </div>
          </div>

          <div class="row mb-4">
            <div class="col-md-6">
              <h6>Rental Information</h6>
              <p><strong>Rental Date:</strong> {{ $agreement->rental->rental_date->format('Y-m-d H:i') }}</p>
              <p><strong>Expected Return:</strong> {{ $agreement->rental->expected_return_date ? $agreement->rental->expected_return_date->format('Y-m-d H:i') : 'N/A' }}</p>
              <p><strong>Total Amount:</strong> Rs. {{ number_format($agreement->rental->grand_total, 2) }}</p>
            </div>
            <div class="col-md-6">
              <h6>Customer Information</h6>
              <p><strong>Name:</strong> {{ $agreement->rental->customer?->name ?? 'Walk-in Customer' }}</p>
              @if($agreement->rental->customer?->phone)
                <p><strong>Phone:</strong> {{ $agreement->rental->customer->phone }}</p>
              @endif
              @if($agreement->rental->customer?->address)
                <p><strong>Address:</strong> {{ $agreement->rental->customer->address }}</p>
              @endif
            </div>
          </div>

          @if($agreement->status === 'pending')
            <form method="POST" action="{{ route('agreements.mark-signed', $agreement) }}" class="d-inline">
              @csrf
              <button type="submit" class="btn btn-info" onclick="return confirm('Mark this agreement as signed?')">
                <i class="icon-base ri ri-check-line me-2"></i>Mark as Signed
              </button>
            </form>
          @endif

          @if($agreement->status === 'signed')
            <form method="POST" action="{{ route('agreements.mark-handed-over', $agreement) }}" class="d-inline">
              @csrf
              <button type="submit" class="btn btn-success" onclick="return confirm('Mark equipment as handed over?')">
                <i class="icon-base ri ri-checkbox-circle-line me-2"></i>Mark Equipment Handed Over
              </button>
            </form>
          @endif

          @if($agreement->status === 'equipment_handed_over')
            @php
              $invoice = $agreement->rental->invoices()->first();
            @endphp
            @if($invoice)
              <a href="{{ route('invoices.preview', $invoice) }}" class="btn btn-success">
                <i class="icon-base ri ri-file-list-3-line me-2"></i>View Invoice
              </a>
            @else
              <a href="{{ route('invoices.generate', $agreement->rental) }}" class="btn btn-success">
                <i class="icon-base ri ri-file-add-line me-2"></i>Generate Invoice
              </a>
            @endif
          @endif

          <div class="mt-4">
            <a href="{{ route('rentals') }}" class="btn btn-outline-secondary">
              <i class="icon-base ri ri-arrow-left-line me-2"></i>Back to Rentals
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
@endsection





