@extends('layouts/layoutMaster')

@section('title', 'Rental Agreement Preview - Equipment Renting System')

@section('vendor-style')
  @vite('resources/assets/vendor/libs/flatpickr/flatpickr.scss')
@endsection

@section('page-style')
  @vite('resources/assets/vendor/scss/pages/app-invoice.scss')
  <style>
    @media print {
      @page {
        margin: 0.5cm;
      }

      * {
        -webkit-print-color-adjust: exact !important;
        print-color-adjust: exact !important;
      }

      body {
        background: white !important;
      }

      /* Hide layout elements and action buttons */
      .no-print,
      .agreement-actions,
      .layout-navbar,
      .layout-menu,
      .layout-footer,
      .layout-overlay,
      .navbar,
      .footer,
      .content-footer,
      aside,
      .layout-menu-toggle,
      .btn,
      .dropdown,
      .offcanvas {
        display: none !important;
      }

      /* Show agreement content */
      .agreement-preview {
        margin: 0 !important;
        padding: 0 !important;
      }

      .agreement-preview-card {
        border: none !important;
        box-shadow: none !important;
        margin: 0 !important;
        padding: 1rem !important;
        background: white !important;
      }
    }
  </style>
@endsection

@section('vendor-script')
  @vite(['resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js'])
@endsection

@section('page-script')
  <script>
    'use strict';
    document.addEventListener('DOMContentLoaded', function() {
      // Print function
      $('#printBtn').on('click', function() {
        window.print();
      });

      // Download PDF
      $('#downloadBtn').on('click', function() {
        window.location.href = '{{ route('agreements.download', $agreement) }}';
      });

      // Mark as signed
      $('#markSignedBtn').on('click', function() {
        if (confirm('Are you sure you want to mark this agreement as signed?')) {
          window.location.href = '{{ route('agreements.mark-signed', $agreement) }}';
        }
      });

      // Mark equipment handed over
      $('#markHandedOverBtn').on('click', function() {
        if (confirm('Are you sure equipment has been handed over to the customer?')) {
          window.location.href = '{{ route('agreements.mark-handed-over', $agreement) }}';
        }
      });
    });
  </script>
@endsection

@section('content')
  <div class="row agreement-preview">
    <!-- Agreement -->
    <div class="col-xl-9 col-md-8 col-12 mb-md-0 mb-6">
      <div class="card agreement-preview-card p-sm-12 p-6">
        <div class="card-body agreement-preview-header rounded-4 p-6">
          <div
            class="d-flex justify-content-between flex-xl-row flex-md-column flex-sm-row flex-column text-heading align-items-xl-center align-items-md-start align-items-sm-center flex-wrap gap-6">
            <div>
              <div class="d-flex svg-illustration align-items-center gap-2 mb-3">
                <a href="{{url('/')}}" class="app-brand-link gap-2">
                  <img src="{{ asset('assets/img/branding/logo.png') }}" alt="brand-logo"
                       width="200" class="rounded-4" />
                </a>
              </div>
              <p class="mb-1">{{ $agreement->rental->shop->name ?? 'Equipment Renting System' }}</p>
              <p class="mb-1">{{ $agreement->rental->shop->address ?? 'N/A' }}</p>
              <p class="mb-0">{{ $agreement->rental->shop->phone ?? 'N/A' }}</p>
            </div>
            <div>
              <h5 class="mb-6 text-nowrap">Rental Agreement #{{ $agreement->agreement_number }}</h5>
              <div class="mb-1">
                <span>Date Issued:</span>
                <span>{{ $agreement->issued_at->format('F d, Y') }}</span>
              </div>
              @if ($agreement->rental->expected_return_date)
                <div>
                  <span>Expected Return:</span>
                  <span>{{ $agreement->rental->expected_return_date->format('F d, Y') }}</span>
                </div>
              @endif
              @if ($agreement->signed_at)
                <div>
                  <span>Signed Date:</span>
                  <span>{{ $agreement->signed_at->format('F d, Y H:i') }}</span>
                </div>
              @endif
              @if ($agreement->equipment_handed_over_at)
                <div>
                  <span>Equipment Handed Over:</span>
                  <span>{{ $agreement->equipment_handed_over_at->format('F d, Y H:i') }}</span>
                </div>
              @endif
            </div>
          </div>
        </div>
        <div class="card-body py-6 px-0">
          <div class="d-flex justify-content-between flex-wrap gap-6">
            <div>
              <h6>Customer Details:</h6>
              <p class="mb-1"><strong>{{ $agreement->rental->customer?->name ?? 'Walk-in Customer' }}</strong></p>
              @if ($agreement->rental->customer?->address)
                <p class="mb-1">{{ $agreement->rental->customer->address }}</p>
              @endif
              @if ($agreement->rental->customer?->phone)
                <p class="mb-1">{{ $agreement->rental->customer->phone }}</p>
              @endif
              @if ($agreement->rental->customer?->nic_number)
                <p class="mb-0">NIC: {{ $agreement->rental->customer->nic_number }}</p>
              @endif
            </div>
            <div>
              <h6>Rental Information:</h6>
              <table>
                <tbody>
                  <tr>
                    <td class="pe-4">Status:</td>
                    <td>
                      @php
                        $statusColors = [
                            'pending' => 'warning',
                            'signed' => 'info',
                            'equipment_handed_over' => 'success',
                        ];
                        $color = $statusColors[$agreement->status] ?? 'secondary';
                      @endphp
                      <span class="badge bg-{{ $color }}">
                        {{ ucfirst(str_replace('_', ' ', $agreement->status)) }}
                      </span>
                    </td>
                  </tr>
                  <tr>
                    <td class="pe-4">Rental Date:</td>
                    <td>{{ $agreement->rental->rental_date->format('M d, Y H:i') }}</td>
                  </tr>
                  <tr>
                    <td class="pe-4">Total Amount:</td>
                    <td>Rs. {{ number_format($agreement->rental->grand_total, 2) }}</td>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>
        </div>
        
        <div class="card-body py-6 px-0">
          <h6 class="mb-4">Rental Agreement Terms & Conditions</h6>
          <p class="mb-3">
            This Rental Agreement ("Agreement") is entered into on <strong>{{ $agreement->issued_at->format('F d, Y') }}</strong> between 
            <strong>{{ $agreement->rental->shop->name ?? 'Equipment Renting System' }}</strong> ("Lessor") and 
            <strong>{{ $agreement->rental->customer?->name ?? 'Walk-in Customer' }}</strong> ("Lessee").
          </p>
          
          <h6 class="mt-4 mb-3">1. Equipment Details</h6>
          <div class="table-responsive border rounded-4 border-bottom-0">
            <table class="table m-0">
              <thead>
                <tr>
                  <th>Item</th>
                  <th>Rate/Day</th>
                  <th>Qty</th>
                  <th>Days</th>
                  <th>Subtotal</th>
                </tr>
              </thead>
              <tbody>
                @foreach ($agreement->rental->rentalItems as $item)
                  <tr>
                    <td class="text-nowrap text-heading">{{ $item->equipment->name }}</td>
                    <td>Rs. {{ number_format($item->daily_rate, 2) }}</td>
                    <td>{{ $item->quantity }}</td>
                    <td>{{ number_format($item->days, 2) }}</td>
                    <td>Rs. {{ number_format($item->subtotal, 2) }}</td>
                  </tr>
                @endforeach
              </tbody>
            </table>
          </div>
          
          <div class="table-responsive">
            <table class="table m-0 table-borderless">
              <tbody>
                <tr>
                  <td class="align-top px-0 py-6">
                    @if ($agreement->rental->remarks)
                      <p class="mb-1">
                        <span class="me-2 fw-medium text-heading">Remarks:</span>
                        <span>{{ $agreement->rental->remarks }}</span>
                      </p>
                    @endif
                  </td>
                  <td class="pe-0 py-6 w-px-100">
                    <p class="mb-1">Subtotal:</p>
                    @if ($agreement->rental->discount > 0)
                      <p class="mb-1">Discount:</p>
                    @endif
                    <p class="mb-1 border-bottom pb-2">Total:</p>
                  </td>
                  <td class="text-end px-0 py-6 w-px-100">
                    <p class="fw-medium mb-1">Rs. {{ number_format($agreement->rental->total_amount, 2) }}</p>
                    @if ($agreement->rental->discount > 0)
                      <p class="fw-medium mb-1">Rs. {{ number_format($agreement->rental->discount, 2) }}</p>
                    @endif
                    <p class="fw-medium mb-0 pt-2 border-top">Rs. {{ number_format($agreement->rental->grand_total, 2) }}</p>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>

          <h6 class="mt-4 mb-3">2. Terms and Conditions</h6>
          <ol class="mb-4">
            <li class="mb-2">The Lessee agrees to return all equipment in the same condition as received, normal wear and tear excepted.</li>
            <li class="mb-2">The Lessee is responsible for any damage or loss of equipment during the rental period.</li>
            <li class="mb-2">Equipment must be returned by <strong>{{ $agreement->rental->expected_return_date ? $agreement->rental->expected_return_date->format('F d, Y H:i') : 'the agreed return date' }}</strong>.</li>
            <li class="mb-2">Late returns may incur additional charges.</li>
            <li class="mb-2">The Lessee agrees to pay the total rental amount as specified in this agreement.</li>
          </ol>

          <div class="mt-6 pt-6 border-top">
            <div class="row">
              <div class="col-md-6">
                <h6 class="mb-3">Lessor Signature</h6>
                <p class="mb-1">{{ $agreement->rental->rentedBy->name ?? 'N/A' }}</p>
                <p class="text-muted small">Authorized Representative</p>
                <div class="mt-4" style="border-top: 1px solid #ddd; padding-top: 10px;">
                  <p class="text-muted small">Signature: _____________________</p>
                  <p class="text-muted small">Date: _____________________</p>
                </div>
              </div>
              <div class="col-md-6">
                <h6 class="mb-3">Lessee Signature</h6>
                <p class="mb-1">{{ $agreement->rental->customer?->name ?? 'Walk-in Customer' }}</p>
                <p class="text-muted small">Customer</p>
                <div class="mt-4" style="border-top: 1px solid #ddd; padding-top: 10px;">
                  <p class="text-muted small">Signature: _____________________</p>
                  <p class="text-muted small">Date: _____________________</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- /Agreement -->

    <!-- Agreement Actions -->
    <div class="col-xl-3 col-md-4 col-12 agreement-actions no-print">
      <div class="card">
        <div class="card-body">
          <button type="button" id="printBtn" class="btn btn-primary d-grid w-100 mb-4">
            <span class="d-flex align-items-center justify-content-center text-nowrap">
              <i class="icon-base ri ri-printer-line icon-16px scaleX-n1-rtl me-2"></i>Print Agreement</span>
          </button>
          <button type="button" id="downloadBtn" class="btn btn-outline-secondary d-grid w-100 mb-4">
            <span class="d-flex align-items-center justify-content-center text-nowrap">
              <i class="icon-base ri ri-download-line icon-16px scaleX-n1-rtl me-2"></i>Download PDF</span>
          </button>
          <div class="d-flex mb-4">
            <a href="{{ route('rentals') }}" class="btn btn-outline-secondary d-grid w-100 me-4">
              <span class="d-flex align-items-center justify-content-center text-nowrap">
                <i class="icon-base ri ri-arrow-left-line icon-16px scaleX-n1-rtl me-2"></i>Back to Rentals</span>
            </a>
          </div>
          
          @if ($agreement->status === 'pending')
            <button type="button" id="markSignedBtn" class="btn btn-info d-grid w-100 mb-4">
              <span class="d-flex align-items-center justify-content-center text-nowrap">
                <i class="icon-base ri ri-check-line icon-16px scaleX-n1-rtl me-2"></i>Mark as Signed</span>
            </button>
          @endif
          
          @if ($agreement->status === 'signed')
            <button type="button" id="markHandedOverBtn" class="btn btn-success d-grid w-100 mb-4">
              <span class="d-flex align-items-center justify-content-center text-nowrap">
                <i class="icon-base ri ri-checkbox-circle-line icon-16px scaleX-n1-rtl me-2"></i>Mark Equipment Handed Over</span>
            </button>
          @endif
          
          @if ($agreement->status === 'equipment_handed_over')
            @php
              $invoice = $agreement->rental->invoices()->first();
            @endphp
            @if ($invoice)
              <a href="{{ route('invoices.preview', $invoice) }}" class="btn btn-success d-grid w-100 mb-4">
                <span class="d-flex align-items-center justify-content-center text-nowrap">
                  <i class="icon-base ri ri-file-list-3-line icon-16px scaleX-n1-rtl me-2"></i>View Invoice</span>
              </a>
            @else
              <a href="{{ route('invoices.generate', $agreement->rental) }}" class="btn btn-success d-grid w-100 mb-4">
                <span class="d-flex align-items-center justify-content-center text-nowrap">
                  <i class="icon-base ri ri-file-add-line icon-16px scaleX-n1-rtl me-2"></i>Generate Invoice</span>
              </a>
            @endif
          @endif

          {{-- Show invoice option when equipment is returned --}}
          @if ($agreement->rental->status === 'returned')
            @php
              $invoice = $agreement->rental->invoices()->first();
            @endphp
            @if ($invoice)
              <a href="{{ route('invoices.preview', $invoice) }}" class="btn btn-primary d-grid w-100 mb-4">
                <span class="d-flex align-items-center justify-content-center text-nowrap">
                  <i class="icon-base ri ri-file-list-3-line icon-16px scaleX-n1-rtl me-2"></i>View Invoice</span>
              </a>
            @else
              <a href="{{ route('invoices.generate', $agreement->rental) }}" class="btn btn-primary d-grid w-100 mb-4">
                <span class="d-flex align-items-center justify-content-center text-nowrap">
                  <i class="icon-base ri ri-file-add-line icon-16px scaleX-n1-rtl me-2"></i>Generate Invoice</span>
              </a>
            @endif
          @endif
        </div>
      </div>
    </div>
    <!-- /Agreement Actions -->
  </div>
@endsection
