<!-- BEGIN: Vendor JS-->

@vite(['resources/assets/vendor/libs/jquery/jquery.js', 'resources/assets/vendor/libs/popper/popper.js', 'resources/assets/vendor/js/bootstrap.js', 'resources/assets/vendor/libs/node-waves/node-waves.js', 'resources/assets/vendor/libs/@algolia/autocomplete-js.js'])

@if ($configData['hasCustomizer'])
  @vite('resources/assets/vendor/libs/pickr/pickr.js')
@endif

@vite(['resources/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js', 'resources/assets/vendor/libs/hammer/hammer.js', 'resources/assets/vendor/js/menu.js'])

@yield('vendor-script')
<!-- END: Page Vendor JS-->

<!-- BEGIN: Theme JS-->
@vite(['resources/assets/js/main.js'])
<!-- END: Theme JS-->

<!-- Pricing Modal JS-->
@stack('pricing-script')
<!-- END: Pricing Modal JS-->

<!-- BEGIN: Page JS-->
@yield('page-script')

<script>
  // Keep parent menu expanded when child is active
  document.addEventListener('DOMContentLoaded', function() {
    // Find all active menu items (including nested ones)
    const activeMenuItems = document.querySelectorAll('.menu-item.active');
    
    activeMenuItems.forEach(function(activeMenuItem) {
      // Find parent menu item with submenu
      let parent = activeMenuItem.closest('.menu-sub')?.parentElement?.closest('.menu-item');
      while (parent) {
        if (parent.classList.contains('menu-item') && parent.querySelector('.menu-sub')) {
          parent.classList.add('open');
          // Also ensure the menu-toggle link is properly set
          const menuToggle = parent.querySelector('.menu-toggle');
          if (menuToggle) {
            menuToggle.setAttribute('aria-expanded', 'true');
          }
        }
        parent = parent.parentElement?.closest('.menu-item');
      }
    });

    // Handle menu toggle clicks - don't collapse if child is active
    document.querySelectorAll('.menu-toggle').forEach(function(toggle) {
      toggle.addEventListener('click', function(e) {
        const menuItem = this.closest('.menu-item');
        if (menuItem && menuItem.classList.contains('open')) {
          // Check if any child is active
          const hasActiveChild = menuItem.querySelector('.menu-sub .menu-item.active');
          if (hasActiveChild) {
            // Don't collapse if child is active - just prevent default and let the menu system handle it
            // The menu.js will handle the toggle, but we want to keep it open if child is active
            setTimeout(function() {
              if (hasActiveChild && !menuItem.classList.contains('open')) {
                menuItem.classList.add('open');
                toggle.setAttribute('aria-expanded', 'true');
              }
            }, 100);
          }
        }
      });
    });
  });
</script>
<!-- END: Page JS-->

<!-- app JS -->
@vite(['resources/js/app.js'])
<!-- END: app JS-->
