@php
  use Illuminate\Support\Facades\Route;
@endphp

<ul class="menu-sub">
  @if (isset($menu))
    @foreach ($menu as $submenu)
      {{-- active menu method --}}
      @php
        $activeClass = null;
        $active = $configData['layout'] === 'vertical' ? 'active open' : 'active';
        $currentRouteName = Route::currentRouteName();
        $currentUrl = request()->path();

        // Check by route name (exact match)
        if (isset($submenu->slug) && $currentRouteName === $submenu->slug) {
            $activeClass = 'active';
        }
        // Also check by URL path
        elseif (isset($submenu->url)) {
            $submenuUrl = ltrim(parse_url($submenu->url, PHP_URL_PATH), '/');
            // Remove leading slash from current URL for comparison
            $cleanCurrentUrl = ltrim($currentUrl, '/');
            $cleanSubmenuUrl = ltrim($submenuUrl, '/');
            
            // Only match if exact or if current URL starts with submenu URL followed by a slash
            if ($cleanCurrentUrl === $cleanSubmenuUrl || 
                ($cleanSubmenuUrl !== '' && str_starts_with($cleanCurrentUrl, $cleanSubmenuUrl) && 
                 (strlen($cleanCurrentUrl) === strlen($cleanSubmenuUrl) || $cleanCurrentUrl[strlen($cleanSubmenuUrl)] === '/'))) {
                $activeClass = 'active';
            }
        }
        // Check nested submenu
        elseif (isset($submenu->submenu)) {
            if (gettype($submenu->slug) === 'array') {
                foreach ($submenu->slug as $slug) {
                    if ($currentRouteName === $slug || (str_starts_with($currentRouteName, $slug) && strlen($currentRouteName) > strlen($slug) && $currentRouteName[strlen($slug)] === '-')) {
                        $activeClass = $active;
                    }
                }
            } else {
                if (
                    isset($submenu->slug) &&
                    ($currentRouteName === $submenu->slug || (str_starts_with($currentRouteName, $submenu->slug) && strlen($currentRouteName) > strlen($submenu->slug) && $currentRouteName[strlen($submenu->slug)] === '-'))
                ) {
                    $activeClass = $active;
                }
            }
        }
      @endphp

      <li class="menu-item {{ $activeClass }}">
        <a href="{{ isset($submenu->url) ? url($submenu->url) : 'javascript:void(0)' }}"
          class="{{ isset($submenu->submenu) ? 'menu-link menu-toggle' : 'menu-link' }}"
          @if (isset($submenu->target) and !empty($submenu->target)) target="_blank" @endif>
          @if (isset($submenu->icon))
            <i class="{{ $submenu->icon }}"></i>
          @endif
          <div>{{ isset($submenu->name) ? __($submenu->name) : '' }}</div>
          @isset($submenu->badge)
            <div class="badge bg-{{ $submenu->badge[0] }} rounded-pill ms-auto">{{ $submenu->badge[1] }}</div>
          @endisset
        </a>

        {{-- submenu --}}
        @if (isset($submenu->submenu))
          @include('layouts.sections.menu.submenu', ['menu' => $submenu->submenu])
        @endif
      </li>
    @endforeach
  @endif
</ul>
