<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <title>Invoice Receipt #{{ $invoice->invoice_number }}</title>
  <style>
    @media print {
      @page {
        size: 80mm auto;
        margin: 0;
      }
      body {
        margin: 0;
        padding: 5mm;
      }
    }
    
    body {
      font-family: 'Courier New', monospace;
      font-size: 11px;
      width: 80mm;
      margin: 0 auto;
      padding: 5mm;
      color: #000;
      background: #fff;
    }

    .receipt-header {
      text-align: center;
      border-bottom: 1px dashed #000;
      padding-bottom: 8px;
      margin-bottom: 8px;
    }

    .receipt-header h1 {
      font-size: 16px;
      margin: 0;
      font-weight: bold;
      text-transform: uppercase;
    }

    .receipt-header h2 {
      font-size: 12px;
      margin: 2px 0;
      font-weight: normal;
    }

    .receipt-info {
      margin-bottom: 8px;
      font-size: 10px;
    }

    .receipt-info .label {
      font-weight: bold;
    }

    .receipt-info div {
      margin: 2px 0;
    }

    .divider {
      border-top: 1px dashed #000;
      margin: 6px 0;
    }

    .items-table {
      width: 100%;
      border-collapse: collapse;
      margin: 6px 0;
      font-size: 10px;
    }

    .items-table td {
      padding: 2px 0;
      border-bottom: 1px dotted #ccc;
    }

    .items-table .item-name {
      font-weight: bold;
    }

    .items-table .item-details {
      font-size: 9px;
      padding-left: 10px;
      color: #555;
    }

    .items-table .item-total {
      text-align: right;
      font-weight: bold;
    }

    .total-section {
      margin-top: 8px;
      border-top: 1px dashed #000;
      padding-top: 6px;
    }

    .total-row {
      display: flex;
      justify-content: space-between;
      margin: 3px 0;
      font-size: 11px;
    }

    .total-row.grand-total {
      font-weight: bold;
      font-size: 13px;
      border-top: 1px solid #000;
      padding-top: 4px;
      margin-top: 4px;
    }

    .footer {
      margin-top: 10px;
      text-align: center;
      font-size: 9px;
      border-top: 1px dashed #000;
      padding-top: 6px;
    }

    .overdue-notice {
      background: #000;
      color: #fff;
      padding: 4px;
      text-align: center;
      font-weight: bold;
      margin: 6px 0;
      font-size: 10px;
    }

    .text-center {
      text-align: center;
    }

    .text-right {
      text-align: right;
    }

    .separator {
      margin: 4px 0;
      border-top: 1px dashed #000;
    }
  </style>
  <script>
    window.onload = function() {
      // Auto-print when page loads (for thermal printers)
      setTimeout(function() {
        window.print();
      }, 250);
    };
  </script>
</head>
<body>
  <div class="receipt-header">
    <h1>{{ $invoice->rental->shop->name ?? 'Equipment Rental' }}</h1>
    <h2>{{ $invoice->rental->shop->address ?? '' }}</h2>
    <div style="font-size: 9px;">Tel: {{ $invoice->rental->shop->phone ?? 'N/A' }}</div>
  </div>

  <div class="receipt-info">
    <div class="text-center" style="font-weight: bold; font-size: 12px; margin-bottom: 4px;">
      INVOICE #{{ $invoice->invoice_number }}
    </div>
    <div class="divider"></div>
    <div><span class="label">Date:</span> {{ $invoice->issued_at->format('Y-m-d H:i') }}</div>
    @if($invoice->due_date)
    <div><span class="label">Due:</span> {{ $invoice->due_date->format('Y-m-d') }}
      @if($invoice->isOverdue())
        <span style="color: #000; font-weight: bold;"> (OVERDUE)</span>
      @endif
    </div>
    @endif
    <div><span class="label">Job #:</span> {{ $invoice->rental->id }}</div>
  </div>

  @if($invoice->isOverdue())
  <div class="overdue-notice">
    ⚠ OVERDUE INVOICE
  </div>
  @endif

  <div class="divider"></div>

  <div class="receipt-info">
    <div><span class="label">Customer:</span></div>
    <div style="margin-left: 5px;">{{ $invoice->rental->customer?->name ?? 'Walk-in Customer' }}</div>
    @if($invoice->rental->customer?->phone)
    <div style="margin-left: 5px; font-size: 9px;">{{ $invoice->rental->customer->phone }}</div>
    @endif
    @if($invoice->rental->customer?->nic_number)
    <div style="margin-left: 5px; font-size: 9px;">NIC: {{ $invoice->rental->customer->nic_number }}</div>
    @endif
  </div>

  <div class="divider"></div>

  <table class="items-table">
    <thead>
      <tr style="border-bottom: 1px solid #000;">
        <td style="font-weight: bold;">Item</td>
        <td class="text-right" style="font-weight: bold;">Amount</td>
      </tr>
    </thead>
    <tbody>
      @foreach ($invoice->rental->rentalItems as $item)
        <tr>
          <td>
            <div class="item-name">{{ $item->equipment->name }}</div>
            <div class="item-details">
              Qty: {{ $item->quantity }} × {{ number_format($item->days, 1) }}d @ {{ number_format($item->daily_rate, 2) }}/d
            </div>
          </td>
          <td class="item-total">{{ number_format($item->subtotal, 2) }}</td>
        </tr>
      @endforeach
    </tbody>
  </table>

  <div class="divider"></div>

  <div class="total-section">
    <div class="total-row">
      <span>Subtotal:</span>
      <span>{{ number_format($invoice->rental->total_amount, 2) }}</span>
    </div>
    @if ($invoice->rental->discount > 0)
    <div class="total-row">
      <span>Discount:</span>
      <span>-{{ number_format($invoice->rental->discount, 2) }}</span>
    </div>
    @endif
    <div class="total-row grand-total">
      <span>TOTAL:</span>
      <span>{{ number_format($invoice->rental->grand_total, 2) }} LKR</span>
    </div>
  </div>

  @if($invoice->payments->count() > 0)
  <div class="separator"></div>
  <div style="font-size: 10px; margin-top: 6px;">
    <div style="font-weight: bold; margin-bottom: 3px;">Payments:</div>
    @foreach($invoice->payments as $payment)
    <div style="display: flex; justify-content: space-between; font-size: 9px;">
      <span>{{ $payment->paid_at->format('Y-m-d') }} ({{ ucfirst($payment->method) }})</span>
      <span>{{ number_format($payment->amount, 2) }}</span>
    </div>
    @endforeach
    <div class="divider"></div>
    <div style="display: flex; justify-content: space-between; font-weight: bold; margin-top: 3px;">
      <span>Paid:</span>
      <span>{{ number_format($invoice->paid_amount, 2) }}</span>
    </div>
    <div style="display: flex; justify-content: space-between; font-weight: bold;">
      <span>Balance:</span>
      <span>{{ number_format($invoice->remaining_amount, 2) }}</span>
    </div>
  </div>
  @endif

  @if ($invoice->rental->remarks)
  <div class="separator"></div>
  <div style="font-size: 9px; margin-top: 6px;">
    <div style="font-weight: bold;">Note:</div>
    <div style="margin-top: 2px;">{{ $invoice->rental->remarks }}</div>
  </div>
  @endif

  <div class="footer">
    <div>Thank you for your business!</div>
    <div style="margin-top: 4px;">{{ now()->format('Y-m-d H:i:s') }}</div>
  </div>
</body>
</html>
