<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <title>Invoice #{{ $invoice->invoice_number }}</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      font-size: 12px;
      color: #333;
    }

    .header {
      text-align: center;
      margin-bottom: 30px;
      border-bottom: 2px solid #333;
      padding-bottom: 20px;
    }

    .invoice-info {
      margin-bottom: 20px;
    }

    .invoice-info table {
      width: 100%;
    }

    .invoice-info td {
      padding: 5px;
    }

    .items-table {
      width: 100%;
      border-collapse: collapse;
      margin: 20px 0;
    }

    .items-table th,
    .items-table td {
      border: 1px solid #ddd;
      padding: 8px;
      text-align: left;
    }

    .items-table th {
      background-color: #f2f2f2;
      font-weight: bold;
    }

    .text-right {
      text-align: right;
    }

    .total-section {
      margin-top: 20px;
      float: right;
      width: 300px;
    }

    .total-row {
      display: flex;
      justify-content: space-between;
      padding: 5px 0;
    }

    .total-row.grand-total {
      font-weight: bold;
      font-size: 14px;
      border-top: 2px solid #333;
      padding-top: 10px;
      margin-top: 10px;
    }

    .footer {
      margin-top: 50px;
      text-align: center;
      font-size: 10px;
      color: #666;
    }
  </style>
</head>

<body>
  <div class="header">
    <h1>INVOICE</h1>
    <h2>{{ $invoice->invoice_number }}</h2>
    @if($invoice->isOverdue())
    <div style="margin-top: 20px; padding: 15px; background-color: #ffebee; border: 2px solid #dc3545; border-radius: 5px;">
      <h3 style="color: #dc3545; margin: 0; font-size: 18px;">⚠ OVERDUE INVOICE</h3>
      <p style="color: #721c24; margin: 5px 0 0 0;">This invoice is past its due date of {{ $invoice->due_date->format('Y-m-d') }}</p>
    </div>
    @endif
  </div>

  <div class="invoice-info">
    <table>
      <tr>
        <td style="width: 50%;">
          <strong>Bill From:</strong><br>
          {{ $invoice->rental->shop->name }}<br>
          {{ $invoice->rental->shop->address }}<br>
          Phone: {{ $invoice->rental->shop->phone }}
        </td>
        <td style="width: 50%;">
          <strong>Bill To:</strong><br>
          {{ $invoice->rental->customer?->name ?? 'N/A' }}<br>
          {{ $invoice->rental->customer?->address ?? 'N/A' }}<br>
          Phone: {{ $invoice->rental->customer?->phone ?? 'N/A' }}<br>
          @if ($invoice->rental->customer?->nic_number)
            NIC: {{ $invoice->rental->customer->nic_number }}
          @endif
        </td>
      </tr>
      <tr>
        <td>
          <strong>Invoice Date:</strong> {{ $invoice->issued_at->format('Y-m-d') }}<br>
          <strong>Rental Date:</strong> {{ $invoice->rental->rental_date->format('Y-m-d H:i') }}
        </td>
        <td>
          @if ($invoice->due_date)
            <strong>Due Date:</strong> {{ $invoice->due_date->format('Y-m-d') }}
            @if($invoice->isOverdue())
              <span style="color: #dc3545; font-weight: bold;"> (OVERDUE)</span>
            @endif
            <br>
          @elseif ($invoice->rental->expected_return_date)
            <strong>Expected Return:</strong> {{ $invoice->rental->expected_return_date->format('Y-m-d H:i') }}<br>
          @endif
          @if ($invoice->rental->actual_return_date)
            <strong>Actual Return:</strong> {{ $invoice->rental->actual_return_date->format('Y-m-d H:i') }}
          @endif
        </td>
      </tr>
    </table>
  </div>

  <table class="items-table">
    <thead>
      <tr>
        <th>#</th>
        <th>Equipment</th>
        <th>Quantity</th>
          <th>Days</th>
          <th>Rate/Day</th>
          <th class="text-right">Subtotal</th>
      </tr>
    </thead>
    <tbody>
      @foreach ($invoice->rental->rentalItems as $index => $item)
        <tr>
          <td>{{ $index + 1 }}</td>
          <td>{{ $item->equipment->name }}</td>
          <td>{{ $item->quantity }}</td>
          <td>{{ number_format($item->days, 2) }}</td>
          <td>{{ number_format($item->daily_rate, 2) }}</td>
          <td class="text-right">{{ number_format($item->subtotal, 2) }}</td>
        </tr>
      @endforeach
    </tbody>
  </table>

  <div class="total-section">
    <div class="total-row">
      <span>Subtotal:</span>
      <span>{{ number_format($invoice->rental->total_amount, 2) }}</span>
    </div>
    @if ($invoice->rental->discount > 0)
      <div class="total-row">
        <span>Discount:</span>
        <span>-{{ number_format($invoice->rental->discount, 2) }}</span>
      </div>
    @endif
    <div class="total-row grand-total">
      <span>Total:</span>
      <span>{{ number_format($invoice->rental->grand_total, 2) }}</span>
    </div>
  </div>

  @if ($invoice->rental->remarks)
    <div style="margin-top: 30px;">
      <strong>Remarks:</strong><br>
      {{ $invoice->rental->remarks }}
    </div>
  @endif

  <div class="footer">
    <p>Thank you for your business!</p>
    <p>Generated on {{ now()->format('Y-m-d H:i:s') }}</p>
  </div>
</body>

</html>
