<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <title>Rental Agreement #{{ $agreement->agreement_number }}</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      font-size: 12px;
      color: #333;
    }

    .header {
      text-align: center;
      margin-bottom: 30px;
      border-bottom: 2px solid #333;
      padding-bottom: 20px;
    }

    .agreement-info {
      margin-bottom: 20px;
    }

    .agreement-info table {
      width: 100%;
    }

    .agreement-info td {
      padding: 5px;
    }

    .items-table {
      width: 100%;
      border-collapse: collapse;
      margin: 20px 0;
    }

    .items-table th,
    .items-table td {
      border: 1px solid #ddd;
      padding: 8px;
      text-align: left;
    }

    .items-table th {
      background-color: #f2f2f2;
      font-weight: bold;
    }

    .text-right {
      text-align: right;
    }

    .total-section {
      margin-top: 20px;
      float: right;
      width: 300px;
    }

    .total-row {
      display: flex;
      justify-content: space-between;
      padding: 5px 0;
    }

    .total-row.grand-total {
      font-weight: bold;
      font-size: 14px;
      border-top: 2px solid #333;
      padding-top: 10px;
      margin-top: 10px;
    }

    .terms-section {
      margin-top: 30px;
      margin-bottom: 30px;
    }

    .terms-section ol {
      margin-left: 20px;
    }

    .terms-section li {
      margin-bottom: 10px;
    }

    .signature-section {
      margin-top: 50px;
      display: table;
      width: 100%;
    }

    .signature-box {
      display: table-cell;
      width: 50%;
      vertical-align: top;
      padding: 20px;
    }

    .signature-line {
      border-top: 1px solid #333;
      margin-top: 50px;
      padding-top: 5px;
    }

    .footer {
      margin-top: 50px;
      text-align: center;
      font-size: 10px;
      color: #666;
    }
  </style>
</head>

<body>
  <div class="header">
    <h1>RENTAL AGREEMENT</h1>
    <h2>{{ $agreement->agreement_number }}</h2>
  </div>

  <div class="agreement-info">
    <table>
      <tr>
        <td style="width: 50%;">
          <strong>Lessor (Equipment Owner):</strong><br>
          {{ $agreement->rental->shop->name }}<br>
          {{ $agreement->rental->shop->address }}<br>
          Phone: {{ $agreement->rental->shop->phone }}
        </td>
        <td style="width: 50%;">
          <strong>Lessee (Customer):</strong><br>
          {{ $agreement->rental->customer?->name ?? 'Walk-in Customer' }}<br>
          {{ $agreement->rental->customer?->address ?? 'N/A' }}<br>
          Phone: {{ $agreement->rental->customer?->phone ?? 'N/A' }}<br>
          @if ($agreement->rental->customer?->nic_number)
            NIC: {{ $agreement->rental->customer->nic_number }}
          @endif
        </td>
      </tr>
      <tr>
        <td>
          <strong>Agreement Date:</strong> {{ $agreement->issued_at->format('Y-m-d') }}<br>
          <strong>Rental Date:</strong> {{ $agreement->rental->rental_date->format('Y-m-d H:i') }}
        </td>
        <td>
          @if ($agreement->rental->expected_return_date)
            <strong>Expected Return:</strong> {{ $agreement->rental->expected_return_date->format('Y-m-d H:i') }}<br>
          @endif
          @if ($agreement->signed_at)
            <strong>Signed Date:</strong> {{ $agreement->signed_at->format('Y-m-d H:i') }}<br>
          @endif
          @if ($agreement->equipment_handed_over_at)
            <strong>Equipment Handed Over:</strong> {{ $agreement->equipment_handed_over_at->format('Y-m-d H:i') }}
          @endif
        </td>
      </tr>
    </table>
  </div>

  <div>
    <h3>1. Equipment Details</h3>
    <table class="items-table">
      <thead>
        <tr>
          <th>#</th>
          <th>Equipment</th>
          <th>Quantity</th>
          <th>Days</th>
          <th>Rate/Day</th>
          <th class="text-right">Subtotal</th>
        </tr>
      </thead>
      <tbody>
        @foreach ($agreement->rental->rentalItems as $index => $item)
          <tr>
            <td>{{ $index + 1 }}</td>
            <td>{{ $item->equipment->name }}</td>
            <td>{{ $item->quantity }}</td>
            <td>{{ number_format($item->days, 2) }}</td>
            <td>{{ number_format($item->daily_rate, 2) }}</td>
            <td class="text-right">{{ number_format($item->subtotal, 2) }}</td>
          </tr>
        @endforeach
      </tbody>
    </table>

    <div class="total-section">
      <div class="total-row">
        <span>Subtotal:</span>
        <span>Rs. {{ number_format($agreement->rental->total_amount, 2) }}</span>
      </div>
      @if ($agreement->rental->discount > 0)
        <div class="total-row">
          <span>Discount:</span>
          <span>-Rs. {{ number_format($agreement->rental->discount, 2) }}</span>
        </div>
      @endif
      <div class="total-row grand-total">
        <span>Total:</span>
        <span>Rs. {{ number_format($agreement->rental->grand_total, 2) }}</span>
      </div>
    </div>
  </div>

  <div class="terms-section">
    <h3>2. Terms and Conditions</h3>
    <ol>
      <li>The Lessee agrees to return all equipment in the same condition as received, normal wear and tear excepted.</li>
      <li>The Lessee is responsible for any damage or loss of equipment during the rental period.</li>
      <li>Equipment must be returned by {{ $agreement->rental->expected_return_date ? $agreement->rental->expected_return_date->format('F d, Y H:i') : 'the agreed return date' }}.</li>
      <li>Late returns may incur additional charges as determined by the Lessor.</li>
      <li>The Lessee agrees to pay the total rental amount as specified in this agreement.</li>
      <li>Any disputes arising from this agreement shall be resolved according to local laws.</li>
      <li>The Lessor reserves the right to inspect the equipment upon return.</li>
    </ol>
  </div>

  @if ($agreement->rental->remarks)
    <div style="margin-top: 30px;">
      <strong>Additional Remarks:</strong><br>
      {{ $agreement->rental->remarks }}
    </div>
  @endif

  <div class="signature-section">
    <div class="signature-box">
      <strong>Lessor (Equipment Owner)</strong><br>
      {{ $agreement->rental->shop->name }}<br>
      <br>
      Authorized Representative: {{ $agreement->rental->rentedBy->name ?? 'N/A' }}
      <div class="signature-line">
        <p>Signature: _____________________</p>
        <p>Date: _____________________</p>
      </div>
    </div>
    <div class="signature-box">
      <strong>Lessee (Customer)</strong><br>
      {{ $agreement->rental->customer?->name ?? 'Walk-in Customer' }}
      <div class="signature-line">
        <p>Signature: _____________________</p>
        <p>Date: _____________________</p>
      </div>
    </div>
  </div>

  <div class="footer">
    <p>This agreement is legally binding upon signature of both parties.</p>
    <p>Generated on {{ now()->format('Y-m-d H:i:s') }}</p>
  </div>
</body>

</html>
