<!-- Add Payment Sidebar -->
@if(isset($invoice))
<div class="offcanvas offcanvas-end" id="addPaymentOffcanvas" aria-hidden="true">
  <div class="offcanvas-header border-bottom">
    <h5 class="offcanvas-title">Add Payment</h5>
    <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
  </div>
  <div class="offcanvas-body flex-grow-1">
    @php
      $paidAmount = $invoice->payments()->sum('amount');
      $remainingAmount = $invoice->amount - $paidAmount;
    @endphp
    <div class="d-flex justify-content-between bg-lighter p-2 mb-5">
      <p class="mb-0">Invoice Balance:</p>
      <p class="fw-medium mb-0">Rs. {{ number_format($remainingAmount, 2) }}</p>
    </div>
    <form id="paymentForm">
      @csrf
      <input type="hidden" id="invoice-id" value="{{ $invoice->id }}">
      <div class="input-group input-group-merge mb-5">
        <span class="input-group-text">Rs.</span>
        <div class="form-floating form-floating-outline">
          <input type="number" id="invoiceAmount" name="amount" class="form-control invoice-amount"
            placeholder="100" step="0.01" min="0.01" max="{{ $remainingAmount }}" required />
          <label for="invoiceAmount">Payment Amount</label>
        </div>
      </div>
      <div class="form-floating form-floating-outline mb-5">
        <input id="payment-date" name="paid_at" class="form-control invoice-date" type="text" required />
        <label for="payment-date">Payment Date</label>
      </div>
      <div class="form-floating form-floating-outline mb-5">
        <select class="form-select" id="payment-method" name="method" required>
          <option value="" selected disabled>Select payment method</option>
          <option value="Cash">Cash</option>
          <option value="Bank Transfer">Bank Transfer</option>
          <option value="Debit Card">Debit Card</option>
          <option value="Credit Card">Credit Card</option>
          <option value="Paypal">Paypal</option>
          <option value="Other">Other</option>
        </select>
        <label for="payment-method">Payment Method</label>
      </div>
      <div class="form-floating form-floating-outline mb-5">
        <textarea class="form-control" id="payment-note" name="notes" style="height: 62px;"></textarea>
        <label for="payment-note">Internal Payment Note</label>
      </div>
      <div class="d-flex flex-wrap">
        <button type="submit" class="btn btn-primary me-4">Add Payment</button>
        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="offcanvas">Cancel</button>
      </div>
    </form>
  </div>
</div>
@endif
<!-- /Add Payment Sidebar -->