// node_modules/.pnpm/jquery-idletimer@1.0.0/node_modules/jquery-idletimer/src/idle-timer.js
(function($) {
  $.idleTimer = function(firstParam, elem, uniqueId) {
    var opts;
    if (typeof firstParam === "object") {
      opts = firstParam;
      firstParam = null;
    } else if (typeof firstParam === "number") {
      opts = { timeout: firstParam };
      firstParam = null;
    }
    elem = elem || document;
    uniqueId = uniqueId || "";
    opts = $.extend({
      idle: false,
      // indicates if the user is idle
      timeout: 3e4,
      // the amount of time (ms) before the user is considered idle
      events: "mousemove keydown wheel DOMMouseScroll mousewheel mousedown touchstart touchmove MSPointerDown MSPointerMove"
      // define active events
    }, opts);
    var jqElem = $(elem), obj = jqElem.data("idleTimerObj" + uniqueId) || {}, toggleIdleState = function(e) {
      var obj2 = $.data(elem, "idleTimerObj" + uniqueId) || {};
      obj2.idle = !obj2.idle;
      obj2.olddate = +/* @__PURE__ */ new Date();
      var event = $.Event((obj2.idle ? "idle" : "active") + ".idleTimer" + uniqueId);
      $(elem).trigger(event, [elem, $.extend({}, obj2), e]);
    }, handleEvent = function(e) {
      var obj2 = $.data(elem, "idleTimerObj" + uniqueId) || {};
      if (e.type === "storage" && e.originalEvent.key !== obj2.timerSyncId) {
        return;
      }
      if (obj2.remaining != null) {
        return;
      }
      if (e.type === "mousemove") {
        if (e.pageX === obj2.pageX && e.pageY === obj2.pageY) {
          return;
        }
        if (typeof e.pageX === "undefined" && typeof e.pageY === "undefined") {
          return;
        }
        var elapsed = +/* @__PURE__ */ new Date() - obj2.olddate;
        if (elapsed < 200) {
          return;
        }
      }
      clearTimeout(obj2.tId);
      if (obj2.idle) {
        toggleIdleState(e);
      }
      obj2.lastActive = +/* @__PURE__ */ new Date();
      obj2.pageX = e.pageX;
      obj2.pageY = e.pageY;
      if (e.type !== "storage" && obj2.timerSyncId) {
        if (typeof localStorage !== "undefined") {
          localStorage.setItem(obj2.timerSyncId, obj2.lastActive);
        }
      }
      obj2.tId = setTimeout(toggleIdleState, obj2.timeout);
    }, reset = function() {
      var obj2 = $.data(elem, "idleTimerObj" + uniqueId) || {};
      obj2.idle = obj2.idleBackup;
      obj2.olddate = +/* @__PURE__ */ new Date();
      obj2.lastActive = obj2.olddate;
      obj2.remaining = null;
      clearTimeout(obj2.tId);
      if (!obj2.idle) {
        obj2.tId = setTimeout(toggleIdleState, obj2.timeout);
      }
    }, pause = function() {
      var obj2 = $.data(elem, "idleTimerObj" + uniqueId) || {};
      if (obj2.remaining != null) {
        return;
      }
      obj2.remaining = obj2.timeout - (+/* @__PURE__ */ new Date() - obj2.olddate);
      clearTimeout(obj2.tId);
    }, resume = function() {
      var obj2 = $.data(elem, "idleTimerObj" + uniqueId) || {};
      if (obj2.remaining == null) {
        return;
      }
      if (!obj2.idle) {
        obj2.tId = setTimeout(toggleIdleState, obj2.remaining);
      }
      obj2.remaining = null;
    }, destroy = function() {
      var obj2 = $.data(elem, "idleTimerObj" + uniqueId) || {};
      clearTimeout(obj2.tId);
      jqElem.removeData("idleTimerObj" + uniqueId);
      jqElem.off("._idleTimer" + uniqueId);
    }, remainingtime = function() {
      var obj2 = $.data(elem, "idleTimerObj" + uniqueId) || {};
      if (obj2.idle) {
        return 0;
      }
      if (obj2.remaining != null) {
        return obj2.remaining;
      }
      var remaining = obj2.timeout - (+/* @__PURE__ */ new Date() - obj2.lastActive);
      if (remaining < 0) {
        remaining = 0;
      }
      return remaining;
    };
    if (firstParam === null && typeof obj.idle !== "undefined") {
      reset();
      return jqElem;
    } else if (firstParam === null) {
    } else if (firstParam !== null && typeof obj.idle === "undefined") {
      return false;
    } else if (firstParam === "destroy") {
      destroy();
      return jqElem;
    } else if (firstParam === "pause") {
      pause();
      return jqElem;
    } else if (firstParam === "resume") {
      resume();
      return jqElem;
    } else if (firstParam === "reset") {
      reset();
      return jqElem;
    } else if (firstParam === "getRemainingTime") {
      return remainingtime();
    } else if (firstParam === "getElapsedTime") {
      return +/* @__PURE__ */ new Date() - obj.olddate;
    } else if (firstParam === "getLastActiveTime") {
      return obj.lastActive;
    } else if (firstParam === "isIdle") {
      return obj.idle;
    }
    jqElem.on((opts.events + " ").split(" ").join("._idleTimer" + uniqueId + " ").trim(), function(e) {
      handleEvent(e);
    });
    if (opts.timerSyncId) {
      $(window).on("storage", handleEvent);
    }
    obj = $.extend({}, {
      olddate: +/* @__PURE__ */ new Date(),
      // the last time state changed
      lastActive: +/* @__PURE__ */ new Date(),
      // the last time timer was active
      idle: opts.idle,
      // current state
      idleBackup: opts.idle,
      // backup of idle parameter since it gets modified
      timeout: opts.timeout,
      // the interval to change state
      remaining: null,
      // how long until state changes
      timerSyncId: opts.timerSyncId,
      // localStorage key to use for syncing this timer
      tId: null,
      // the idle timer setTimeout
      pageX: null,
      // used to store the mouse coord
      pageY: null
    });
    if (!obj.idle) {
      obj.tId = setTimeout(toggleIdleState, obj.timeout);
    }
    $.data(elem, "idleTimerObj" + uniqueId, obj);
    return jqElem;
  };
  $.fn.idleTimer = function(firstParam, uniqueId) {
    if (this[0]) {
      return $.idleTimer(firstParam, this[0], uniqueId);
    }
    return this;
  };
})(jQuery);
//# sourceMappingURL=jquery-idletimer_src_idle-timer.js.map
