import {
  __require
} from "./chunk-LK32TJAX.js";

// node_modules/.pnpm/jkanban@1.3.1/node_modules/jkanban/dist/jkanban.js
(/* @__PURE__ */ (function() {
  function r(e, n, t) {
    function o(i2, f) {
      if (!n[i2]) {
        if (!e[i2]) {
          var c = "function" == typeof __require && __require;
          if (!f && c) return c(i2, true);
          if (u) return u(i2, true);
          var a = new Error("Cannot find module '" + i2 + "'");
          throw a.code = "MODULE_NOT_FOUND", a;
        }
        var p = n[i2] = { exports: {} };
        e[i2][0].call(p.exports, function(r2) {
          var n2 = e[i2][1][r2];
          return o(n2 || r2);
        }, p, p.exports, r, e, n, t);
      }
      return n[i2].exports;
    }
    for (var u = "function" == typeof __require && __require, i = 0; i < t.length; i++) o(t[i]);
    return o;
  }
  return r;
})())({ 1: [function(require2, module, exports) {
  var dragula = require2("dragula");
  (function() {
    this.jKanban = function() {
      var self2 = this;
      var __DEFAULT_ITEM_HANDLE_OPTIONS = {
        enabled: false
      };
      var __DEFAULT_ITEM_ADD_OPTIONS = {
        enabled: false
      };
      this._disallowedItemProperties = [
        "id",
        "title",
        "click",
        "drag",
        "dragend",
        "drop",
        "order"
      ];
      this.element = "";
      this.container = "";
      this.boardContainer = [];
      this.handlers = [];
      this.dragula = dragula;
      this.drake = "";
      this.drakeBoard = "";
      this.itemAddOptions = __DEFAULT_ITEM_ADD_OPTIONS;
      this.itemHandleOptions = __DEFAULT_ITEM_HANDLE_OPTIONS;
      var defaults = {
        element: "",
        gutter: "15px",
        widthBoard: "250px",
        responsive: "700",
        responsivePercentage: false,
        boards: [],
        dragBoards: true,
        dragItems: true,
        //whether can drag cards or not, useful when set permissions on it.
        itemAddOptions: __DEFAULT_ITEM_ADD_OPTIONS,
        itemHandleOptions: __DEFAULT_ITEM_HANDLE_OPTIONS,
        dragEl: function(el, source) {
        },
        dragendEl: function(el) {
        },
        dropEl: function(el, target, source, sibling) {
        },
        dragBoard: function(el, source) {
        },
        dragendBoard: function(el) {
        },
        dropBoard: function(el, target, source, sibling) {
        },
        click: function(el) {
        },
        buttonClick: function(el, boardId) {
        }
      };
      if (arguments[0] && typeof arguments[0] === "object") {
        this.options = __extendDefaults(defaults, arguments[0]);
      }
      this.__getCanMove = function(handle) {
        if (!self2.options.itemHandleOptions.enabled) {
          return !!self2.options.dragItems;
        }
        if (self2.options.itemHandleOptions.handleClass) {
          return handle.classList.contains(self2.options.itemHandleOptions.handleClass);
        }
        return handle.classList.contains("item_handle");
      };
      this.init = function() {
        __setBoard();
        if (window.innerWidth > self2.options.responsive) {
          self2.drakeBoard = self2.dragula([self2.container], {
            moves: function(el, source, handle, sibling) {
              if (!self2.options.dragBoards) return false;
              return handle.classList.contains("kanban-board-header") || handle.classList.contains("kanban-title-board");
            },
            accepts: function(el, target, source, sibling) {
              return target.classList.contains("kanban-container");
            },
            revertOnSpill: true,
            direction: "horizontal"
          }).on("drag", function(el, source) {
            el.classList.add("is-moving");
            self2.options.dragBoard(el, source);
            if (typeof el.dragfn === "function") el.dragfn(el, source);
          }).on("dragend", function(el) {
            __updateBoardsOrder();
            el.classList.remove("is-moving");
            self2.options.dragendBoard(el);
            if (typeof el.dragendfn === "function") el.dragendfn(el);
          }).on("drop", function(el, target, source, sibling) {
            el.classList.remove("is-moving");
            self2.options.dropBoard(el, target, source, sibling);
            if (typeof el.dropfn === "function")
              el.dropfn(el, target, source, sibling);
          });
          self2.drake = self2.dragula(self2.boardContainer, {
            moves: function(el, source, handle, sibling) {
              return self2.__getCanMove(handle);
            },
            revertOnSpill: true
          }).on("cancel", function(el, container, source) {
            self2.enableAllBoards();
          }).on("drag", function(el, source) {
            var elClass = el.getAttribute("class");
            if (elClass !== "" && elClass.indexOf("not-draggable") > -1) {
              self2.drake.cancel(true);
              return;
            }
            el.classList.add("is-moving");
            self2.options.dragEl(el, source);
            var boardJSON = __findBoardJSON(source.parentNode.dataset.id);
            if (boardJSON.dragTo !== void 0) {
              self2.options.boards.map(function(board) {
                if (boardJSON.dragTo.indexOf(board.id) === -1 && board.id !== source.parentNode.dataset.id) {
                  self2.findBoard(board.id).classList.add("disabled-board");
                }
              });
            }
            if (el !== null && typeof el.dragfn === "function")
              el.dragfn(el, source);
          }).on("dragend", function(el) {
            self2.options.dragendEl(el);
            if (el !== null && typeof el.dragendfn === "function")
              el.dragendfn(el);
          }).on("drop", function(el, target, source, sibling) {
            self2.enableAllBoards();
            var boardJSON = __findBoardJSON(source.parentNode.dataset.id);
            if (boardJSON.dragTo !== void 0) {
              if (boardJSON.dragTo.indexOf(target.parentNode.dataset.id) === -1 && target.parentNode.dataset.id !== source.parentNode.dataset.id) {
                self2.drake.cancel(true);
              }
            }
            if (el !== null) {
              var result = self2.options.dropEl(el, target, source, sibling);
              if (result === false) {
                self2.drake.cancel(true);
              }
              el.classList.remove("is-moving");
              if (typeof el.dropfn === "function")
                el.dropfn(el, target, source, sibling);
            }
          });
        }
      };
      this.enableAllBoards = function() {
        var allB = document.querySelectorAll(".kanban-board");
        if (allB.length > 0 && allB !== void 0) {
          for (var i = 0; i < allB.length; i++) {
            allB[i].classList.remove("disabled-board");
          }
        }
      };
      this.addElement = function(boardID, element) {
        var board = self2.element.querySelector(
          '[data-id="' + boardID + '"] .kanban-drag'
        );
        var nodeItem = document.createElement("div");
        nodeItem.classList.add("kanban-item");
        if (typeof element.id !== "undefined" && element.id !== "") {
          nodeItem.setAttribute("data-eid", element.id);
        }
        if (element.class && Array.isArray(element.class)) {
          element.class.forEach(function(cl) {
            nodeItem.classList.add(cl);
          });
        }
        nodeItem.innerHTML = __buildItemTitle(element.title);
        nodeItem.clickfn = element.click;
        nodeItem.dragfn = element.drag;
        nodeItem.dragendfn = element.dragend;
        nodeItem.dropfn = element.drop;
        __appendCustomProperties(nodeItem, element);
        __onclickHandler(nodeItem);
        if (self2.options.itemHandleOptions.enabled) {
          nodeItem.style.cursor = "default";
        }
        board.appendChild(nodeItem);
        return self2;
      };
      this.addForm = function(boardID, formItem) {
        var board = self2.element.querySelector(
          '[data-id="' + boardID + '"] .kanban-drag'
        );
        var _attribute = formItem.getAttribute("class");
        formItem.setAttribute("class", _attribute + " not-draggable");
        board.appendChild(formItem);
        return self2;
      };
      this.addBoards = function(boards, isInit) {
        if (self2.options.responsivePercentage) {
          self2.container.style.width = "100%";
          self2.options.gutter = "1%";
          if (window.innerWidth > self2.options.responsive) {
            var boardWidth = (100 - boards.length * 2) / boards.length;
          } else {
            var boardWidth = 100 - boards.length * 2;
          }
        } else {
          var boardWidth = self2.options.widthBoard;
        }
        var addButton = self2.options.itemAddOptions.enabled;
        var buttonContent = self2.options.itemAddOptions.content;
        var buttonClass = self2.options.itemAddOptions.class;
        var buttonFooter = self2.options.itemAddOptions.footer;
        for (var boardkey in boards) {
          var board = boards[boardkey];
          if (!isInit) {
            self2.options.boards.push(board);
          }
          if (!self2.options.responsivePercentage) {
            if (self2.container.style.width === "") {
              self2.container.style.width = parseInt(boardWidth) + parseInt(self2.options.gutter) * 2 + "px";
            } else {
              self2.container.style.width = parseInt(self2.container.style.width) + parseInt(boardWidth) + parseInt(self2.options.gutter) * 2 + "px";
            }
          }
          var boardNode = document.createElement("div");
          boardNode.dataset.id = board.id;
          boardNode.dataset.order = self2.container.childNodes.length + 1;
          boardNode.classList.add("kanban-board");
          if (self2.options.responsivePercentage) {
            boardNode.style.width = boardWidth + "%";
          } else {
            boardNode.style.width = boardWidth;
          }
          boardNode.style.marginLeft = self2.options.gutter;
          boardNode.style.marginRight = self2.options.gutter;
          var headerBoard = document.createElement("header");
          if (board.class !== "" && board.class !== void 0)
            var allClasses = board.class.split(",");
          else allClasses = [];
          headerBoard.classList.add("kanban-board-header");
          allClasses.map(function(value) {
            value = value.replace(/^[ ]+/g, "");
            headerBoard.classList.add(value);
          });
          headerBoard.innerHTML = '<div class="kanban-title-board">' + board.title + "</div>";
          var contentBoard = document.createElement("main");
          contentBoard.classList.add("kanban-drag");
          if (board.bodyClass !== "" && board.bodyClass !== void 0)
            var bodyClasses = board.bodyClass.split(",");
          else bodyClasses = [];
          bodyClasses.map(function(value) {
            contentBoard.classList.add(value);
          });
          self2.boardContainer.push(contentBoard);
          for (var itemkey in board.item) {
            var itemKanban = board.item[itemkey];
            var nodeItem = document.createElement("div");
            nodeItem.classList.add("kanban-item");
            if (itemKanban.id) {
              nodeItem.dataset.eid = itemKanban.id;
            }
            if (itemKanban.class && Array.isArray(itemKanban.class)) {
              itemKanban.class.forEach(function(cl) {
                nodeItem.classList.add(cl);
              });
            }
            nodeItem.innerHTML = __buildItemTitle(itemKanban.title);
            nodeItem.clickfn = itemKanban.click;
            nodeItem.dragfn = itemKanban.drag;
            nodeItem.dragendfn = itemKanban.dragend;
            nodeItem.dropfn = itemKanban.drop;
            __appendCustomProperties(nodeItem, itemKanban);
            __onclickHandler(nodeItem);
            if (self2.options.itemHandleOptions.enabled) {
              nodeItem.style.cursor = "default";
            }
            contentBoard.appendChild(nodeItem);
          }
          var footerBoard = document.createElement("footer");
          if (addButton) {
            var btn = document.createElement("BUTTON");
            var t = document.createTextNode(buttonContent ? buttonContent : "+");
            btn.setAttribute(
              "class",
              buttonClass ? buttonClass : "kanban-title-button btn btn-default btn-xs"
            );
            btn.appendChild(t);
            if (buttonFooter) {
              footerBoard.appendChild(btn);
            } else {
              headerBoard.appendChild(btn);
            }
            __onButtonClickHandler(btn, board.id);
          }
          boardNode.appendChild(headerBoard);
          boardNode.appendChild(contentBoard);
          boardNode.appendChild(footerBoard);
          self2.container.appendChild(boardNode);
        }
        return self2;
      };
      this.findBoard = function(id) {
        var el = self2.element.querySelector('[data-id="' + id + '"]');
        return el;
      };
      this.getParentBoardID = function(el) {
        if (typeof el === "string") {
          el = self2.element.querySelector('[data-eid="' + el + '"]');
        }
        if (el === null) {
          return null;
        }
        return el.parentNode.parentNode.dataset.id;
      };
      this.moveElement = function(targetBoardID, elementID, element) {
        if (targetBoardID === this.getParentBoardID(elementID)) {
          return;
        }
        this.removeElement(elementID);
        return this.addElement(targetBoardID, element);
      };
      this.replaceElement = function(el, element) {
        var nodeItem = el;
        if (typeof nodeItem === "string") {
          nodeItem = self2.element.querySelector('[data-eid="' + el + '"]');
        }
        nodeItem.innerHTML = element.title;
        nodeItem.clickfn = element.click;
        nodeItem.dragfn = element.drag;
        nodeItem.dragendfn = element.dragend;
        nodeItem.dropfn = element.drop;
        __appendCustomProperties(nodeItem, element);
        return self2;
      };
      this.findElement = function(id) {
        var el = self2.element.querySelector('[data-eid="' + id + '"]');
        return el;
      };
      this.getBoardElements = function(id) {
        var board = self2.element.querySelector(
          '[data-id="' + id + '"] .kanban-drag'
        );
        return board.childNodes;
      };
      this.removeElement = function(el) {
        if (typeof el === "string")
          el = self2.element.querySelector('[data-eid="' + el + '"]');
        if (el !== null) {
          if (typeof el.remove == "function") {
            el.remove();
          } else {
            el.parentNode.removeChild(el);
          }
        }
        return self2;
      };
      this.removeBoard = function(board) {
        var boardElement = null;
        if (typeof board === "string")
          boardElement = self2.element.querySelector('[data-id="' + board + '"]');
        if (boardElement !== null) {
          if (typeof boardElement.remove == "function") {
            boardElement.remove();
          } else {
            boardElement.parentNode.removeChild(boardElement);
          }
        }
        for (var i = 0; i < self2.options.boards.length; i++) {
          if (self2.options.boards[i].id === board) {
            self2.options.boards.splice(i, 1);
            break;
          }
        }
        return self2;
      };
      this.onButtonClick = function(el) {
      };
      function __extendDefaults(source, properties) {
        var property;
        for (property in properties) {
          if (properties.hasOwnProperty(property)) {
            source[property] = properties[property];
          }
        }
        return source;
      }
      function __setBoard() {
        self2.element = document.querySelector(self2.options.element);
        var boardContainer = document.createElement("div");
        boardContainer.classList.add("kanban-container");
        self2.container = boardContainer;
        if (document.querySelector(self2.options.element).dataset.hasOwnProperty("board")) {
          url = document.querySelector(self2.options.element).dataset.board;
          window.fetch(url, {
            method: "GET",
            headers: { "Content-Type": "application/json" }
          }).then((response) => {
            response.json().then(function(data) {
              self2.options.boards = data;
              self2.addBoards(self2.options.boards, true);
            });
          }).catch((error) => {
            console.log("Error: ", error);
          });
        } else {
          self2.addBoards(self2.options.boards, true);
        }
        self2.element.appendChild(self2.container);
      }
      function __onclickHandler(nodeItem, clickfn) {
        nodeItem.addEventListener("click", function(e) {
          e.preventDefault();
          self2.options.click(this);
          if (typeof this.clickfn === "function") this.clickfn(this);
        });
      }
      function __onButtonClickHandler(nodeItem, boardId) {
        nodeItem.addEventListener("click", function(e) {
          e.preventDefault();
          self2.options.buttonClick(this, boardId);
        });
      }
      function __findBoardJSON(id) {
        var el = [];
        self2.options.boards.map(function(board) {
          if (board.id === id) {
            return el.push(board);
          }
        });
        return el[0];
      }
      function __appendCustomProperties(element, parentObject) {
        for (var propertyName in parentObject) {
          if (self2._disallowedItemProperties.indexOf(propertyName) > -1) {
            continue;
          }
          element.setAttribute(
            "data-" + propertyName,
            parentObject[propertyName]
          );
        }
      }
      function __updateBoardsOrder() {
        var index = 1;
        for (var i = 0; i < self2.container.childNodes.length; i++) {
          self2.container.childNodes[i].dataset.order = index++;
        }
      }
      function __buildItemTitle(title) {
        var result = title;
        if (self2.options.itemHandleOptions.enabled) {
          if ((self2.options.itemHandleOptions.customHandler || void 0) === void 0) {
            var customCssHandler = self2.options.itemHandleOptions.customCssHandler;
            var customCssIconHandler = self2.options.itemHandleOptions.customCssIconHandler;
            if ((customCssHandler || void 0) === void 0) {
              customCssHandler = "drag_handler";
            }
            if ((customCssIconHandler || void 0) === void 0) {
              customCssIconHandler = customCssHandler + "_icon";
            }
            result = "<div class='item_handle " + customCssHandler + "'><i class='item_handle " + customCssIconHandler + "'></i></div><div>" + result + "</div>";
          } else {
            result = self2.options.itemHandleOptions.customHandler.replace("%s", result);
          }
        }
        return result;
      }
      this.init();
    };
  })();
}, { "dragula": 9 }], 2: [function(require2, module, exports) {
  module.exports = function atoa(a, n) {
    return Array.prototype.slice.call(a, n);
  };
}, {}], 3: [function(require2, module, exports) {
  "use strict";
  var ticky = require2("ticky");
  module.exports = function debounce(fn, args, ctx) {
    if (!fn) {
      return;
    }
    ticky(function run() {
      fn.apply(ctx || null, args || []);
    });
  };
}, { "ticky": 11 }], 4: [function(require2, module, exports) {
  "use strict";
  var atoa = require2("atoa");
  var debounce = require2("./debounce");
  module.exports = function emitter(thing, options) {
    var opts = options || {};
    var evt = {};
    if (thing === void 0) {
      thing = {};
    }
    thing.on = function(type, fn) {
      if (!evt[type]) {
        evt[type] = [fn];
      } else {
        evt[type].push(fn);
      }
      return thing;
    };
    thing.once = function(type, fn) {
      fn._once = true;
      thing.on(type, fn);
      return thing;
    };
    thing.off = function(type, fn) {
      var c = arguments.length;
      if (c === 1) {
        delete evt[type];
      } else if (c === 0) {
        evt = {};
      } else {
        var et = evt[type];
        if (!et) {
          return thing;
        }
        et.splice(et.indexOf(fn), 1);
      }
      return thing;
    };
    thing.emit = function() {
      var args = atoa(arguments);
      return thing.emitterSnapshot(args.shift()).apply(this, args);
    };
    thing.emitterSnapshot = function(type) {
      var et = (evt[type] || []).slice(0);
      return function() {
        var args = atoa(arguments);
        var ctx = this || thing;
        if (type === "error" && opts.throws !== false && !et.length) {
          throw args.length === 1 ? args[0] : args;
        }
        et.forEach(function emitter2(listen) {
          if (opts.async) {
            debounce(listen, args, ctx);
          } else {
            listen.apply(ctx, args);
          }
          if (listen._once) {
            thing.off(type, listen);
          }
        });
        return thing;
      };
    };
    return thing;
  };
}, { "./debounce": 3, "atoa": 2 }], 5: [function(require2, module, exports) {
  (function(global2) {
    (function() {
      "use strict";
      var customEvent = require2("custom-event");
      var eventmap = require2("./eventmap");
      var doc = global2.document;
      var addEvent = addEventEasy;
      var removeEvent = removeEventEasy;
      var hardCache = [];
      if (!global2.addEventListener) {
        addEvent = addEventHard;
        removeEvent = removeEventHard;
      }
      module.exports = {
        add: addEvent,
        remove: removeEvent,
        fabricate: fabricateEvent
      };
      function addEventEasy(el, type, fn, capturing) {
        return el.addEventListener(type, fn, capturing);
      }
      function addEventHard(el, type, fn) {
        return el.attachEvent("on" + type, wrap(el, type, fn));
      }
      function removeEventEasy(el, type, fn, capturing) {
        return el.removeEventListener(type, fn, capturing);
      }
      function removeEventHard(el, type, fn) {
        var listener = unwrap(el, type, fn);
        if (listener) {
          return el.detachEvent("on" + type, listener);
        }
      }
      function fabricateEvent(el, type, model) {
        var e = eventmap.indexOf(type) === -1 ? makeCustomEvent() : makeClassicEvent();
        if (el.dispatchEvent) {
          el.dispatchEvent(e);
        } else {
          el.fireEvent("on" + type, e);
        }
        function makeClassicEvent() {
          var e2;
          if (doc.createEvent) {
            e2 = doc.createEvent("Event");
            e2.initEvent(type, true, true);
          } else if (doc.createEventObject) {
            e2 = doc.createEventObject();
          }
          return e2;
        }
        function makeCustomEvent() {
          return new customEvent(type, { detail: model });
        }
      }
      function wrapperFactory(el, type, fn) {
        return function wrapper(originalEvent) {
          var e = originalEvent || global2.event;
          e.target = e.target || e.srcElement;
          e.preventDefault = e.preventDefault || function preventDefault() {
            e.returnValue = false;
          };
          e.stopPropagation = e.stopPropagation || function stopPropagation() {
            e.cancelBubble = true;
          };
          e.which = e.which || e.keyCode;
          fn.call(el, e);
        };
      }
      function wrap(el, type, fn) {
        var wrapper = unwrap(el, type, fn) || wrapperFactory(el, type, fn);
        hardCache.push({
          wrapper,
          element: el,
          type,
          fn
        });
        return wrapper;
      }
      function unwrap(el, type, fn) {
        var i = find(el, type, fn);
        if (i) {
          var wrapper = hardCache[i].wrapper;
          hardCache.splice(i, 1);
          return wrapper;
        }
      }
      function find(el, type, fn) {
        var i, item;
        for (i = 0; i < hardCache.length; i++) {
          item = hardCache[i];
          if (item.element === el && item.type === type && item.fn === fn) {
            return i;
          }
        }
      }
    }).call(this);
  }).call(this, typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {});
}, { "./eventmap": 6, "custom-event": 7 }], 6: [function(require2, module, exports) {
  (function(global2) {
    (function() {
      "use strict";
      var eventmap = [];
      var eventname = "";
      var ron = /^on/;
      for (eventname in global2) {
        if (ron.test(eventname)) {
          eventmap.push(eventname.slice(2));
        }
      }
      module.exports = eventmap;
    }).call(this);
  }).call(this, typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {});
}, {}], 7: [function(require2, module, exports) {
  (function(global2) {
    (function() {
      var NativeCustomEvent = global2.CustomEvent;
      function useNative() {
        try {
          var p = new NativeCustomEvent("cat", { detail: { foo: "bar" } });
          return "cat" === p.type && "bar" === p.detail.foo;
        } catch (e) {
        }
        return false;
      }
      module.exports = useNative() ? NativeCustomEvent : (
        // IE >= 9
        "undefined" !== typeof document && "function" === typeof document.createEvent ? function CustomEvent(type, params) {
          var e = document.createEvent("CustomEvent");
          if (params) {
            e.initCustomEvent(type, params.bubbles, params.cancelable, params.detail);
          } else {
            e.initCustomEvent(type, false, false, void 0);
          }
          return e;
        } : (
          // IE <= 8
          function CustomEvent(type, params) {
            var e = document.createEventObject();
            e.type = type;
            if (params) {
              e.bubbles = Boolean(params.bubbles);
              e.cancelable = Boolean(params.cancelable);
              e.detail = params.detail;
            } else {
              e.bubbles = false;
              e.cancelable = false;
              e.detail = void 0;
            }
            return e;
          }
        )
      );
    }).call(this);
  }).call(this, typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {});
}, {}], 8: [function(require2, module, exports) {
  "use strict";
  var cache = {};
  var start = "(?:^|\\s)";
  var end = "(?:\\s|$)";
  function lookupClass(className) {
    var cached = cache[className];
    if (cached) {
      cached.lastIndex = 0;
    } else {
      cache[className] = cached = new RegExp(start + className + end, "g");
    }
    return cached;
  }
  function addClass(el, className) {
    var current = el.className;
    if (!current.length) {
      el.className = className;
    } else if (!lookupClass(className).test(current)) {
      el.className += " " + className;
    }
  }
  function rmClass(el, className) {
    el.className = el.className.replace(lookupClass(className), " ").trim();
  }
  module.exports = {
    add: addClass,
    rm: rmClass
  };
}, {}], 9: [function(require2, module, exports) {
  (function(global2) {
    (function() {
      "use strict";
      var emitter = require2("contra/emitter");
      var crossvent = require2("crossvent");
      var classes = require2("./classes");
      var doc = document;
      var documentElement = doc.documentElement;
      function dragula(initialContainers, options) {
        var len = arguments.length;
        if (len === 1 && Array.isArray(initialContainers) === false) {
          options = initialContainers;
          initialContainers = [];
        }
        var _mirror;
        var _source;
        var _item;
        var _offsetX;
        var _offsetY;
        var _moveX;
        var _moveY;
        var _initialSibling;
        var _currentSibling;
        var _copy;
        var _renderTimer;
        var _lastDropTarget = null;
        var _grabbed;
        var o = options || {};
        if (o.moves === void 0) {
          o.moves = always;
        }
        if (o.accepts === void 0) {
          o.accepts = always;
        }
        if (o.invalid === void 0) {
          o.invalid = invalidTarget;
        }
        if (o.containers === void 0) {
          o.containers = initialContainers || [];
        }
        if (o.isContainer === void 0) {
          o.isContainer = never;
        }
        if (o.copy === void 0) {
          o.copy = false;
        }
        if (o.copySortSource === void 0) {
          o.copySortSource = false;
        }
        if (o.revertOnSpill === void 0) {
          o.revertOnSpill = false;
        }
        if (o.removeOnSpill === void 0) {
          o.removeOnSpill = false;
        }
        if (o.direction === void 0) {
          o.direction = "vertical";
        }
        if (o.ignoreInputTextSelection === void 0) {
          o.ignoreInputTextSelection = true;
        }
        if (o.mirrorContainer === void 0) {
          o.mirrorContainer = doc.body;
        }
        var drake = emitter({
          containers: o.containers,
          start: manualStart,
          end,
          cancel,
          remove,
          destroy,
          canMove,
          dragging: false
        });
        if (o.removeOnSpill === true) {
          drake.on("over", spillOver).on("out", spillOut);
        }
        events();
        return drake;
        function isContainer(el) {
          return drake.containers.indexOf(el) !== -1 || o.isContainer(el);
        }
        function events(remove2) {
          var op = remove2 ? "remove" : "add";
          touchy(documentElement, op, "mousedown", grab);
          touchy(documentElement, op, "mouseup", release);
        }
        function eventualMovements(remove2) {
          var op = remove2 ? "remove" : "add";
          touchy(documentElement, op, "mousemove", startBecauseMouseMoved);
        }
        function movements(remove2) {
          var op = remove2 ? "remove" : "add";
          crossvent[op](documentElement, "selectstart", preventGrabbed);
          crossvent[op](documentElement, "click", preventGrabbed);
        }
        function destroy() {
          events(true);
          release({});
        }
        function preventGrabbed(e) {
          if (_grabbed) {
            e.preventDefault();
          }
        }
        function grab(e) {
          _moveX = e.clientX;
          _moveY = e.clientY;
          var ignore = whichMouseButton(e) !== 1 || e.metaKey || e.ctrlKey;
          if (ignore) {
            return;
          }
          var item = e.target;
          var context = canStart(item);
          if (!context) {
            return;
          }
          _grabbed = context;
          eventualMovements();
          if (e.type === "mousedown") {
            if (isInput(item)) {
              item.focus();
            } else {
              e.preventDefault();
            }
          }
        }
        function startBecauseMouseMoved(e) {
          if (!_grabbed) {
            return;
          }
          if (whichMouseButton(e) === 0) {
            release({});
            return;
          }
          if (e.clientX !== void 0 && Math.abs(e.clientX - _moveX) <= (o.slideFactorX || 0) && (e.clientY !== void 0 && Math.abs(e.clientY - _moveY) <= (o.slideFactorY || 0))) {
            return;
          }
          if (o.ignoreInputTextSelection) {
            var clientX = getCoord("clientX", e) || 0;
            var clientY = getCoord("clientY", e) || 0;
            var elementBehindCursor = doc.elementFromPoint(clientX, clientY);
            if (isInput(elementBehindCursor)) {
              return;
            }
          }
          var grabbed = _grabbed;
          eventualMovements(true);
          movements();
          end();
          start(grabbed);
          var offset = getOffset(_item);
          _offsetX = getCoord("pageX", e) - offset.left;
          _offsetY = getCoord("pageY", e) - offset.top;
          classes.add(_copy || _item, "gu-transit");
          renderMirrorImage();
          drag(e);
        }
        function canStart(item) {
          if (drake.dragging && _mirror) {
            return;
          }
          if (isContainer(item)) {
            return;
          }
          var handle = item;
          while (getParent(item) && isContainer(getParent(item)) === false) {
            if (o.invalid(item, handle)) {
              return;
            }
            item = getParent(item);
            if (!item) {
              return;
            }
          }
          var source = getParent(item);
          if (!source) {
            return;
          }
          if (o.invalid(item, handle)) {
            return;
          }
          var movable = o.moves(item, source, handle, nextEl(item));
          if (!movable) {
            return;
          }
          return {
            item,
            source
          };
        }
        function canMove(item) {
          return !!canStart(item);
        }
        function manualStart(item) {
          var context = canStart(item);
          if (context) {
            start(context);
          }
        }
        function start(context) {
          if (isCopy(context.item, context.source)) {
            _copy = context.item.cloneNode(true);
            drake.emit("cloned", _copy, context.item, "copy");
          }
          _source = context.source;
          _item = context.item;
          _initialSibling = _currentSibling = nextEl(context.item);
          drake.dragging = true;
          drake.emit("drag", _item, _source);
        }
        function invalidTarget() {
          return false;
        }
        function end() {
          if (!drake.dragging) {
            return;
          }
          var item = _copy || _item;
          drop(item, getParent(item));
        }
        function ungrab() {
          _grabbed = false;
          eventualMovements(true);
          movements(true);
        }
        function release(e) {
          ungrab();
          if (!drake.dragging) {
            return;
          }
          var item = _copy || _item;
          var clientX = getCoord("clientX", e) || 0;
          var clientY = getCoord("clientY", e) || 0;
          var elementBehindCursor = getElementBehindPoint(_mirror, clientX, clientY);
          var dropTarget = findDropTarget(elementBehindCursor, clientX, clientY);
          if (dropTarget && (_copy && o.copySortSource || (!_copy || dropTarget !== _source))) {
            drop(item, dropTarget);
          } else if (o.removeOnSpill) {
            remove();
          } else {
            cancel();
          }
        }
        function drop(item, target) {
          var parent = getParent(item);
          if (_copy && o.copySortSource && target === _source) {
            parent.removeChild(_item);
          }
          if (isInitialPlacement(target)) {
            drake.emit("cancel", item, _source, _source);
          } else {
            drake.emit("drop", item, target, _source, _currentSibling);
          }
          cleanup();
        }
        function remove() {
          if (!drake.dragging) {
            return;
          }
          var item = _copy || _item;
          var parent = getParent(item);
          if (parent) {
            parent.removeChild(item);
          }
          drake.emit(_copy ? "cancel" : "remove", item, parent, _source);
          cleanup();
        }
        function cancel(revert) {
          if (!drake.dragging) {
            return;
          }
          var reverts = arguments.length > 0 ? revert : o.revertOnSpill;
          var item = _copy || _item;
          var parent = getParent(item);
          var initial = isInitialPlacement(parent);
          if (initial === false && reverts) {
            if (_copy) {
              if (parent) {
                parent.removeChild(_copy);
              }
            } else {
              _source.insertBefore(item, _initialSibling);
            }
          }
          if (initial || reverts) {
            drake.emit("cancel", item, _source, _source);
          } else {
            drake.emit("drop", item, parent, _source, _currentSibling);
          }
          cleanup();
        }
        function cleanup() {
          var item = _copy || _item;
          ungrab();
          removeMirrorImage();
          if (item) {
            classes.rm(item, "gu-transit");
          }
          if (_renderTimer) {
            clearTimeout(_renderTimer);
          }
          drake.dragging = false;
          if (_lastDropTarget) {
            drake.emit("out", item, _lastDropTarget, _source);
          }
          drake.emit("dragend", item);
          _source = _item = _copy = _initialSibling = _currentSibling = _renderTimer = _lastDropTarget = null;
        }
        function isInitialPlacement(target, s) {
          var sibling;
          if (s !== void 0) {
            sibling = s;
          } else if (_mirror) {
            sibling = _currentSibling;
          } else {
            sibling = nextEl(_copy || _item);
          }
          return target === _source && sibling === _initialSibling;
        }
        function findDropTarget(elementBehindCursor, clientX, clientY) {
          var target = elementBehindCursor;
          while (target && !accepted()) {
            target = getParent(target);
          }
          return target;
          function accepted() {
            var droppable = isContainer(target);
            if (droppable === false) {
              return false;
            }
            var immediate = getImmediateChild(target, elementBehindCursor);
            var reference = getReference(target, immediate, clientX, clientY);
            var initial = isInitialPlacement(target, reference);
            if (initial) {
              return true;
            }
            return o.accepts(_item, target, _source, reference);
          }
        }
        function drag(e) {
          if (!_mirror) {
            return;
          }
          e.preventDefault();
          var clientX = getCoord("clientX", e) || 0;
          var clientY = getCoord("clientY", e) || 0;
          var x = clientX - _offsetX;
          var y = clientY - _offsetY;
          _mirror.style.left = x + "px";
          _mirror.style.top = y + "px";
          var item = _copy || _item;
          var elementBehindCursor = getElementBehindPoint(_mirror, clientX, clientY);
          var dropTarget = findDropTarget(elementBehindCursor, clientX, clientY);
          var changed = dropTarget !== null && dropTarget !== _lastDropTarget;
          if (changed || dropTarget === null) {
            out();
            _lastDropTarget = dropTarget;
            over();
          }
          var parent = getParent(item);
          if (dropTarget === _source && _copy && !o.copySortSource) {
            if (parent) {
              parent.removeChild(item);
            }
            return;
          }
          var reference;
          var immediate = getImmediateChild(dropTarget, elementBehindCursor);
          if (immediate !== null) {
            reference = getReference(dropTarget, immediate, clientX, clientY);
          } else if (o.revertOnSpill === true && !_copy) {
            reference = _initialSibling;
            dropTarget = _source;
          } else {
            if (_copy && parent) {
              parent.removeChild(item);
            }
            return;
          }
          if (reference === null && changed || reference !== item && reference !== nextEl(item)) {
            _currentSibling = reference;
            dropTarget.insertBefore(item, reference);
            drake.emit("shadow", item, dropTarget, _source);
          }
          function moved(type) {
            drake.emit(type, item, _lastDropTarget, _source);
          }
          function over() {
            if (changed) {
              moved("over");
            }
          }
          function out() {
            if (_lastDropTarget) {
              moved("out");
            }
          }
        }
        function spillOver(el) {
          classes.rm(el, "gu-hide");
        }
        function spillOut(el) {
          if (drake.dragging) {
            classes.add(el, "gu-hide");
          }
        }
        function renderMirrorImage() {
          if (_mirror) {
            return;
          }
          var rect = _item.getBoundingClientRect();
          _mirror = _item.cloneNode(true);
          _mirror.style.width = getRectWidth(rect) + "px";
          _mirror.style.height = getRectHeight(rect) + "px";
          classes.rm(_mirror, "gu-transit");
          classes.add(_mirror, "gu-mirror");
          o.mirrorContainer.appendChild(_mirror);
          touchy(documentElement, "add", "mousemove", drag);
          classes.add(o.mirrorContainer, "gu-unselectable");
          drake.emit("cloned", _mirror, _item, "mirror");
        }
        function removeMirrorImage() {
          if (_mirror) {
            classes.rm(o.mirrorContainer, "gu-unselectable");
            touchy(documentElement, "remove", "mousemove", drag);
            getParent(_mirror).removeChild(_mirror);
            _mirror = null;
          }
        }
        function getImmediateChild(dropTarget, target) {
          var immediate = target;
          while (immediate !== dropTarget && getParent(immediate) !== dropTarget) {
            immediate = getParent(immediate);
          }
          if (immediate === documentElement) {
            return null;
          }
          return immediate;
        }
        function getReference(dropTarget, target, x, y) {
          var horizontal = o.direction === "horizontal";
          var reference = target !== dropTarget ? inside() : outside();
          return reference;
          function outside() {
            var len2 = dropTarget.children.length;
            var i;
            var el;
            var rect;
            for (i = 0; i < len2; i++) {
              el = dropTarget.children[i];
              rect = el.getBoundingClientRect();
              if (horizontal && rect.left + rect.width / 2 > x) {
                return el;
              }
              if (!horizontal && rect.top + rect.height / 2 > y) {
                return el;
              }
            }
            return null;
          }
          function inside() {
            var rect = target.getBoundingClientRect();
            if (horizontal) {
              return resolve(x > rect.left + getRectWidth(rect) / 2);
            }
            return resolve(y > rect.top + getRectHeight(rect) / 2);
          }
          function resolve(after) {
            return after ? nextEl(target) : target;
          }
        }
        function isCopy(item, container) {
          return typeof o.copy === "boolean" ? o.copy : o.copy(item, container);
        }
      }
      function touchy(el, op, type, fn) {
        var touch = {
          mouseup: "touchend",
          mousedown: "touchstart",
          mousemove: "touchmove"
        };
        var pointers = {
          mouseup: "pointerup",
          mousedown: "pointerdown",
          mousemove: "pointermove"
        };
        var microsoft = {
          mouseup: "MSPointerUp",
          mousedown: "MSPointerDown",
          mousemove: "MSPointerMove"
        };
        if (global2.navigator.pointerEnabled) {
          crossvent[op](el, pointers[type], fn);
        } else if (global2.navigator.msPointerEnabled) {
          crossvent[op](el, microsoft[type], fn);
        } else {
          crossvent[op](el, touch[type], fn);
          crossvent[op](el, type, fn);
        }
      }
      function whichMouseButton(e) {
        if (e.touches !== void 0) {
          return e.touches.length;
        }
        if (e.which !== void 0 && e.which !== 0) {
          return e.which;
        }
        if (e.buttons !== void 0) {
          return e.buttons;
        }
        var button = e.button;
        if (button !== void 0) {
          return button & 1 ? 1 : button & 2 ? 3 : button & 4 ? 2 : 0;
        }
      }
      function getOffset(el) {
        var rect = el.getBoundingClientRect();
        return {
          left: rect.left + getScroll("scrollLeft", "pageXOffset"),
          top: rect.top + getScroll("scrollTop", "pageYOffset")
        };
      }
      function getScroll(scrollProp, offsetProp) {
        if (typeof global2[offsetProp] !== "undefined") {
          return global2[offsetProp];
        }
        if (documentElement.clientHeight) {
          return documentElement[scrollProp];
        }
        return doc.body[scrollProp];
      }
      function getElementBehindPoint(point, x, y) {
        point = point || {};
        var state = point.className || "";
        var el;
        point.className += " gu-hide";
        el = doc.elementFromPoint(x, y);
        point.className = state;
        return el;
      }
      function never() {
        return false;
      }
      function always() {
        return true;
      }
      function getRectWidth(rect) {
        return rect.width || rect.right - rect.left;
      }
      function getRectHeight(rect) {
        return rect.height || rect.bottom - rect.top;
      }
      function getParent(el) {
        return el.parentNode === doc ? null : el.parentNode;
      }
      function isInput(el) {
        return el.tagName === "INPUT" || el.tagName === "TEXTAREA" || el.tagName === "SELECT" || isEditable(el);
      }
      function isEditable(el) {
        if (!el) {
          return false;
        }
        if (el.contentEditable === "false") {
          return false;
        }
        if (el.contentEditable === "true") {
          return true;
        }
        return isEditable(getParent(el));
      }
      function nextEl(el) {
        return el.nextElementSibling || manually();
        function manually() {
          var sibling = el;
          do {
            sibling = sibling.nextSibling;
          } while (sibling && sibling.nodeType !== 1);
          return sibling;
        }
      }
      function getEventHost(e) {
        if (e.targetTouches && e.targetTouches.length) {
          return e.targetTouches[0];
        }
        if (e.changedTouches && e.changedTouches.length) {
          return e.changedTouches[0];
        }
        return e;
      }
      function getCoord(coord, e) {
        var host = getEventHost(e);
        var missMap = {
          pageX: "clientX",
          // IE8
          pageY: "clientY"
          // IE8
        };
        if (coord in missMap && !(coord in host) && missMap[coord] in host) {
          coord = missMap[coord];
        }
        return host[coord];
      }
      module.exports = dragula;
    }).call(this);
  }).call(this, typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {});
}, { "./classes": 8, "contra/emitter": 4, "crossvent": 5 }], 10: [function(require2, module, exports) {
  var process = module.exports = {};
  var cachedSetTimeout;
  var cachedClearTimeout;
  function defaultSetTimout() {
    throw new Error("setTimeout has not been defined");
  }
  function defaultClearTimeout() {
    throw new Error("clearTimeout has not been defined");
  }
  (function() {
    try {
      if (typeof setTimeout === "function") {
        cachedSetTimeout = setTimeout;
      } else {
        cachedSetTimeout = defaultSetTimout;
      }
    } catch (e) {
      cachedSetTimeout = defaultSetTimout;
    }
    try {
      if (typeof clearTimeout === "function") {
        cachedClearTimeout = clearTimeout;
      } else {
        cachedClearTimeout = defaultClearTimeout;
      }
    } catch (e) {
      cachedClearTimeout = defaultClearTimeout;
    }
  })();
  function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
      return setTimeout(fun, 0);
    }
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
      cachedSetTimeout = setTimeout;
      return setTimeout(fun, 0);
    }
    try {
      return cachedSetTimeout(fun, 0);
    } catch (e) {
      try {
        return cachedSetTimeout.call(null, fun, 0);
      } catch (e2) {
        return cachedSetTimeout.call(this, fun, 0);
      }
    }
  }
  function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
      return clearTimeout(marker);
    }
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
      cachedClearTimeout = clearTimeout;
      return clearTimeout(marker);
    }
    try {
      return cachedClearTimeout(marker);
    } catch (e) {
      try {
        return cachedClearTimeout.call(null, marker);
      } catch (e2) {
        return cachedClearTimeout.call(this, marker);
      }
    }
  }
  var queue = [];
  var draining = false;
  var currentQueue;
  var queueIndex = -1;
  function cleanUpNextTick() {
    if (!draining || !currentQueue) {
      return;
    }
    draining = false;
    if (currentQueue.length) {
      queue = currentQueue.concat(queue);
    } else {
      queueIndex = -1;
    }
    if (queue.length) {
      drainQueue();
    }
  }
  function drainQueue() {
    if (draining) {
      return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;
    var len = queue.length;
    while (len) {
      currentQueue = queue;
      queue = [];
      while (++queueIndex < len) {
        if (currentQueue) {
          currentQueue[queueIndex].run();
        }
      }
      queueIndex = -1;
      len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
  }
  process.nextTick = function(fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
      for (var i = 1; i < arguments.length; i++) {
        args[i - 1] = arguments[i];
      }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
      runTimeout(drainQueue);
    }
  };
  function Item(fun, array) {
    this.fun = fun;
    this.array = array;
  }
  Item.prototype.run = function() {
    this.fun.apply(null, this.array);
  };
  process.title = "browser";
  process.browser = true;
  process.env = {};
  process.argv = [];
  process.version = "";
  process.versions = {};
  function noop() {
  }
  process.on = noop;
  process.addListener = noop;
  process.once = noop;
  process.off = noop;
  process.removeListener = noop;
  process.removeAllListeners = noop;
  process.emit = noop;
  process.prependListener = noop;
  process.prependOnceListener = noop;
  process.listeners = function(name) {
    return [];
  };
  process.binding = function(name) {
    throw new Error("process.binding is not supported");
  };
  process.cwd = function() {
    return "/";
  };
  process.chdir = function(dir) {
    throw new Error("process.chdir is not supported");
  };
  process.umask = function() {
    return 0;
  };
}, {}], 11: [function(require2, module, exports) {
  (function(setImmediate) {
    (function() {
      var si = typeof setImmediate === "function", tick;
      if (si) {
        tick = function(fn) {
          setImmediate(fn);
        };
      } else {
        tick = function(fn) {
          setTimeout(fn, 0);
        };
      }
      module.exports = tick;
    }).call(this);
  }).call(this, require2("timers").setImmediate);
}, { "timers": 12 }], 12: [function(require2, module, exports) {
  (function(setImmediate, clearImmediate) {
    (function() {
      var nextTick = require2("process/browser.js").nextTick;
      var apply = Function.prototype.apply;
      var slice = Array.prototype.slice;
      var immediateIds = {};
      var nextImmediateId = 0;
      exports.setTimeout = function() {
        return new Timeout(apply.call(setTimeout, window, arguments), clearTimeout);
      };
      exports.setInterval = function() {
        return new Timeout(apply.call(setInterval, window, arguments), clearInterval);
      };
      exports.clearTimeout = exports.clearInterval = function(timeout) {
        timeout.close();
      };
      function Timeout(id, clearFn) {
        this._id = id;
        this._clearFn = clearFn;
      }
      Timeout.prototype.unref = Timeout.prototype.ref = function() {
      };
      Timeout.prototype.close = function() {
        this._clearFn.call(window, this._id);
      };
      exports.enroll = function(item, msecs) {
        clearTimeout(item._idleTimeoutId);
        item._idleTimeout = msecs;
      };
      exports.unenroll = function(item) {
        clearTimeout(item._idleTimeoutId);
        item._idleTimeout = -1;
      };
      exports._unrefActive = exports.active = function(item) {
        clearTimeout(item._idleTimeoutId);
        var msecs = item._idleTimeout;
        if (msecs >= 0) {
          item._idleTimeoutId = setTimeout(function onTimeout() {
            if (item._onTimeout)
              item._onTimeout();
          }, msecs);
        }
      };
      exports.setImmediate = typeof setImmediate === "function" ? setImmediate : function(fn) {
        var id = nextImmediateId++;
        var args = arguments.length < 2 ? false : slice.call(arguments, 1);
        immediateIds[id] = true;
        nextTick(function onNextTick() {
          if (immediateIds[id]) {
            if (args) {
              fn.apply(null, args);
            } else {
              fn.call(null);
            }
            exports.clearImmediate(id);
          }
        });
        return id;
      };
      exports.clearImmediate = typeof clearImmediate === "function" ? clearImmediate : function(id) {
        delete immediateIds[id];
      };
    }).call(this);
  }).call(this, require2("timers").setImmediate, require2("timers").clearImmediate);
}, { "process/browser.js": 10, "timers": 12 }] }, {}, [1]);
//# sourceMappingURL=jkanban_dist_jkanban.js.map
