import "./chunk-PLBDWROU.js";
import {
  dataTables_default
} from "./chunk-Q4W4OIFU.js";
import {
  require_jquery
} from "./chunk-DWUQO4WP.js";
import {
  __toESM
} from "./chunk-LK32TJAX.js";

// node_modules/.pnpm/datatables.net-buttons@3.2.3/node_modules/datatables.net-buttons/js/buttons.print.mjs
var import_jquery = __toESM(require_jquery(), 1);
var $ = import_jquery.default;
var _link = document.createElement("a");
var _styleToAbs = function(el) {
  var clone = $(el).clone()[0];
  if (clone.nodeName.toLowerCase() === "link") {
    clone.href = _relToAbs(clone.href);
  }
  return clone.outerHTML;
};
var _relToAbs = function(href) {
  _link.href = href;
  var linkHost = _link.host;
  if (linkHost.indexOf("/") === -1 && _link.pathname.indexOf("/") !== 0) {
    linkHost += "/";
  }
  return _link.protocol + "//" + linkHost + _link.pathname + _link.search;
};
dataTables_default.ext.buttons.print = {
  className: "buttons-print",
  text: function(dt) {
    return dt.i18n("buttons.print", "Print");
  },
  action: function(e, dt, button, config, cb) {
    var data = dt.buttons.exportData(
      $.extend({ decodeEntities: false }, config.exportOptions)
      // XSS protection
    );
    var exportInfo = dt.buttons.exportInfo(config);
    var columnClasses = dt.columns(config.exportOptions.columns).nodes().map(function(n) {
      return n.className;
    }).toArray();
    var addRow = function(d, tag) {
      var str = "<tr>";
      for (var i2 = 0, ien2 = d.length; i2 < ien2; i2++) {
        var dataOut = d[i2] === null || d[i2] === void 0 ? "" : d[i2];
        var classAttr = columnClasses[i2] ? 'class="' + columnClasses[i2] + '"' : "";
        str += "<" + tag + " " + classAttr + ">" + dataOut + "</" + tag + ">";
      }
      return str + "</tr>";
    };
    var html = '<table class="' + dt.table().node().className + '">';
    if (config.header) {
      var headerRows = data.headerStructure.map(function(row) {
        return "<tr>" + row.map(function(cell) {
          return cell ? '<th colspan="' + cell.colspan + '" rowspan="' + cell.rowspan + '">' + cell.title + "</th>" : "";
        }).join("") + "</tr>";
      });
      html += "<thead>" + headerRows.join("") + "</thead>";
    }
    html += "<tbody>";
    for (var i = 0, ien = data.body.length; i < ien; i++) {
      html += addRow(data.body[i], "td");
    }
    html += "</tbody>";
    if (config.footer && data.footer) {
      var footerRows = data.footerStructure.map(function(row) {
        return "<tr>" + row.map(function(cell) {
          return cell ? '<th colspan="' + cell.colspan + '" rowspan="' + cell.rowspan + '">' + cell.title + "</th>" : "";
        }).join("") + "</tr>";
      });
      html += "<tfoot>" + footerRows.join("") + "</tfoot>";
    }
    html += "</table>";
    var win = window.open("", "");
    if (!win) {
      dt.buttons.info(
        dt.i18n("buttons.printErrorTitle", "Unable to open print view"),
        dt.i18n(
          "buttons.printErrorMsg",
          "Please allow popups in your browser for this site to be able to view the print view."
        ),
        5e3
      );
      return;
    }
    win.document.close();
    var head = "<title>" + exportInfo.title + "</title>";
    $("style, link").each(function() {
      head += _styleToAbs(this);
    });
    try {
      win.document.head.innerHTML = head;
    } catch (e2) {
      $(win.document.head).html(head);
    }
    if (config.customScripts) {
      config.customScripts.forEach(function(script) {
        var tag = win.document.createElement("script");
        tag.src = script;
        win.document.getElementsByTagName("head")[0].appendChild(tag);
      });
    }
    win.document.body.innerHTML = "<h1>" + exportInfo.title + "</h1><div>" + (exportInfo.messageTop || "") + "</div>" + html + "<div>" + (exportInfo.messageBottom || "") + "</div>";
    $(win.document.body).addClass("dt-print-view");
    $("img", win.document.body).each(function(i2, img) {
      img.setAttribute("src", _relToAbs(img.getAttribute("src")));
    });
    if (config.customize) {
      config.customize(win, config, dt);
    }
    var autoPrint = function() {
      if (config.autoPrint) {
        win.print();
        win.close();
      }
    };
    win.setTimeout(autoPrint, 1e3);
    cb();
  },
  async: 100,
  title: "*",
  messageTop: "*",
  messageBottom: "*",
  exportOptions: {},
  header: true,
  footer: true,
  autoPrint: true,
  customize: null
};
var buttons_print_default = dataTables_default;
export {
  buttons_print_default as default
};
/*! Bundled license information:

datatables.net-buttons/js/buttons.print.mjs:
  (*!
   * Print button for Buttons and DataTables.
   * © SpryMedia Ltd - datatables.net/license
   *)
*/
//# sourceMappingURL=datatables__net-buttons_js_buttons__print.js.map
