// NOTICE: This file is generated by Rollup. To modify it,
// please instead edit the ESM counterpart and rebuild with Rollup (npm run build).
'use strict';

const constants = require('../constants.cjs');

class ConfigurationError extends Error {
	name = 'ConfigurationError';

	code = constants.EXIT_CODE_INVALID_CONFIG;

	/**
	 * @param {string} message
	 */
	constructor(message) {
		super(message);
	}
}

class AllFilesIgnoredError extends Error {
	name = 'AllFilesIgnoredError';

	constructor() {
		super(
			'All input files were ignored because of the ignore pattern. Either change your input, ignore pattern or use "--allow-empty-input" to allow no inputs',
		);
	}
}

class NoFilesFoundError extends Error {
	name = 'NoFilesFoundError';

	/**
	 * @param {string|string[]} fileList
	 */
	constructor(fileList) {
		super();

		if (typeof fileList === 'string') {
			fileList = [fileList];
		}

		const pattern = fileList.filter((i) => !i.startsWith('!')).join(', ');

		this.message = `No files matching the pattern "${pattern}" were found.`;
	}
}

exports.AllFilesIgnoredError = AllFilesIgnoredError;
exports.ConfigurationError = ConfigurationError;
exports.NoFilesFoundError = NoFilesFoundError;
