/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import {
    type Localization,
    type ValidateFunctionInterface,
    type ValidateOptions,
    type ValidateResult,
} from '@form-validation/core';

export interface UuidOptions extends ValidateOptions {
    // Can be 3, 4, 5, null
    version?: string;
}
export interface UuidLocalization extends Localization {
    uuid: {
        default: string;
        version: string;
    };
}

export function uuid(): ValidateFunctionInterface<UuidOptions, ValidateResult>;
