/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import {
    type Localization,
    type ValidateFunctionInterface,
    type ValidateOptions,
    type ValidateResult,
} from '@form-validation/core';

export interface IpOptions extends ValidateOptions {
    // Enable IPv4 validator, default to true
    ipv4?: boolean;
    // Enable IPv6 validator, default to true
    ipv6?: boolean;
}
export interface IpLocalization extends Localization {
    ip: {
        default: string;
        ipv4: string;
        ipv6: string;
    };
}

export function ip(): ValidateFunctionInterface<IpOptions, ValidateResult>;
