<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Shop;

class ShopSeeder extends Seeder
{
  /**
   * Run the database seeds.
   */
  public function run(): void
  {
    $shops = [
      [
        'name' => 'Ocean View Store',
        'code' => 'OV003',
        'address' => '12 Ocean View Road, City',
        'phone' => '+94 11 2345678',
        'manager_user_id' => null,
      ],
      [
        'name' => 'Hilltop Mall Shop',
        'code' => 'HM004',
        'address' => '78 Hilltop Mall, City',
        'phone' => '+94 11 3456789',
        'manager_user_id' => null,
      ],
      [
        'name' => 'Riverbank Shop',
        'code' => 'RB005',
        'address' => '90 Riverbank Street, City',
        'phone' => '+94 11 4567890',
        'manager_user_id' => null,
      ],
      [
        'name' => 'Sunset Boulevard Store',
        'code' => 'SB006',
        'address' => '22 Sunset Boulevard, City',
        'phone' => '+94 11 5678901',
        'manager_user_id' => null,
      ],
      [
        'name' => 'Downtown Plaza Shop',
        'code' => 'DP007',
        'address' => '55 Downtown Plaza, City',
        'phone' => '+94 11 6789012',
        'manager_user_id' => null,
      ],
      [
        'name' => 'Greenfield Mall Shop',
        'code' => 'GM008',
        'address' => '11 Greenfield Mall, City',
        'phone' => '+94 11 7890123',
        'manager_user_id' => null,
      ],
      [
        'name' => 'Lakeside Store',
        'code' => 'LS009',
        'address' => '33 Lakeside Avenue, City',
        'phone' => '+94 11 8901234',
        'manager_user_id' => null,
      ],
      [
        'name' => 'Parkview Shop',
        'code' => 'PV010',
        'address' => '44 Parkview Road, City',
        'phone' => '+94 11 9012345',
        'manager_user_id' => null,
      ],
      [
        'name' => 'City Center Store',
        'code' => 'CC011',
        'address' => '66 City Center Street, City',
        'phone' => '+94 11 0123456',
        'manager_user_id' => null,
      ],
      [
        'name' => 'Maple Street Shop',
        'code' => 'MS012',
        'address' => '77 Maple Street, City',
        'phone' => '+94 11 1230987',
        'manager_user_id' => null,
      ],
    ];

    foreach ($shops as $shop) {
      Shop::firstOrCreate(
        ['code' => $shop['code']], // avoid duplicates
        $shop
      );
    }
  }
}
