<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Role;

class RoleSeeder extends Seeder
{
  /**
   * Run the database seeds.
   */
  public function run(): void
  {
    $roles = [
      ['name' => 'admin', 'display_name' => 'Administrator'],
      ['name' => 'manager', 'display_name' => 'Shop Manager'],
      ['name' => 'staff', 'display_name' => 'Staff Member'],
    ];

    foreach ($roles as $role) {
      Role::firstOrCreate(
        ['name' => $role['name']], // avoid duplicates
        ['display_name' => $role['display_name']]
      );
    }
  }
}
