<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Role;
use App\Models\Permission;
use App\Models\RolePermission;

class RolePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get roles
        $adminRole = Role::where('name', 'admin')->first();
        $managerRole = Role::where('name', 'manager')->first();
        $staffRole = Role::where('name', 'staff')->first();

        // Get all permissions
        $allPermissions = Permission::all();

        // Admin role gets all permissions
        if ($adminRole) {
            foreach ($allPermissions as $permission) {
                RolePermission::updateOrCreate(
                    [
                        'role_id' => $adminRole->id,
                        'permission_id' => $permission->id,
                    ],
                    [
                        'granted' => true,
                    ]
                );
            }
        }

        // Manager role - give view permissions by default
        if ($managerRole) {
            $viewPermissions = $allPermissions->filter(function ($permission) {
                return str_ends_with($permission->name, '.view') || 
                       str_contains($permission->name, 'dashboard');
            });

            foreach ($viewPermissions as $permission) {
                RolePermission::updateOrCreate(
                    [
                        'role_id' => $managerRole->id,
                        'permission_id' => $permission->id,
                    ],
                    [
                        'granted' => true,
                    ]
                );
            }
        }

        // Staff role - minimal permissions (only dashboard.view by default)
        if ($staffRole) {
            $dashboardViewPermission = Permission::where('name', 'dashboard.view')->first();
            if ($dashboardViewPermission) {
                RolePermission::updateOrCreate(
                    [
                        'role_id' => $staffRole->id,
                        'permission_id' => $dashboardViewPermission->id,
                    ],
                    [
                        'granted' => true,
                    ]
                );
            }
        }

        $this->command->info('Role permissions seeded successfully!');
    }
}
