<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            // Dashboard
            ['name' => 'dashboard.view', 'module' => 'dashboard', 'action' => 'view', 'description' => 'View Dashboard'],
            
            // Dashboard Components
            ['name' => 'dashboard.total_rentals', 'module' => 'dashboard', 'action' => 'total_rentals', 'description' => 'View Total Rentals Widget'],
            ['name' => 'dashboard.active_rentals', 'module' => 'dashboard', 'action' => 'active_rentals', 'description' => 'View Active Rentals Widget'],
            ['name' => 'dashboard.total_revenue', 'module' => 'dashboard', 'action' => 'total_revenue', 'description' => 'View Total Revenue Widget'],
            ['name' => 'dashboard.today_revenue', 'module' => 'dashboard', 'action' => 'today_revenue', 'description' => 'View Today\'s Revenue Widget'],
            ['name' => 'dashboard.total_customers', 'module' => 'dashboard', 'action' => 'total_customers', 'description' => 'View Total Customers Widget'],
            ['name' => 'dashboard.total_equipment', 'module' => 'dashboard', 'action' => 'total_equipment', 'description' => 'View Total Equipment Widget'],
            ['name' => 'dashboard.active_stock', 'module' => 'dashboard', 'action' => 'active_stock', 'description' => 'View Active Stock Widget'],
            ['name' => 'dashboard.revenue_chart', 'module' => 'dashboard', 'action' => 'revenue_chart', 'description' => 'View Revenue Chart'],
            ['name' => 'dashboard.status_chart', 'module' => 'dashboard', 'action' => 'status_chart', 'description' => 'View Status Distribution Chart'],
            ['name' => 'dashboard.equipment_chart', 'module' => 'dashboard', 'action' => 'equipment_chart', 'description' => 'View Equipment Utilization Chart'],
            ['name' => 'dashboard.daily_rentals_chart', 'module' => 'dashboard', 'action' => 'daily_rentals_chart', 'description' => 'View Daily Rentals Chart'],

            // Shops
            ['name' => 'shops.view', 'module' => 'shops', 'action' => 'view', 'description' => 'View Shops'],
            ['name' => 'shops.create', 'module' => 'shops', 'action' => 'create', 'description' => 'Create Shop'],
            ['name' => 'shops.update', 'module' => 'shops', 'action' => 'update', 'description' => 'Update Shop'],
            ['name' => 'shops.delete', 'module' => 'shops', 'action' => 'delete', 'description' => 'Delete Shop'],

            // Users
            ['name' => 'users.view', 'module' => 'users', 'action' => 'view', 'description' => 'View Users'],
            ['name' => 'users.create', 'module' => 'users', 'action' => 'create', 'description' => 'Create User'],
            ['name' => 'users.update', 'module' => 'users', 'action' => 'update', 'description' => 'Update User'],
            ['name' => 'users.delete', 'module' => 'users', 'action' => 'delete', 'description' => 'Delete User'],

            // Categories
            ['name' => 'categories.view', 'module' => 'categories', 'action' => 'view', 'description' => 'View Categories'],
            ['name' => 'categories.create', 'module' => 'categories', 'action' => 'create', 'description' => 'Create Category'],
            ['name' => 'categories.update', 'module' => 'categories', 'action' => 'update', 'description' => 'Update Category'],
            ['name' => 'categories.delete', 'module' => 'categories', 'action' => 'delete', 'description' => 'Delete Category'],

            // Equipments
            ['name' => 'equipments.view', 'module' => 'equipments', 'action' => 'view', 'description' => 'View Equipments'],
            ['name' => 'equipments.create', 'module' => 'equipments', 'action' => 'create', 'description' => 'Create Equipment'],
            ['name' => 'equipments.update', 'module' => 'equipments', 'action' => 'update', 'description' => 'Update Equipment'],
            ['name' => 'equipments.delete', 'module' => 'equipments', 'action' => 'delete', 'description' => 'Delete Equipment'],

            // Stocks
            ['name' => 'stocks.view', 'module' => 'stocks', 'action' => 'view', 'description' => 'View Stocks'],
            ['name' => 'stocks.create', 'module' => 'stocks', 'action' => 'create', 'description' => 'Create Stock'],
            ['name' => 'stocks.update', 'module' => 'stocks', 'action' => 'update', 'description' => 'Update Stock'],
            ['name' => 'stocks.delete', 'module' => 'stocks', 'action' => 'delete', 'description' => 'Delete Stock'],

            // Customers
            ['name' => 'customers.view', 'module' => 'customers', 'action' => 'view', 'description' => 'View Customers'],
            ['name' => 'customers.create', 'module' => 'customers', 'action' => 'create', 'description' => 'Create Customer'],
            ['name' => 'customers.update', 'module' => 'customers', 'action' => 'update', 'description' => 'Update Customer'],
            ['name' => 'customers.delete', 'module' => 'customers', 'action' => 'delete', 'description' => 'Delete Customer'],

            // Rentals
            ['name' => 'rentals.view', 'module' => 'rentals', 'action' => 'view', 'description' => 'View Rentals'],
            ['name' => 'rentals.create', 'module' => 'rentals', 'action' => 'create', 'description' => 'Create Rental'],
            ['name' => 'rentals.update', 'module' => 'rentals', 'action' => 'update', 'description' => 'Update Rental'],
            ['name' => 'rentals.delete', 'module' => 'rentals', 'action' => 'delete', 'description' => 'Delete Rental'],

            // Permissions (for managing permissions)
            ['name' => 'permissions.view', 'module' => 'permissions', 'action' => 'view', 'description' => 'View Permissions'],
            ['name' => 'permissions.update', 'module' => 'permissions', 'action' => 'update', 'description' => 'Update Permissions'],
        ];

        foreach ($permissions as $permission) {
            Permission::updateOrCreate(
                ['name' => $permission['name']],
                $permission
            );
        }

        $this->command->info('Permissions seeded successfully!');
    }
}
