<?php

namespace Database\Seeders;

use App\Models\Category;
use App\Models\Equipment;
use Illuminate\Database\Seeder;

class EquipmentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $powerToolsCategory = Category::where('name', 'Power Tools')->first();
        $handToolsCategory = Category::where('name', 'Hand Tools')->first();
        $constructionCategory = Category::where('name', 'Construction Equipment')->first();

        $equipments = [
            [
                'name' => 'Drill Machine',
                'sku' => 'EQ-DRILL-001',
                'category_id' => $powerToolsCategory?->id,
                'description' => 'Electric drill machine with multiple speed settings',
                'daily_rate' => 500.00,
                'replacement_cost' => 15000.00,
                'is_serial_tracked' => true,
            ],
            [
                'name' => 'Circular Saw',
                'sku' => 'EQ-CSAW-001',
                'category_id' => $powerToolsCategory?->id,
                'description' => 'Heavy-duty circular saw for cutting wood and metal',
                'daily_rate' => 750.00,
                'replacement_cost' => 25000.00,
                'is_serial_tracked' => true,
            ],
            [
                'name' => 'Hammer Set',
                'sku' => 'EQ-HAMM-001',
                'category_id' => $handToolsCategory?->id,
                'description' => 'Professional hammer set with different sizes',
                'daily_rate' => 200.00,
                'replacement_cost' => 3000.00,
                'is_serial_tracked' => false,
            ],
            [
                'name' => 'Screwdriver Set',
                'sku' => 'EQ-SCREW-001',
                'category_id' => $handToolsCategory?->id,
                'description' => 'Complete screwdriver set with various sizes',
                'daily_rate' => 150.00,
                'replacement_cost' => 2000.00,
                'is_serial_tracked' => false,
            ],
            [
                'name' => 'Concrete Mixer',
                'sku' => 'EQ-CMIX-001',
                'category_id' => $constructionCategory?->id,
                'description' => 'Portable concrete mixer for construction projects',
                'daily_rate' => 2000.00,
                'replacement_cost' => 150000.00,
                'is_serial_tracked' => true,
            ],
            [
                'name' => 'Measuring Tape',
                'sku' => 'EQ-MTAP-001',
                'category_id' => Category::where('name', 'Measuring Tools')->first()?->id,
                'description' => 'Professional measuring tape 50 feet',
                'daily_rate' => 100.00,
                'replacement_cost' => 1500.00,
                'is_serial_tracked' => false,
            ],
        ];

        foreach ($equipments as $equipment) {
            Equipment::firstOrCreate(
                ['sku' => $equipment['sku']],
                $equipment
            );
        }
    }
}
