<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            ['name' => 'Power Tools', 'description' => 'Electric and battery-powered tools'],
            ['name' => 'Hand Tools', 'description' => 'Manual tools for various tasks'],
            ['name' => 'Construction Equipment', 'description' => 'Heavy machinery for construction'],
            ['name' => 'Garden Tools', 'description' => 'Tools for gardening and landscaping'],
            ['name' => 'Measuring Tools', 'description' => 'Instruments for measurement'],
            ['name' => 'Safety Equipment', 'description' => 'Protective gear and safety tools'],
        ];

        foreach ($categories as $category) {
            Category::firstOrCreate(
                ['name' => $category['name']],
                $category
            );
        }
    }
}
