<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rental_agreements', function (Blueprint $table) {
            $table->id();
            $table->foreignId('rental_id')->constrained()->cascadeOnDelete();
            $table->string('agreement_number')->unique();
            $table->dateTime('issued_at');
            $table->string('pdf_path')->nullable();
            $table->string('status')->default('pending'); // pending, signed, equipment_handed_over
            $table->dateTime('signed_at')->nullable();
            $table->dateTime('equipment_handed_over_at')->nullable();
            $table->timestamps();
            
            $table->index('agreement_number');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rental_agreements');
    }
};





