<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (DB::getDriverName() === 'sqlite') {
            DB::statement('PRAGMA foreign_keys=OFF;');

            DB::statement('
                CREATE TABLE stocks_new (
                    id INTEGER PRIMARY KEY AUTOINCREMENT,
                    shop_id INTEGER NOT NULL,
                    equipment_id INTEGER NOT NULL,
                    quantity INTEGER NOT NULL DEFAULT 0,
                    reserved INTEGER NOT NULL DEFAULT 0,
                    minimum_threshold INTEGER,
                    created_at DATETIME,
                    updated_at DATETIME,
                    FOREIGN KEY (shop_id) REFERENCES shops(id) ON DELETE CASCADE,
                    FOREIGN KEY (equipment_id) REFERENCES equipments(id) ON DELETE CASCADE,
                    UNIQUE(shop_id, equipment_id)
                )
            ');

            DB::statement('INSERT INTO stocks_new SELECT * FROM stocks;');
            DB::statement('DROP TABLE stocks;');
            DB::statement('ALTER TABLE stocks_new RENAME TO stocks;');
            DB::statement('CREATE UNIQUE INDEX stocks_shop_id_equipment_id_unique ON stocks(shop_id, equipment_id);');

            DB::statement('PRAGMA foreign_keys=ON;');
        } else {
            Schema::table('stocks', function (Blueprint $table) {
                $table->dropForeign(['equipment_id']);
            });

            Schema::table('stocks', function (Blueprint $table) {
                $table->foreign('equipment_id')->references('id')->on('equipments')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert if needed
    }
};
