<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (DB::getDriverName() === 'sqlite') {
            DB::statement('PRAGMA foreign_keys=OFF;');

            DB::statement('
                CREATE TABLE stock_movements_new (
                    id INTEGER PRIMARY KEY AUTOINCREMENT,
                    shop_id INTEGER NOT NULL,
                    equipment_id INTEGER NOT NULL,
                    movement_type VARCHAR NOT NULL,
                    quantity INTEGER NOT NULL,
                    reference_type VARCHAR,
                    reference_id INTEGER,
                    notes TEXT,
                    created_by INTEGER NOT NULL,
                    created_at DATETIME NOT NULL,
                    FOREIGN KEY (shop_id) REFERENCES shops(id) ON DELETE CASCADE,
                    FOREIGN KEY (equipment_id) REFERENCES equipments(id) ON DELETE CASCADE,
                    FOREIGN KEY (created_by) REFERENCES users(id)
                )
            ');

            DB::statement('INSERT INTO stock_movements_new SELECT * FROM stock_movements;');
            DB::statement('DROP TABLE stock_movements;');
            DB::statement('ALTER TABLE stock_movements_new RENAME TO stock_movements;');
            DB::statement('CREATE INDEX stock_movements_reference_type_reference_id_index ON stock_movements(reference_type, reference_id);');
            DB::statement('CREATE INDEX stock_movements_movement_type_index ON stock_movements(movement_type);');

            DB::statement('PRAGMA foreign_keys=ON;');
        } else {
            Schema::table('stock_movements', function (Blueprint $table) {
                $table->dropForeign(['equipment_id']);
            });

            Schema::table('stock_movements', function (Blueprint $table) {
                $table->foreign('equipment_id')->references('id')->on('equipments')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert if needed
    }
};
