<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  public function up(): void
  {
    Schema::create('rental_items', function (Blueprint $table) {
      $table->id();

      // Rental FK
      $table->foreignId('rental_id')
        ->constrained('rentals') // ✅ match actual table name
        ->cascadeOnDelete();

      // Equipment FK
      $table->foreignId('equipment_id')
        ->constrained('equipments') // ✅ match actual table name
        ->cascadeOnDelete();

      $table->integer('quantity');
      $table->decimal('hourly_rate', 10, 2); // snapshot from equipment at rental time
      $table->decimal('hours', 8, 2);        // duration used or expected
      $table->decimal('subtotal', 12, 2);
      $table->text('serial_numbers')->nullable(); // JSON or comma list if serial-tracked

      $table->timestamps();
    });
  }

  public function down(): void
  {
    Schema::dropIfExists('rental_items');
  }
};
