<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  public function up(): void
  {
    Schema::create('stock_movements', function (Blueprint $table) {
      $table->id();

      // Shop foreign key
      $table->foreignId('shop_id')
        ->constrained('shops')
        ->cascadeOnDelete();

      // Equipment foreign key
      $table->foreignId('equipment_id')
        ->constrained('equipments') // ✅ match actual table name
        ->cascadeOnDelete();

      // Movement details
      $table->string('movement_type'); // in, out, rental_reserve, return, adjustment
      $table->integer('quantity');

      // Polymorphic reference
      $table->string('reference_type')->nullable();
      $table->unsignedBigInteger('reference_id')->nullable();

      // User who created this movement
      $table->foreignId('created_by')
        ->constrained('users');

      $table->text('notes')->nullable();

      $table->timestamps(); // ✅ includes created_at and updated_at

      // Indexes
      $table->index(['reference_type', 'reference_id']);
      $table->index('movement_type');
    });
  }

  public function down(): void
  {
    Schema::dropIfExists('stock_movements');
  }
};
