<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('stocks', function (Blueprint $table) {
      $table->id();

      // Shop foreign key
      $table->foreignId('shop_id')
        ->constrained('shops') // explicit table name
        ->cascadeOnDelete();

      // Equipment foreign key
      $table->foreignId('equipment_id')
        ->constrained('equipments') // explicit table name
        ->cascadeOnDelete();

      $table->integer('quantity')->default(0);
      $table->integer('reserved')->default(0);
      $table->integer('minimum_threshold')->nullable();
      $table->timestamps();

      // Unique combination of shop + equipment
      $table->unique(['shop_id', 'equipment_id']);
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('stocks');
  }
};
