<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('equipments', function (Blueprint $table) {
      $table->id(); // unsignedBigInteger primary key
      $table->string('sku')->nullable()->unique();
      $table->string('name');
      $table->foreignId('category_id')->nullable()->constrained()->nullOnDelete();
      $table->text('description')->nullable();
      $table->decimal('hourly_rate', 10, 2)->default(0);
      $table->decimal('replacement_cost', 12, 2)->default(0);
      $table->boolean('is_serial_tracked')->default(false);
      $table->timestamps();
      $table->softDeletes();

      $table->index('sku');
      $table->index('category_id');
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('equipments');
  }
};
