<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::table('users', function (Blueprint $table) {
      $table->foreignId('role_id')->after('password')->constrained('roles')->cascadeOnUpdate()->cascadeOnDelete();
      $table->foreignId('shop_id')->nullable()->after('role_id')->constrained('shops')->nullOnDelete();
      $table->boolean('approved')->default(false)->after('shop_id');
      $table->boolean('locked')->default(false)->after('approved');
      $table->string('phone')->nullable()->after('locked');
      $table->softDeletes()->after('remember_token');
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::table('users', function (Blueprint $table) {
      $table->dropForeign(['role_id']);
      $table->dropForeign(['shop_id']);
      $table->dropColumn(['role_id', 'shop_id', 'approved', 'locked', 'phone', 'deleted_at']);
    });
  }
};
