<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('shops', function (Blueprint $table) {
      $table->id(); // Primary key
      $table->string('name'); // Shop name
      $table->string('code')->unique(); // Unique shop code
      $table->text('address'); // Shop address
      $table->string('phone'); // Shop phone number
      $table->foreignId('manager_user_id') // Optional manager user
      ->nullable()
        ->constrained('users') // Reference users table
        ->nullOnDelete(); // If user deleted, set null
      $table->timestamps(); // created_at and updated_at
      $table->softDeletes(); // deleted_at for soft deletes
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('shops');
  }
};
