<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\User>
 */
class UserFactory extends Factory
{
  /**
   * The current password being used by the factory.
   */
  protected static ?string $password;

  /**
   * Define the model's default state.
   *
   * @return array<string, mixed>
   */
  public function definition(): array
  {
    return [
      'name' => fake()->name(),
      'email' => fake()->unique()->safeEmail(),
      'email_verified_at' => now(),
      'password' => static::$password ??= Hash::make('password'),
      'remember_token' => Str::random(10),

      // Dummy values for role_id and shop_id
      'role_id' => fake()->numberBetween(1, 3), // e.g., 1=Admin, 2=Manager, 3=Staff
      'shop_id' => fake()->numberBetween(1, 10), // random shop id, nullable optional
      'approved' => fake()->boolean(80), // 80% chance approved
      'locked' => fake()->boolean(10),   // 10% chance locked
      'phone' => fake()->phoneNumber(),
    ];
  }

  /**
   * Indicate that the model's email address should be unverified.
   */
  public function unverified(): static
  {
    return $this->state(fn (array $attributes) => [
      'email_verified_at' => null,
    ]);
  }

  /**
   * Indicate that the user is locked.
   */
  public function locked(): static
  {
    return $this->state(fn (array $attributes) => [
      'locked' => true,
    ]);
  }

  /**
   * Indicate that the user is unapproved.
   */
  public function unapproved(): static
  {
    return $this->state(fn (array $attributes) => [
      'approved' => false,
    ]);
  }
}
