<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Shop>
 */
class ShopFactory extends Factory
{
  /**
   * Define the model's default state.
   *
   * @return array<string, mixed>
   */
  public function definition(): array
  {
    return [
      'name' => fake()->company(),
      'code' => strtoupper(Str::random(5)), // Unique shop code
      'address' => fake()->address(),
      'phone' => fake()->phoneNumber(),
      'manager_user_id' => null, // Optional, can assign a user later
    ];
  }
}
