<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Role>
 */
class RoleFactory extends Factory
{
  /**
   * Define the model's default state.
   *
   * @return array<string, mixed>
   */
  public function definition(): array
  {
    $roles = [
      ['name' => 'admin', 'display_name' => 'Administrator'],
      ['name' => 'manager', 'display_name' => 'Shop Manager'],
      ['name' => 'staff', 'display_name' => 'Staff Member'],
    ];

    // Pick a random role from predefined roles
    return $roles[array_rand($roles)];
  }
}
