-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: localhost
-- Generation Time: Dec 24, 2025 at 11:00 AM
-- Server version: 10.4.28-MariaDB
-- PHP Version: 8.2.4

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `chalanatoolstation`
--

-- --------------------------------------------------------

--
-- Table structure for table `cache`
--

CREATE TABLE `cache` (
  `key` varchar(255) NOT NULL,
  `value` mediumtext NOT NULL,
  `expiration` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cache_locks`
--

CREATE TABLE `cache_locks` (
  `key` varchar(255) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expiration` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` (`id`, `name`, `description`, `created_at`, `updated_at`) VALUES
(1, 'Power Tools', 'Electric and battery-powered tools', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(2, 'Hand Tools', 'Manual tools for various tasks', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(3, 'Construction Equipment', 'Heavy machinery for construction', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(4, 'Garden Tools', 'Tools for gardening and landscaping', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(5, 'Measuring Tools', 'Instruments for measurement', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(6, 'Safety Equipment', 'Protective gear and safety tools', '2025-12-24 04:27:28', '2025-12-24 04:27:28');

-- --------------------------------------------------------

--
-- Table structure for table `customers`
--

CREATE TABLE `customers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `address` text DEFAULT NULL,
  `phone` varchar(255) NOT NULL,
  `nic_number` varchar(255) DEFAULT NULL,
  `profile_image` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `documents`
--

CREATE TABLE `documents` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `customer_id` bigint(20) UNSIGNED DEFAULT NULL,
  `user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) UNSIGNED NOT NULL,
  `file_path` varchar(255) NOT NULL,
  `file_type` varchar(255) DEFAULT NULL,
  `document_type` varchar(255) DEFAULT NULL,
  `document_name` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `equipments`
--

CREATE TABLE `equipments` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `sku` varchar(255) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `category_id` bigint(20) UNSIGNED DEFAULT NULL,
  `description` text DEFAULT NULL,
  `daily_rate` decimal(10,2) NOT NULL DEFAULT 0.00,
  `replacement_cost` decimal(12,2) NOT NULL DEFAULT 0.00,
  `is_serial_tracked` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `equipments`
--

INSERT INTO `equipments` (`id`, `sku`, `name`, `category_id`, `description`, `daily_rate`, `replacement_cost`, `is_serial_tracked`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 'EQ-DRILL-001', 'Drill Machine', 1, 'Electric drill machine with multiple speed settings', 500.00, 15000.00, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28', NULL),
(2, 'EQ-CSAW-001', 'Circular Saw', 1, 'Heavy-duty circular saw for cutting wood and metal', 750.00, 25000.00, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28', NULL),
(3, 'EQ-HAMM-001', 'Hammer Set', 2, 'Professional hammer set with different sizes', 200.00, 3000.00, 0, '2025-12-24 04:27:28', '2025-12-24 04:27:28', NULL),
(4, 'EQ-SCREW-001', 'Screwdriver Set', 2, 'Complete screwdriver set with various sizes', 150.00, 2000.00, 0, '2025-12-24 04:27:28', '2025-12-24 04:27:28', NULL),
(5, 'EQ-CMIX-001', 'Concrete Mixer', 3, 'Portable concrete mixer for construction projects', 2000.00, 150000.00, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28', NULL),
(6, 'EQ-MTAP-001', 'Measuring Tape', 5, 'Professional measuring tape 50 feet', 100.00, 1500.00, 0, '2025-12-24 04:27:28', '2025-12-24 04:27:28', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `invoices`
--

CREATE TABLE `invoices` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `rental_id` bigint(20) UNSIGNED NOT NULL,
  `invoice_number` varchar(255) NOT NULL,
  `issued_at` datetime NOT NULL,
  `due_date` datetime DEFAULT NULL,
  `pdf_path` varchar(255) DEFAULT NULL,
  `amount` decimal(12,2) NOT NULL,
  `status` varchar(255) NOT NULL DEFAULT 'unpaid',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jobs`
--

CREATE TABLE `jobs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `queue` varchar(255) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) UNSIGNED NOT NULL,
  `reserved_at` int(10) UNSIGNED DEFAULT NULL,
  `available_at` int(10) UNSIGNED NOT NULL,
  `created_at` int(10) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `job_batches`
--

CREATE TABLE `job_batches` (
  `id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `total_jobs` int(11) NOT NULL,
  `pending_jobs` int(11) NOT NULL,
  `failed_jobs` int(11) NOT NULL,
  `failed_job_ids` longtext NOT NULL,
  `options` mediumtext DEFAULT NULL,
  `cancelled_at` int(11) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `finished_at` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `losses`
--

CREATE TABLE `losses` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `rental_item_id` bigint(20) UNSIGNED NOT NULL,
  `shop_id` bigint(20) UNSIGNED NOT NULL,
  `type` varchar(255) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `notes` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `migrations`
--

CREATE TABLE `migrations` (
  `id` int(10) UNSIGNED NOT NULL,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `migrations`
--

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1, '0001_01_01_000001_create_cache_table', 1),
(2, '0001_01_01_000002_create_jobs_table', 1),
(3, '2025_10_28_195016_create_personal_access_tokens_table', 1),
(4, '2025_10_28_195110_create_users_table', 1),
(5, '2025_10_28_195114_create_shop_table', 1),
(6, '2025_10_28_195115_create_roles_table', 1),
(7, '2025_10_28_205414_add_fields_to_users_table', 1),
(8, '2025_11_15_061709_create_categories_table', 1),
(9, '2025_11_15_061710_create_equipments_table', 1),
(10, '2025_11_15_061710_create_stocks_table', 1),
(11, '2025_11_15_061711_create_customers_table', 1),
(12, '2025_11_15_061711_create_stock_movements_table', 1),
(13, '2025_11_15_061712_create_documents_table', 1),
(14, '2025_11_15_061712_create_rentals_table', 1),
(15, '2025_11_15_061713_create_rental_items_table', 1),
(16, '2025_11_15_061713_create_returns_table', 1),
(17, '2025_11_15_061714_create_invoices_table', 1),
(18, '2025_11_15_061714_create_losses_table', 1),
(19, '2025_11_15_061715_create_payments_table', 1),
(20, '2025_11_15_113605_fix_rental_items_equipment_foreign_key', 1),
(21, '2025_11_15_113641_fix_stock_movements_equipment_foreign_key', 1),
(22, '2025_11_15_113641_fix_stocks_equipment_foreign_key', 1),
(23, '2025_12_04_134217_create_rental_agreements_table', 1),
(24, '2025_12_04_162107_add_due_date_to_invoices_table', 1),
(25, '2025_12_04_175330_add_guarantee_fields_to_rentals_table', 1),
(26, '2025_12_04_182455_add_document_type_to_documents_table', 1),
(27, '2025_12_04_182455_add_profile_image_to_users_and_customers', 1),
(28, '2025_12_21_021720_change_hourly_rate_to_daily_rate', 1),
(29, '2025_12_21_045122_create_permissions_table', 1),
(30, '2025_12_21_045122_create_user_permissions_table', 1),
(31, '2025_12_21_045123_create_role_permissions_table', 1);

-- --------------------------------------------------------

--
-- Table structure for table `password_reset_tokens`
--

CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `payments`
--

CREATE TABLE `payments` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `invoice_id` bigint(20) UNSIGNED DEFAULT NULL,
  `rental_id` bigint(20) UNSIGNED DEFAULT NULL,
  `paid_by` bigint(20) UNSIGNED NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `method` varchar(255) NOT NULL,
  `paid_at` datetime NOT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `permissions`
--

CREATE TABLE `permissions` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `module` varchar(255) NOT NULL,
  `action` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `permissions`
--

INSERT INTO `permissions` (`id`, `name`, `module`, `action`, `description`, `created_at`, `updated_at`) VALUES
(1, 'dashboard.view', 'dashboard', 'view', 'View Dashboard', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(2, 'dashboard.total_rentals', 'dashboard', 'total_rentals', 'View Total Rentals Widget', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(3, 'dashboard.active_rentals', 'dashboard', 'active_rentals', 'View Active Rentals Widget', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(4, 'dashboard.total_revenue', 'dashboard', 'total_revenue', 'View Total Revenue Widget', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(5, 'dashboard.today_revenue', 'dashboard', 'today_revenue', 'View Today\'s Revenue Widget', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(6, 'dashboard.total_customers', 'dashboard', 'total_customers', 'View Total Customers Widget', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(7, 'dashboard.total_equipment', 'dashboard', 'total_equipment', 'View Total Equipment Widget', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(8, 'dashboard.active_stock', 'dashboard', 'active_stock', 'View Active Stock Widget', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(9, 'dashboard.revenue_chart', 'dashboard', 'revenue_chart', 'View Revenue Chart', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(10, 'dashboard.status_chart', 'dashboard', 'status_chart', 'View Status Distribution Chart', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(11, 'dashboard.equipment_chart', 'dashboard', 'equipment_chart', 'View Equipment Utilization Chart', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(12, 'dashboard.daily_rentals_chart', 'dashboard', 'daily_rentals_chart', 'View Daily Rentals Chart', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(13, 'shops.view', 'shops', 'view', 'View Shops', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(14, 'shops.create', 'shops', 'create', 'Create Shop', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(15, 'shops.update', 'shops', 'update', 'Update Shop', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(16, 'shops.delete', 'shops', 'delete', 'Delete Shop', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(17, 'users.view', 'users', 'view', 'View Users', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(18, 'users.create', 'users', 'create', 'Create User', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(19, 'users.update', 'users', 'update', 'Update User', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(20, 'users.delete', 'users', 'delete', 'Delete User', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(21, 'categories.view', 'categories', 'view', 'View Categories', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(22, 'categories.create', 'categories', 'create', 'Create Category', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(23, 'categories.update', 'categories', 'update', 'Update Category', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(24, 'categories.delete', 'categories', 'delete', 'Delete Category', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(25, 'equipments.view', 'equipments', 'view', 'View Equipments', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(26, 'equipments.create', 'equipments', 'create', 'Create Equipment', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(27, 'equipments.update', 'equipments', 'update', 'Update Equipment', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(28, 'equipments.delete', 'equipments', 'delete', 'Delete Equipment', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(29, 'stocks.view', 'stocks', 'view', 'View Stocks', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(30, 'stocks.create', 'stocks', 'create', 'Create Stock', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(31, 'stocks.update', 'stocks', 'update', 'Update Stock', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(32, 'stocks.delete', 'stocks', 'delete', 'Delete Stock', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(33, 'customers.view', 'customers', 'view', 'View Customers', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(34, 'customers.create', 'customers', 'create', 'Create Customer', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(35, 'customers.update', 'customers', 'update', 'Update Customer', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(36, 'customers.delete', 'customers', 'delete', 'Delete Customer', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(37, 'rentals.view', 'rentals', 'view', 'View Rentals', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(38, 'rentals.create', 'rentals', 'create', 'Create Rental', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(39, 'rentals.update', 'rentals', 'update', 'Update Rental', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(40, 'rentals.delete', 'rentals', 'delete', 'Delete Rental', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(41, 'permissions.view', 'permissions', 'view', 'View Permissions', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(42, 'permissions.update', 'permissions', 'update', 'Update Permissions', '2025-12-24 04:27:28', '2025-12-24 04:27:28');

-- --------------------------------------------------------

--
-- Table structure for table `personal_access_tokens`
--

CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `tokenable_type` varchar(255) NOT NULL,
  `tokenable_id` bigint(20) UNSIGNED NOT NULL,
  `name` text NOT NULL,
  `token` varchar(64) NOT NULL,
  `abilities` text DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rentals`
--

CREATE TABLE `rentals` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `shop_id` bigint(20) UNSIGNED NOT NULL,
  `customer_id` bigint(20) UNSIGNED DEFAULT NULL,
  `customer_snapshot` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`customer_snapshot`)),
  `rented_by` bigint(20) UNSIGNED NOT NULL,
  `status` varchar(255) NOT NULL DEFAULT 'draft',
  `rental_date` datetime NOT NULL,
  `expected_return_date` datetime DEFAULT NULL,
  `actual_return_date` datetime DEFAULT NULL,
  `remarks` text DEFAULT NULL,
  `guarantee_type` varchar(255) DEFAULT NULL,
  `guarantee_details` text DEFAULT NULL,
  `total_amount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `discount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `grand_total` decimal(12,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rental_agreements`
--

CREATE TABLE `rental_agreements` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `rental_id` bigint(20) UNSIGNED NOT NULL,
  `agreement_number` varchar(255) NOT NULL,
  `issued_at` datetime NOT NULL,
  `pdf_path` varchar(255) DEFAULT NULL,
  `status` varchar(255) NOT NULL DEFAULT 'pending',
  `signed_at` datetime DEFAULT NULL,
  `equipment_handed_over_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rental_items`
--

CREATE TABLE `rental_items` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `rental_id` bigint(20) UNSIGNED NOT NULL,
  `equipment_id` bigint(20) UNSIGNED NOT NULL,
  `quantity` int(11) NOT NULL,
  `daily_rate` decimal(10,2) NOT NULL,
  `days` decimal(8,2) NOT NULL,
  `subtotal` decimal(12,2) NOT NULL,
  `serial_numbers` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `returns`
--

CREATE TABLE `returns` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `rental_id` bigint(20) UNSIGNED NOT NULL,
  `returned_by` bigint(20) UNSIGNED NOT NULL,
  `return_date` datetime NOT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `roles`
--

CREATE TABLE `roles` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `display_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `roles`
--

INSERT INTO `roles` (`id`, `name`, `display_name`, `created_at`, `updated_at`) VALUES
(1, 'admin', 'Administrator', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(2, 'manager', 'Shop Manager', '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(3, 'staff', 'Staff Member', '2025-12-24 04:27:28', '2025-12-24 04:27:28');

-- --------------------------------------------------------

--
-- Table structure for table `role_permissions`
--

CREATE TABLE `role_permissions` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `role_id` bigint(20) UNSIGNED NOT NULL,
  `permission_id` bigint(20) UNSIGNED NOT NULL,
  `granted` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `role_permissions`
--

INSERT INTO `role_permissions` (`id`, `role_id`, `permission_id`, `granted`, `created_at`, `updated_at`) VALUES
(1, 1, 1, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(2, 1, 2, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(3, 1, 3, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(4, 1, 4, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(5, 1, 5, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(6, 1, 6, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(7, 1, 7, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(8, 1, 8, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(9, 1, 9, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(10, 1, 10, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(11, 1, 11, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(12, 1, 12, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(13, 1, 13, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(14, 1, 14, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(15, 1, 15, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(16, 1, 16, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(17, 1, 17, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(18, 1, 18, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(19, 1, 19, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(20, 1, 20, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(21, 1, 21, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(22, 1, 22, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(23, 1, 23, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(24, 1, 24, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(25, 1, 25, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(26, 1, 26, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(27, 1, 27, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(28, 1, 28, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(29, 1, 29, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(30, 1, 30, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(31, 1, 31, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(32, 1, 32, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(33, 1, 33, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(34, 1, 34, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(35, 1, 35, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(36, 1, 36, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(37, 1, 37, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(38, 1, 38, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(39, 1, 39, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(40, 1, 40, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(41, 1, 41, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(42, 1, 42, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(43, 2, 1, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(44, 2, 2, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(45, 2, 3, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(46, 2, 4, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(47, 2, 5, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(48, 2, 6, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(49, 2, 7, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(50, 2, 8, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(51, 2, 9, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(52, 2, 10, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(53, 2, 11, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(54, 2, 12, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(55, 2, 13, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(56, 2, 17, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(57, 2, 21, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(58, 2, 25, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(59, 2, 29, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(60, 2, 33, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(61, 2, 37, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(62, 2, 41, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28'),
(63, 3, 1, 1, '2025-12-24 04:27:28', '2025-12-24 04:27:28');

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `id` varchar(255) NOT NULL,
  `user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `payload` longtext NOT NULL,
  `last_activity` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `sessions`
--

INSERT INTO `sessions` (`id`, `user_id`, `ip_address`, `user_agent`, `payload`, `last_activity`) VALUES
('aLnPb2FUCp3kTUehPUb1od6c7twKrRAfl7TuDpFr', 11, '127.0.0.1', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', 'YTo0OntzOjY6Il90b2tlbiI7czo0MDoiQjR5WlBYaVh1eTBaMjNicGFFc0wxOUE4YUJEaFJpcjFyd2M2NTFTdCI7czo5OiJfcHJldmlvdXMiO2E6Mjp7czozOiJ1cmwiO3M6Mjc6Imh0dHA6Ly8xMjcuMC4wLjE6ODAwMC9zaG9wcyI7czo1OiJyb3V0ZSI7czo1OiJzaG9wcyI7fXM6NjoiX2ZsYXNoIjthOjI6e3M6Mzoib2xkIjthOjA6e31zOjM6Im5ldyI7YTowOnt9fXM6NTA6ImxvZ2luX3dlYl81OWJhMzZhZGRjMmIyZjk0MDE1ODBmMDE0YzdmNThlYTRlMzA5ODlkIjtpOjExO30=', 1766570312);

-- --------------------------------------------------------

--
-- Table structure for table `shops`
--

CREATE TABLE `shops` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `address` text NOT NULL,
  `phone` varchar(255) NOT NULL,
  `manager_user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `shops`
--

INSERT INTO `shops` (`id`, `name`, `code`, `address`, `phone`, `manager_user_id`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 'Ocean View Store', 'OV003', '12 Ocean View Road, City', '+94 11 2345678', NULL, '2025-12-24 04:27:28', '2025-12-24 04:27:28', NULL),
(2, 'Hilltop Mall Shop', 'HM004', '78 Hilltop Mall, City', '+94 11 3456789', NULL, '2025-12-24 04:27:28', '2025-12-24 04:27:28', NULL),
(3, 'Riverbank Shop', 'RB005', '90 Riverbank Street, City', '+94 11 4567890', NULL, '2025-12-24 04:27:28', '2025-12-24 04:27:28', NULL),
(4, 'Sunset Boulevard Store', 'SB006', '22 Sunset Boulevard, City', '+94 11 5678901', NULL, '2025-12-24 04:27:28', '2025-12-24 04:27:28', NULL),
(5, 'Downtown Plaza Shop', 'DP007', '55 Downtown Plaza, City', '+94 11 6789012', NULL, '2025-12-24 04:27:28', '2025-12-24 04:27:28', NULL),
(6, 'Greenfield Mall Shop', 'GM008', '11 Greenfield Mall, City', '+94 11 7890123', NULL, '2025-12-24 04:27:28', '2025-12-24 04:27:28', NULL),
(7, 'Lakeside Store', 'LS009', '33 Lakeside Avenue, City', '+94 11 8901234', NULL, '2025-12-24 04:27:28', '2025-12-24 04:27:28', NULL),
(8, 'Parkview Shop', 'PV010', '44 Parkview Road, City', '+94 11 9012345', NULL, '2025-12-24 04:27:28', '2025-12-24 04:27:28', NULL),
(9, 'City Center Store', 'CC011', '66 City Center Street, City', '+94 11 0123456', NULL, '2025-12-24 04:27:28', '2025-12-24 04:27:28', NULL),
(10, 'Maple Street Shop', 'MS012', '77 Maple Street, City', '+94 11 1230987', NULL, '2025-12-24 04:27:28', '2025-12-24 04:27:28', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `stocks`
--

CREATE TABLE `stocks` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `shop_id` bigint(20) UNSIGNED NOT NULL,
  `equipment_id` bigint(20) UNSIGNED NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `reserved` int(11) NOT NULL DEFAULT 0,
  `minimum_threshold` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `stock_movements`
--

CREATE TABLE `stock_movements` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `shop_id` bigint(20) UNSIGNED NOT NULL,
  `equipment_id` bigint(20) UNSIGNED NOT NULL,
  `movement_type` varchar(255) NOT NULL,
  `quantity` int(11) NOT NULL,
  `reference_type` varchar(255) DEFAULT NULL,
  `reference_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_by` bigint(20) UNSIGNED NOT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `role_id` bigint(20) UNSIGNED NOT NULL,
  `shop_id` bigint(20) UNSIGNED DEFAULT NULL,
  `approved` tinyint(1) NOT NULL DEFAULT 0,
  `locked` tinyint(1) NOT NULL DEFAULT 0,
  `phone` varchar(255) DEFAULT NULL,
  `profile_image` varchar(255) DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `name`, `email`, `email_verified_at`, `password`, `role_id`, `shop_id`, `approved`, `locked`, `phone`, `profile_image`, `remember_token`, `deleted_at`, `created_at`, `updated_at`) VALUES
(1, 'Duncan Kunze', 'ustrosin@example.org', '2025-12-24 04:27:28', '$2y$12$Vy.TUnsoCXAuqZmfzHJo9uP./Bbej4itUjJ3EkO5GPOi39wsKNQxG', 3, 4, 1, 0, '1-239-933-8258', NULL, 'prZBREyfGv', NULL, '2025-12-24 04:27:29', '2025-12-24 04:27:29'),
(2, 'Luther Mills', 'katrine88@example.com', '2025-12-24 04:27:29', '$2y$12$Vy.TUnsoCXAuqZmfzHJo9uP./Bbej4itUjJ3EkO5GPOi39wsKNQxG', 3, 10, 1, 1, '949-890-6887', NULL, 'xUjFGfCos9', NULL, '2025-12-24 04:27:29', '2025-12-24 04:27:29'),
(3, 'Orie Heaney', 'phackett@example.net', '2025-12-24 04:27:29', '$2y$12$Vy.TUnsoCXAuqZmfzHJo9uP./Bbej4itUjJ3EkO5GPOi39wsKNQxG', 3, 4, 1, 1, '1-986-935-8952', NULL, 'X2CCM830p1', NULL, '2025-12-24 04:27:29', '2025-12-24 04:27:29'),
(4, 'Prof. Winfield Mueller', 'cyril.fritsch@example.com', '2025-12-24 04:27:29', '$2y$12$Vy.TUnsoCXAuqZmfzHJo9uP./Bbej4itUjJ3EkO5GPOi39wsKNQxG', 1, 7, 1, 1, '678.919.5391', NULL, 'C9uhgstAoX', NULL, '2025-12-24 04:27:29', '2025-12-24 04:27:29'),
(5, 'Ramona Hickle', 'virginie60@example.com', '2025-12-24 04:27:29', '$2y$12$Vy.TUnsoCXAuqZmfzHJo9uP./Bbej4itUjJ3EkO5GPOi39wsKNQxG', 1, 4, 0, 0, '+1-818-873-8476', NULL, 'PTQkyLHILZ', NULL, '2025-12-24 04:27:29', '2025-12-24 04:27:29'),
(6, 'Abel Windler', 'cpollich@example.net', '2025-12-24 04:27:29', '$2y$12$Vy.TUnsoCXAuqZmfzHJo9uP./Bbej4itUjJ3EkO5GPOi39wsKNQxG', 2, 10, 1, 0, '+1.609.310.4819', NULL, 'ZgMxoxBwE7', NULL, '2025-12-24 04:27:29', '2025-12-24 04:27:29'),
(7, 'Dr. Chelsey White IV', 'sluettgen@example.org', '2025-12-24 04:27:29', '$2y$12$Vy.TUnsoCXAuqZmfzHJo9uP./Bbej4itUjJ3EkO5GPOi39wsKNQxG', 1, 2, 1, 0, '1-701-520-1494', NULL, 'BEW3ZPFbFa', NULL, '2025-12-24 04:27:29', '2025-12-24 04:27:29'),
(8, 'Mr. Delbert Satterfield III', 'jaime02@example.org', '2025-12-24 04:27:29', '$2y$12$Vy.TUnsoCXAuqZmfzHJo9uP./Bbej4itUjJ3EkO5GPOi39wsKNQxG', 2, 6, 1, 1, '317-705-4684', NULL, '6axYtsOixS', NULL, '2025-12-24 04:27:29', '2025-12-24 04:27:29'),
(9, 'Mrs. Joanie Wuckert V', 'rkshlerin@example.org', '2025-12-24 04:27:29', '$2y$12$Vy.TUnsoCXAuqZmfzHJo9uP./Bbej4itUjJ3EkO5GPOi39wsKNQxG', 2, 8, 1, 0, '(904) 897-7798', NULL, '4ZuHnPUlaO', NULL, '2025-12-24 04:27:29', '2025-12-24 04:27:29'),
(10, 'Charity Paucek', 'russel.ulices@example.net', '2025-12-24 04:27:29', '$2y$12$Vy.TUnsoCXAuqZmfzHJo9uP./Bbej4itUjJ3EkO5GPOi39wsKNQxG', 1, 10, 1, 0, '352.412.1875', NULL, '0fqzJxHSzS', NULL, '2025-12-24 04:27:29', '2025-12-24 04:27:29'),
(11, 'Test User', 'test@example.com', '2025-12-24 04:27:29', '$2y$12$Vy.TUnsoCXAuqZmfzHJo9uP./Bbej4itUjJ3EkO5GPOi39wsKNQxG', 2, 8, 1, 0, '1-551-620-4936', NULL, '71jZbuiVP7', NULL, '2025-12-24 04:27:29', '2025-12-24 04:27:29');

-- --------------------------------------------------------

--
-- Table structure for table `user_permissions`
--

CREATE TABLE `user_permissions` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `permission_id` bigint(20) UNSIGNED NOT NULL,
  `granted` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `cache`
--
ALTER TABLE `cache`
  ADD PRIMARY KEY (`key`);

--
-- Indexes for table `cache_locks`
--
ALTER TABLE `cache_locks`
  ADD PRIMARY KEY (`key`);

--
-- Indexes for table `categories`
--
ALTER TABLE `categories`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `customers`
--
ALTER TABLE `customers`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `documents`
--
ALTER TABLE `documents`
  ADD PRIMARY KEY (`id`),
  ADD KEY `documents_customer_id_foreign` (`customer_id`),
  ADD KEY `documents_user_id_foreign` (`user_id`),
  ADD KEY `documents_model_type_model_id_index` (`model_type`,`model_id`);

--
-- Indexes for table `equipments`
--
ALTER TABLE `equipments`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `equipments_sku_unique` (`sku`),
  ADD KEY `equipments_sku_index` (`sku`),
  ADD KEY `equipments_category_id_index` (`category_id`);

--
-- Indexes for table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`);

--
-- Indexes for table `invoices`
--
ALTER TABLE `invoices`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `invoices_invoice_number_unique` (`invoice_number`),
  ADD KEY `invoices_rental_id_foreign` (`rental_id`),
  ADD KEY `invoices_invoice_number_index` (`invoice_number`),
  ADD KEY `invoices_status_index` (`status`);

--
-- Indexes for table `jobs`
--
ALTER TABLE `jobs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `jobs_queue_index` (`queue`);

--
-- Indexes for table `job_batches`
--
ALTER TABLE `job_batches`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `losses`
--
ALTER TABLE `losses`
  ADD PRIMARY KEY (`id`),
  ADD KEY `losses_rental_item_id_foreign` (`rental_item_id`),
  ADD KEY `losses_shop_id_foreign` (`shop_id`);

--
-- Indexes for table `migrations`
--
ALTER TABLE `migrations`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `password_reset_tokens`
--
ALTER TABLE `password_reset_tokens`
  ADD PRIMARY KEY (`email`);

--
-- Indexes for table `payments`
--
ALTER TABLE `payments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `payments_paid_by_foreign` (`paid_by`),
  ADD KEY `payments_invoice_id_index` (`invoice_id`),
  ADD KEY `payments_rental_id_index` (`rental_id`);

--
-- Indexes for table `permissions`
--
ALTER TABLE `permissions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `permissions_name_unique` (`name`);

--
-- Indexes for table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  ADD KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`),
  ADD KEY `personal_access_tokens_expires_at_index` (`expires_at`);

--
-- Indexes for table `rentals`
--
ALTER TABLE `rentals`
  ADD PRIMARY KEY (`id`),
  ADD KEY `rentals_rented_by_foreign` (`rented_by`),
  ADD KEY `rentals_shop_id_index` (`shop_id`),
  ADD KEY `rentals_customer_id_index` (`customer_id`),
  ADD KEY `rentals_status_index` (`status`),
  ADD KEY `rentals_rental_date_index` (`rental_date`);

--
-- Indexes for table `rental_agreements`
--
ALTER TABLE `rental_agreements`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `rental_agreements_agreement_number_unique` (`agreement_number`),
  ADD KEY `rental_agreements_rental_id_foreign` (`rental_id`),
  ADD KEY `rental_agreements_agreement_number_index` (`agreement_number`),
  ADD KEY `rental_agreements_status_index` (`status`);

--
-- Indexes for table `rental_items`
--
ALTER TABLE `rental_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `rental_items_rental_id_foreign` (`rental_id`),
  ADD KEY `rental_items_equipment_id_foreign` (`equipment_id`);

--
-- Indexes for table `returns`
--
ALTER TABLE `returns`
  ADD PRIMARY KEY (`id`),
  ADD KEY `returns_rental_id_foreign` (`rental_id`),
  ADD KEY `returns_returned_by_foreign` (`returned_by`);

--
-- Indexes for table `roles`
--
ALTER TABLE `roles`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `roles_name_unique` (`name`);

--
-- Indexes for table `role_permissions`
--
ALTER TABLE `role_permissions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `role_permissions_role_id_permission_id_unique` (`role_id`,`permission_id`),
  ADD KEY `role_permissions_permission_id_foreign` (`permission_id`);

--
-- Indexes for table `sessions`
--
ALTER TABLE `sessions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `sessions_user_id_index` (`user_id`),
  ADD KEY `sessions_last_activity_index` (`last_activity`);

--
-- Indexes for table `shops`
--
ALTER TABLE `shops`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `shops_code_unique` (`code`),
  ADD KEY `shops_manager_user_id_foreign` (`manager_user_id`);

--
-- Indexes for table `stocks`
--
ALTER TABLE `stocks`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `stocks_shop_id_equipment_id_unique` (`shop_id`,`equipment_id`),
  ADD KEY `stocks_equipment_id_foreign` (`equipment_id`);

--
-- Indexes for table `stock_movements`
--
ALTER TABLE `stock_movements`
  ADD PRIMARY KEY (`id`),
  ADD KEY `stock_movements_shop_id_foreign` (`shop_id`),
  ADD KEY `stock_movements_created_by_foreign` (`created_by`),
  ADD KEY `stock_movements_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  ADD KEY `stock_movements_movement_type_index` (`movement_type`),
  ADD KEY `stock_movements_equipment_id_foreign` (`equipment_id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `users_email_unique` (`email`),
  ADD KEY `users_role_id_foreign` (`role_id`),
  ADD KEY `users_shop_id_foreign` (`shop_id`);

--
-- Indexes for table `user_permissions`
--
ALTER TABLE `user_permissions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `user_permissions_user_id_permission_id_unique` (`user_id`,`permission_id`),
  ADD KEY `user_permissions_permission_id_foreign` (`permission_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `categories`
--
ALTER TABLE `categories`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `customers`
--
ALTER TABLE `customers`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `documents`
--
ALTER TABLE `documents`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `equipments`
--
ALTER TABLE `equipments`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `invoices`
--
ALTER TABLE `invoices`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `jobs`
--
ALTER TABLE `jobs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `losses`
--
ALTER TABLE `losses`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `migrations`
--
ALTER TABLE `migrations`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=32;

--
-- AUTO_INCREMENT for table `payments`
--
ALTER TABLE `payments`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `permissions`
--
ALTER TABLE `permissions`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=43;

--
-- AUTO_INCREMENT for table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `rentals`
--
ALTER TABLE `rentals`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `rental_agreements`
--
ALTER TABLE `rental_agreements`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `rental_items`
--
ALTER TABLE `rental_items`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `returns`
--
ALTER TABLE `returns`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `roles`
--
ALTER TABLE `roles`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `role_permissions`
--
ALTER TABLE `role_permissions`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=64;

--
-- AUTO_INCREMENT for table `shops`
--
ALTER TABLE `shops`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `stocks`
--
ALTER TABLE `stocks`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `stock_movements`
--
ALTER TABLE `stock_movements`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `user_permissions`
--
ALTER TABLE `user_permissions`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `documents`
--
ALTER TABLE `documents`
  ADD CONSTRAINT `documents_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `documents_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `equipments`
--
ALTER TABLE `equipments`
  ADD CONSTRAINT `equipments_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `invoices`
--
ALTER TABLE `invoices`
  ADD CONSTRAINT `invoices_rental_id_foreign` FOREIGN KEY (`rental_id`) REFERENCES `rentals` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `losses`
--
ALTER TABLE `losses`
  ADD CONSTRAINT `losses_rental_item_id_foreign` FOREIGN KEY (`rental_item_id`) REFERENCES `rental_items` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `losses_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `payments`
--
ALTER TABLE `payments`
  ADD CONSTRAINT `payments_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `payments_paid_by_foreign` FOREIGN KEY (`paid_by`) REFERENCES `users` (`id`),
  ADD CONSTRAINT `payments_rental_id_foreign` FOREIGN KEY (`rental_id`) REFERENCES `rentals` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `rentals`
--
ALTER TABLE `rentals`
  ADD CONSTRAINT `rentals_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `rentals_rented_by_foreign` FOREIGN KEY (`rented_by`) REFERENCES `users` (`id`),
  ADD CONSTRAINT `rentals_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `rental_agreements`
--
ALTER TABLE `rental_agreements`
  ADD CONSTRAINT `rental_agreements_rental_id_foreign` FOREIGN KEY (`rental_id`) REFERENCES `rentals` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `rental_items`
--
ALTER TABLE `rental_items`
  ADD CONSTRAINT `rental_items_equipment_id_foreign` FOREIGN KEY (`equipment_id`) REFERENCES `equipments` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `rental_items_rental_id_foreign` FOREIGN KEY (`rental_id`) REFERENCES `rentals` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `returns`
--
ALTER TABLE `returns`
  ADD CONSTRAINT `returns_rental_id_foreign` FOREIGN KEY (`rental_id`) REFERENCES `rentals` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `returns_returned_by_foreign` FOREIGN KEY (`returned_by`) REFERENCES `users` (`id`);

--
-- Constraints for table `role_permissions`
--
ALTER TABLE `role_permissions`
  ADD CONSTRAINT `role_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `role_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `shops`
--
ALTER TABLE `shops`
  ADD CONSTRAINT `shops_manager_user_id_foreign` FOREIGN KEY (`manager_user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `stocks`
--
ALTER TABLE `stocks`
  ADD CONSTRAINT `stocks_equipment_id_foreign` FOREIGN KEY (`equipment_id`) REFERENCES `equipments` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `stocks_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `stock_movements`
--
ALTER TABLE `stock_movements`
  ADD CONSTRAINT `stock_movements_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  ADD CONSTRAINT `stock_movements_equipment_id_foreign` FOREIGN KEY (`equipment_id`) REFERENCES `equipments` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `stock_movements_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `users`
--
ALTER TABLE `users`
  ADD CONSTRAINT `users_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `users_shop_id_foreign` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `user_permissions`
--
ALTER TABLE `user_permissions`
  ADD CONSTRAINT `user_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `user_permissions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
