<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Stock extends Model
{
    use HasFactory;

    protected $fillable = [
        'shop_id',
        'equipment_id',
        'quantity',
        'reserved',
        'minimum_threshold',
    ];

    protected $casts = [
        'quantity' => 'integer',
        'reserved' => 'integer',
        'minimum_threshold' => 'integer',
    ];

    public function shop()
    {
        return $this->belongsTo(Shop::class);
    }

    public function equipment()
    {
        return $this->belongsTo(Equipment::class);
    }

    public function getAvailableAttribute()
    {
        return $this->quantity - $this->reserved;
    }
}
