<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Shop extends Model
{
  use HasFactory, SoftDeletes;

  protected $fillable = ['name', 'code', 'address', 'phone', 'manager_user_id'];

  public function users()
  {
    return $this->hasMany(User::class);
  }

  public function stocks()
  {
    return $this->hasMany(Stock::class);
  }

  public function rentals()
  {
    return $this->hasMany(Rental::class);
  }

  public function manager()
  {
    return $this->belongsTo(User::class, 'manager_user_id');
  }

  public function stockMovements()
  {
    return $this->hasMany(StockMovement::class);
  }

  public function losses()
  {
    return $this->hasMany(Loss::class);
  }
}
