<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RentalItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'rental_id',
        'equipment_id',
        'quantity',
        'daily_rate',
        'days',
        'subtotal',
        'serial_numbers',
    ];

    protected $casts = [
        'quantity' => 'integer',
        'daily_rate' => 'decimal:2',
        'days' => 'decimal:2',
        'subtotal' => 'decimal:2',
        'serial_numbers' => 'array',
    ];

    public function rental()
    {
        return $this->belongsTo(Rental::class);
    }

    public function equipment()
    {
        return $this->belongsTo(Equipment::class);
    }

    public function losses()
    {
        return $this->hasMany(Loss::class);
    }
}
