<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RentalAgreement extends Model
{
    use HasFactory;

    protected $fillable = [
        'rental_id',
        'agreement_number',
        'issued_at',
        'pdf_path',
        'status',
        'signed_at',
        'equipment_handed_over_at',
    ];

    protected $casts = [
        'issued_at' => 'datetime',
        'signed_at' => 'datetime',
        'equipment_handed_over_at' => 'datetime',
    ];

    public function rental()
    {
        return $this->belongsTo(Rental::class);
    }

    public function markAsSigned()
    {
        $this->update([
            'status' => 'signed',
            'signed_at' => now(),
        ]);
    }

    public function markEquipmentHandedOver()
    {
        $this->update([
            'status' => 'equipment_handed_over',
            'equipment_handed_over_at' => now(),
        ]);
    }

    public function canGenerateInvoice()
    {
        // Allow invoice generation if equipment is handed over
        if ($this->status === 'equipment_handed_over') {
            return true;
        }
        
        // Also allow if rental is returned (equipment is back)
        if (!$this->relationLoaded('rental')) {
            $this->load('rental');
        }
        
        return $this->rental && $this->rental->status === 'returned';
    }
}
