<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Rental extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'shop_id',
        'customer_id',
        'customer_snapshot',
        'rented_by',
        'status',
        'rental_date',
        'expected_return_date',
        'actual_return_date',
        'remarks',
        'guarantee_type',
        'guarantee_details',
        'total_amount',
        'discount',
        'grand_total',
    ];

    protected $casts = [
        'customer_snapshot' => 'array',
        'rental_date' => 'datetime',
        'expected_return_date' => 'datetime',
        'actual_return_date' => 'datetime',
        'total_amount' => 'decimal:2',
        'discount' => 'decimal:2',
        'grand_total' => 'decimal:2',
    ];

    public function shop()
    {
        return $this->belongsTo(Shop::class);
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function rentedBy()
    {
        return $this->belongsTo(User::class, 'rented_by');
    }

    public function rentalItems()
    {
        return $this->hasMany(RentalItem::class);
    }

    public function returns()
    {
        return $this->hasMany(RentalReturn::class);
    }

    public function agreement()
    {
        return $this->hasOne(RentalAgreement::class);
    }

    public function invoices()
    {
        return $this->hasMany(Invoice::class);
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    public function documents()
    {
        return $this->morphMany(Document::class, 'model');
    }
}
