<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Loss extends Model
{
    use HasFactory;

    protected $fillable = [
        'rental_item_id',
        'shop_id',
        'type',
        'amount',
        'notes',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
    ];

    public function rentalItem()
    {
        return $this->belongsTo(RentalItem::class);
    }

    public function shop()
    {
        return $this->belongsTo(Shop::class);
    }
}
