<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    use HasFactory;

    protected $fillable = [
        'rental_id',
        'invoice_number',
        'issued_at',
        'due_date',
        'pdf_path',
        'amount',
        'status',
    ];

    protected $casts = [
        'issued_at' => 'datetime',
        'due_date' => 'datetime',
        'amount' => 'decimal:2',
    ];

    public function rental()
    {
        return $this->belongsTo(Rental::class);
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    public function getPaidAmountAttribute()
    {
        return $this->payments()->sum('amount');
    }

    public function getRemainingAmountAttribute()
    {
        return $this->amount - $this->paid_amount;
    }

    /**
     * Check if invoice can be edited
     * Invoice can only be edited if no payment has been processed
     */
    public function canBeEdited()
    {
        return $this->payments()->count() === 0;
    }

    /**
     * Check if invoice is overdue
     */
    public function isOverdue()
    {
        if (!$this->due_date) {
            return false;
        }
        
        return now()->isAfter($this->due_date);
    }
}
