<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Equipment extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'equipments';

    protected $fillable = [
        'sku',
        'name',
        'category_id',
        'description',
        'daily_rate',
        'replacement_cost',
        'is_serial_tracked',
    ];

    protected $casts = [
        'daily_rate' => 'decimal:2',
        'replacement_cost' => 'decimal:2',
        'is_serial_tracked' => 'boolean',
    ];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function stocks()
    {
        return $this->hasMany(Stock::class);
    }

    public function rentalItems()
    {
        return $this->hasMany(RentalItem::class);
    }
}
